/*
 * Decompiled with CFR 0.152.
 */
package org.unitils;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.internal.runners.InitializationError;
import org.junit.internal.runners.MethodValidator;
import org.junit.internal.runners.TestClass;
import org.junit.runner.Runner;
import org.junit.runners.Parameterized;
import org.junit.runners.Suite;
import org.junit.runners.model.FrameworkMethod;
import org.unitils.UnitilsJUnit4TestClassRunner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnitilsParameterized
extends Suite {
    private Class<?> clazz;
    private static final Log LOGGER = LogFactory.getLog(UnitilsParameterized.class);
    private static final String METHOD = "Method ";
    private final List<Runner> runners = new ArrayList<Runner>();

    public UnitilsParameterized(Class<?> klass) throws Throwable {
        super(klass, Collections.emptyList());
        this.clazz = klass;
        List<Object[]> parametersList = this.getParametersList(this.getTestClass());
        for (int i = 0; i < parametersList.size(); ++i) {
            this.runners.add((Runner)new TestClassRunnerForParameters(this.getTestClass().getJavaClass(), parametersList, i));
        }
    }

    private List<Object[]> getParametersList(org.junit.runners.model.TestClass testClass) throws Exception, Throwable {
        return (List)this.getParametersMethod(testClass).invokeExplosively(null, new Object[0]);
    }

    protected FrameworkMethod getParametersMethod(org.junit.runners.model.TestClass testClass) throws Exception {
        List methods = testClass.getAnnotatedMethods(Parameterized.Parameters.class);
        for (FrameworkMethod each : methods) {
            int modifiers = each.getMethod().getModifiers();
            if (!Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) continue;
            return each;
        }
        throw new Exception("No public static parameters method on class " + testClass.getName());
    }

    protected List<Runner> getChildren() {
        return Collections.unmodifiableList(this.runners);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class UnitilsMethodValidator
    extends MethodValidator {
        private TestClass testclass;
        private List<Throwable> errors = new ArrayList<Throwable>();

        public UnitilsMethodValidator(TestClass testClass) {
            super(testClass);
            this.testclass = testClass;
        }

        public List<Throwable> validateMethodsForParameterizedRunner() {
            this.validateArgConstructor();
            this.validateStaticMethods();
            this.validateInstanceMethods();
            return this.errors;
        }

        protected void validateTestMethods(Class<? extends Annotation> annotation, boolean isStatic) {
            List methods = this.testclass.getAnnotatedMethods(annotation);
            for (Method each : methods) {
                if (Modifier.isStatic(each.getModifiers()) != isStatic) {
                    String state = isStatic ? "should" : "should not";
                    this.errors.add(new Exception(UnitilsParameterized.METHOD + each.getName() + "() " + state + " be static"));
                }
                if (!Modifier.isPublic(each.getDeclaringClass().getModifiers())) {
                    this.errors.add(new Exception("Class " + each.getDeclaringClass().getName() + " should be public"));
                }
                if (!Modifier.isPublic(each.getModifiers())) {
                    this.errors.add(new Exception(UnitilsParameterized.METHOD + each.getName() + " should be public"));
                }
                if (each.getReturnType() != Void.TYPE) {
                    this.errors.add(new Exception(UnitilsParameterized.METHOD + each.getName() + " should be void"));
                }
                if (each.getParameterTypes().length == 0) continue;
                this.errors.add(new Exception(UnitilsParameterized.METHOD + each.getName() + " should have no parameters"));
            }
        }

        public void validateInstanceMethods() {
            this.validateTestMethods(After.class, false);
            this.validateTestMethods(Before.class, false);
            this.validateTestMethods(Test.class, false);
            List methods = this.testclass.getAnnotatedMethods(Test.class);
            if (methods.size() == 0) {
                this.errors.add(new Exception("No runnable methods"));
            }
        }

        public void validateStaticMethods() {
            this.validateTestMethods(BeforeClass.class, true);
            this.validateTestMethods(AfterClass.class, true);
        }

        public void validateArgConstructor() {
            org.junit.runners.model.TestClass clazz = new org.junit.runners.model.TestClass(this.testclass.getJavaClass());
            Constructor onlyConstructor = clazz.getOnlyConstructor();
            if (onlyConstructor.getParameterTypes().length == 0) {
                this.errors.add(new Exception("Test class shouldn't have a public zero-argument constructor"));
            }
        }

        protected List<Throwable> getErrors() {
            return this.errors;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class TestClassRunnerForParameters
    extends UnitilsJUnit4TestClassRunner {
        private final int fParameterSetNumber;
        private final List<Object[]> fParameterList;
        private TestClass testClassInternalRunners;

        public TestClassRunnerForParameters(Class<?> javaClass, List<Object[]> parametersList, int i) throws Exception {
            super(javaClass);
            this.fParameterList = parametersList;
            this.fParameterSetNumber = i;
            this.testClassInternalRunners = new TestClass(javaClass);
        }

        protected Object createTest() throws Exception {
            return this.getfTestClass().getOnlyConstructor().newInstance(this.computeParams());
        }

        private org.junit.runners.model.TestClass getfTestClass() {
            return new org.junit.runners.model.TestClass(UnitilsParameterized.this.clazz);
        }

        protected Object[] computeParams() throws Exception {
            try {
                return this.fParameterList.get(this.fParameterSetNumber);
            }
            catch (ClassCastException e) {
                throw new Exception(String.format("%s.%s() must return a Collection of arrays.", this.getTestClass().getName(), UnitilsParameterized.this.getParametersMethod(this.getfTestClass()).getName()));
            }
        }

        protected String getName() {
            StringBuffer name = new StringBuffer();
            try {
                Object[] data;
                for (Object object : data = this.fParameterList.get(this.fParameterSetNumber)) {
                    if (object != null) {
                        name.append(object.toString());
                        name.append(",");
                        continue;
                    }
                    name.append("null,");
                }
            }
            catch (IndexOutOfBoundsException e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
            name = new StringBuffer(name.substring(0, name.length() - 1));
            return String.format("dataset [%s]", name.toString());
        }

        protected String testName(Method method) {
            return String.format("%s[%s]", method.getName(), this.fParameterSetNumber);
        }

        protected void validate() throws InitializationError {
            this.testClassInternalRunners = new TestClass(UnitilsParameterized.this.clazz);
            UnitilsMethodValidator validator = new UnitilsMethodValidator(this.testClassInternalRunners);
            List<Throwable> errors = validator.validateMethodsForParameterizedRunner();
            if (!errors.isEmpty()) {
                throw new InitializationError(errors);
            }
        }
    }
}

