/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.core.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.unitils.core.Factory;
import org.unitils.core.UnitilsException;
import org.unitils.core.config.UnitilsConfiguration;
import org.unitils.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configuration
extends UnitilsConfiguration {
    protected Properties properties;
    protected Properties overridingProperties;

    public Configuration(Properties properties) {
        super(properties);
        this.properties = properties;
    }

    public Properties getOverridingProperties() {
        return this.overridingProperties;
    }

    public void setOverridingProperties(Properties overridingProperties) {
        this.overridingProperties = overridingProperties;
    }

    public Properties getAllProperties() {
        Properties result = new Properties();
        result.putAll((Map<?, ?>)this.properties);
        if (this.overridingProperties != null) {
            result.putAll((Map<?, ?>)this.overridingProperties);
        }
        return result;
    }

    public String getString(String propertyName, String ... classifiers) {
        String value = this.getOptionalString(propertyName, classifiers);
        if (value == null) {
            throw new UnitilsException("No value found for " + this.nameToString(propertyName, classifiers));
        }
        return value;
    }

    public String getOptionalString(String propertyName, String ... classifiers) {
        String value = this.getProperty(propertyName);
        if (classifiers != null && classifiers.length > 0) {
            StringBuilder propertyNameWithClassifiers = new StringBuilder(propertyName);
            for (String classifier : classifiers) {
                if (classifier == null) continue;
                propertyNameWithClassifiers.append('.');
                propertyNameWithClassifiers.append(classifier.trim());
                String valueForClassifier = this.getProperty(propertyNameWithClassifiers.toString());
                if (valueForClassifier == null) continue;
                value = valueForClassifier;
            }
        }
        if (value == null) {
            return null;
        }
        if ("".equals(value = value.trim())) {
            return null;
        }
        return value;
    }

    public List<String> getStringList(String propertyName, String ... classifiers) {
        String value = this.getString(propertyName, classifiers);
        List<String> result = this.toStringList(value);
        if (result.isEmpty()) {
            throw new UnitilsException("No value found for " + this.nameToString(propertyName, classifiers));
        }
        return result;
    }

    public List<String> getOptionalStringList(String propertyName, String ... classifiers) {
        String value = this.getOptionalString(propertyName, classifiers);
        return this.toStringList(value);
    }

    public Boolean getBoolean(String propertyName, String ... classifiers) {
        String value = this.getString(propertyName, classifiers);
        return this.toBoolean(value, propertyName, classifiers);
    }

    public Boolean getOptionalBoolean(String propertyName, String ... classifiers) {
        String value = this.getOptionalString(propertyName, classifiers);
        return this.toBoolean(value, propertyName, classifiers);
    }

    public List<Boolean> getBooleanList(String propertyName, String ... classifiers) {
        List<Boolean> result = this.getOptionalBooleanList(propertyName, classifiers);
        if (result.isEmpty()) {
            throw new UnitilsException("No value found for " + this.nameToString(propertyName, classifiers));
        }
        return result;
    }

    public List<Boolean> getOptionalBooleanList(String propertyName, String ... classifiers) {
        List<String> values = this.getOptionalStringList(propertyName, classifiers);
        ArrayList<Boolean> result = new ArrayList<Boolean>(values.size());
        for (String value : values) {
            Boolean bool = this.toBoolean(value, propertyName, classifiers);
            result.add(bool);
        }
        return result;
    }

    public Integer getInteger(String propertyName, String ... classifiers) {
        String value = this.getString(propertyName, classifiers);
        return this.toInteger(value, propertyName, classifiers);
    }

    public Integer getOptionalInteger(String propertyName, String ... classifiers) {
        String value = this.getOptionalString(propertyName, classifiers);
        return this.toInteger(value, propertyName, classifiers);
    }

    public List<Integer> getIntegerList(String propertyName, String ... classifiers) {
        List<Integer> result = this.getOptionalIntegerList(propertyName, classifiers);
        if (result.isEmpty()) {
            throw new UnitilsException("No value found for " + this.nameToString(propertyName, classifiers));
        }
        return result;
    }

    public List<Integer> getOptionalIntegerList(String propertyName, String ... classifiers) {
        List<String> values = this.getOptionalStringList(propertyName, classifiers);
        ArrayList<Integer> result = new ArrayList<Integer>(values.size());
        for (String value : values) {
            Integer integer = this.toInteger(value, propertyName, classifiers);
            result.add(integer);
        }
        return result;
    }

    public Long getLong(String propertyName, String ... classifiers) {
        String value = this.getString(propertyName, classifiers);
        return this.toLong(value, propertyName, classifiers);
    }

    public Long getOptionalLong(String propertyName, String ... classifiers) {
        String value = this.getOptionalString(propertyName, classifiers);
        return this.toLong(value, propertyName, classifiers);
    }

    public List<Long> getLongList(String propertyName, String ... classifiers) {
        List<Long> result = this.getOptionalLongList(propertyName, classifiers);
        if (result.isEmpty()) {
            throw new UnitilsException("No value found for " + this.nameToString(propertyName, classifiers));
        }
        return result;
    }

    public List<Long> getOptionalLongList(String propertyName, String ... classifiers) {
        List<String> values = this.getOptionalStringList(propertyName, classifiers);
        ArrayList<Long> result = new ArrayList<Long>(values.size());
        for (String value : values) {
            Long longValue = this.toLong(value, propertyName, classifiers);
            result.add(longValue);
        }
        return result;
    }

    public Class<?> getClass(String propertyName, String ... classifiers) {
        String value = this.getString(propertyName, classifiers);
        return this.toClass(value, propertyName, classifiers);
    }

    public Class<?> getOptionalClass(String propertyName, String ... classifiers) {
        String value = this.getOptionalString(propertyName, classifiers);
        return this.toClass(value, propertyName, classifiers);
    }

    public List<Class<?>> getClassList(String propertyName, String ... classifiers) {
        List<Class<?>> result = this.getOptionalClassList(propertyName, classifiers);
        if (result.isEmpty()) {
            throw new UnitilsException("No value found for " + this.nameToString(propertyName, classifiers));
        }
        return result;
    }

    public List<Class<?>> getOptionalClassList(String propertyName, String ... classifiers) {
        List<String> values = this.getOptionalStringList(propertyName, classifiers);
        ArrayList result = new ArrayList(values.size());
        for (String value : values) {
            Class<?> clazz = this.toClass(value, propertyName, classifiers);
            result.add(clazz);
        }
        return result;
    }

    @Override
    public <T> T getInstanceOf(Class<T> type, String ... classifiers) {
        String propertyName = type.getName();
        String value = this.getString(propertyName, classifiers);
        return this.toInstance(type, value, propertyName, classifiers);
    }

    public <T> T getOptionalInstanceOf(Class<T> type, String ... classifiers) {
        String propertyName = type.getName();
        String value = this.getOptionalString(type.getName(), classifiers);
        return this.toInstance(type, value, propertyName, classifiers);
    }

    public <T> List<T> getInstanceOfList(Class<T> type, String ... classifiers) {
        List<T> result = this.getOptionalInstanceOfList(type, classifiers);
        if (result.isEmpty()) {
            throw new UnitilsException("No value found for " + this.nameToString(type.getName(), classifiers));
        }
        return result;
    }

    public <T> List<T> getOptionalInstanceOfList(Class<T> type, String ... classifiers) {
        String propertyName = type.getName();
        List<String> values = this.getOptionalStringList(propertyName, classifiers);
        ArrayList<T> result = new ArrayList<T>(values.size());
        for (String value : values) {
            T instance = this.toInstance(type, value, propertyName, classifiers);
            result.add(instance);
        }
        return result;
    }

    public <T extends Enum<T>> T getEnumValue(Class<T> type, String propertyName, String ... classifiers) {
        String value = this.getString(propertyName, classifiers);
        return this.toEnum(type, value, propertyName, classifiers);
    }

    public <T extends Enum<T>> T getOptionalEnumValue(Class<T> type, String propertyName, String ... classifiers) {
        String value = this.getOptionalString(propertyName, classifiers);
        return this.toEnum(type, value, propertyName, classifiers);
    }

    public <T extends Enum<T>> List<T> getEnumList(Class<T> type, String propertyName, String ... classifiers) {
        List<T> result = this.getOptionalEnumList(type, propertyName, classifiers);
        if (result.isEmpty()) {
            throw new UnitilsException("No value found for " + this.nameToString(propertyName, classifiers));
        }
        return result;
    }

    public <T extends Enum<T>> List<T> getOptionalEnumList(Class<T> type, String propertyName, String ... classifiers) {
        List<String> values = this.getOptionalStringList(propertyName, classifiers);
        ArrayList<T> result = new ArrayList<T>(values.size());
        for (String value : values) {
            T enumValue = this.toEnum(type, value, propertyName, classifiers);
            result.add(enumValue);
        }
        return result;
    }

    public <T> T getValueOfType(Class<T> type, String propertyName, String ... classifiers) {
        String value = this.getString(propertyName, classifiers);
        return this.toValueOfType(type, value, propertyName, classifiers);
    }

    public <T> T getOptionalValueOfType(Class<T> type, String propertyName, String ... classifiers) {
        String value = this.getOptionalString(propertyName, classifiers);
        return this.toValueOfType(type, value, propertyName, classifiers);
    }

    public <T> List<T> getValueListOfType(Class<T> type, String propertyName, String ... classifiers) {
        List<T> result = this.getOptionalValueListOfType(type, propertyName, classifiers);
        if (result.isEmpty()) {
            throw new UnitilsException("No value found for " + this.nameToString(propertyName, classifiers));
        }
        return result;
    }

    public <T> List<T> getOptionalValueListOfType(Class<T> type, String propertyName, String ... classifiers) {
        List<String> values = this.getOptionalStringList(propertyName, classifiers);
        ArrayList<T> result = new ArrayList<T>(values.size());
        for (String value : values) {
            T valueOfType = this.toValueOfType(type, value, propertyName, classifiers);
            result.add(valueOfType);
        }
        return result;
    }

    protected String nameToString(String propertyName, String ... classifiers) {
        if (classifiers == null || classifiers.length == 0) {
            return "property " + propertyName;
        }
        return "property " + propertyName + " and classifiers " + Arrays.toString(classifiers);
    }

    protected String getProperty(String propertyName) {
        if (this.overridingProperties != null && this.overridingProperties.containsKey(propertyName)) {
            return this.overridingProperties.getProperty(propertyName);
        }
        return this.properties.getProperty(propertyName);
    }

    protected Boolean toBoolean(String value, String propertyName, String ... classifiers) {
        if (value == null) {
            return null;
        }
        if ("true".equalsIgnoreCase(value)) {
            return Boolean.TRUE;
        }
        if ("false".equalsIgnoreCase(value)) {
            return Boolean.FALSE;
        }
        throw new UnitilsException("Value " + value + " of " + this.nameToString(propertyName, classifiers) + " is not a boolean.");
    }

    protected Integer toInteger(String value, String propertyName, String ... classifiers) {
        try {
            if (value == null) {
                return null;
            }
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new UnitilsException("Value " + value + " of " + this.nameToString(propertyName, classifiers) + " is not an int.");
        }
    }

    protected Long toLong(String value, String propertyName, String ... classifiers) {
        try {
            if (value == null) {
                return null;
            }
            return Long.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new UnitilsException("Value " + value + " of " + this.nameToString(propertyName, classifiers) + " is not a long.");
        }
    }

    protected List<String> toStringList(String value) {
        if (value == null) {
            return new ArrayList<String>(0);
        }
        String[] splitValues = value.split(",");
        ArrayList<String> result = new ArrayList<String>(splitValues.length);
        for (String splitValue : splitValues) {
            if ("".equals(splitValue = splitValue.trim())) continue;
            result.add(splitValue);
        }
        return result;
    }

    protected <T extends Enum<T>> T toEnum(Class<T> type, String value, String propertyName, String[] classifiers) {
        try {
            if (value == null) {
                return null;
            }
            return Enum.valueOf(type, value);
        }
        catch (Exception e) {
            throw new UnitilsException("Value " + value + " of " + this.nameToString(propertyName, classifiers) + " is not a valid enum value for type " + type.getName(), e);
        }
    }

    protected <T> T toInstance(String value, String propertyName, String ... classifiers) {
        if (value == null) {
            return null;
        }
        try {
            Object instance = ReflectionUtils.createInstanceOfType(value, true);
            if (instance instanceof Factory) {
                return ((Factory)instance).create();
            }
            return instance;
        }
        catch (Exception e) {
            throw new UnitilsException("Value " + value + " of " + this.nameToString(propertyName, classifiers) + " is not a valid classname.", e);
        }
    }

    protected Class<?> toClass(String value, String propertyName, String[] classifiers) {
        if (value == null) {
            return null;
        }
        try {
            return Class.forName(value);
        }
        catch (Exception e) {
            throw new UnitilsException("Value " + value + " of " + this.nameToString(propertyName, classifiers) + " is not a valid class name.", e);
        }
    }

    protected <T> T toInstance(Class<T> type, String value, String propertyName, String ... classifiers) {
        T instance = this.toInstance(value, propertyName, classifiers);
        if (instance != null && !type.isAssignableFrom(instance.getClass())) {
            throw new UnitilsException("Value " + value + " of " + this.nameToString(propertyName, classifiers) + " is not of the expected type " + type.getName());
        }
        return instance;
    }

    protected <T> T toValueOfType(Class<T> type, String value, String propertyName, String ... classifiers) {
        if (type.isAssignableFrom(String.class)) {
            return (T)value;
        }
        if (Boolean.class.equals(type) || Boolean.TYPE.equals(type)) {
            return (T)this.toBoolean(value, propertyName, classifiers);
        }
        if (Integer.class.equals(type) || Integer.TYPE.equals(type)) {
            return (T)this.toInteger(value, propertyName, classifiers);
        }
        if (Long.class.equals(type) || Long.TYPE.equals(type)) {
            return (T)this.toLong(value, propertyName, classifiers);
        }
        if (type.isEnum()) {
            return this.toEnum(type, value, propertyName, classifiers);
        }
        if (Class.class.equals(type)) {
            return (T)this.toClass(value, propertyName, classifiers);
        }
        return this.toInstance(type, value, propertyName, classifiers);
    }
}

