/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.core.dbsupport;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.unitils.core.dbsupport.DbSupport;
import org.unitils.core.dbsupport.SQLHandler;
import org.unitils.core.util.ConfigUtils;
import org.unitils.util.PropertyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbSupportFactory {
    public static final String PROPKEY_DATABASE_SCHEMA_NAMES = "database.schemaNames";
    private static Map<String, DbSupport> dbSupportCache = new HashMap<String, DbSupport>();

    public static DbSupport getDefaultDbSupport(Properties configuration, SQLHandler sqlHandler, String dialect) {
        String defaultSchemaName = PropertyUtils.getStringList(PROPKEY_DATABASE_SCHEMA_NAMES, configuration, true).get(0);
        return DbSupportFactory.getDbSupport(configuration, sqlHandler, defaultSchemaName, dialect);
    }

    public static DbSupport getDbSupport(Properties configuration, SQLHandler sqlHandler, String schemaName, String dialect) {
        DbSupport dbSupport = dbSupportCache.get(schemaName);
        if (dbSupport != null) {
            return dbSupport;
        }
        dbSupport = ConfigUtils.getInstanceOf(DbSupport.class, configuration, dialect);
        dbSupport.init(configuration, sqlHandler, schemaName);
        dbSupportCache.put(schemaName, dbSupport);
        return dbSupport;
    }

    public static List<DbSupport> getDbSupports(Properties configuration, SQLHandler sqlHandler, String dialect) {
        ArrayList<DbSupport> result = new ArrayList<DbSupport>();
        List<String> schemaNames = PropertyUtils.getStringList(PROPKEY_DATABASE_SCHEMA_NAMES, configuration, true);
        for (String schemaName : schemaNames) {
            DbSupport dbSupport = DbSupportFactory.getDbSupport(configuration, sqlHandler, schemaName, dialect);
            result.add(dbSupport);
        }
        return result;
    }
}

