/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.util;

import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.unitils.util.MissingKeysException;

public class ResourcebundleCheck {
    public static void testAllTheKeys(String bundleName, Locale ... locales) throws Exception {
        StringBuilder builder = new StringBuilder();
        ResourceBundle[] bundles = new ResourceBundle[locales.length];
        for (int i = 0; i < locales.length; ++i) {
            Locale locale = locales[i];
            ResourceBundle bundle = ResourceBundle.getBundle(bundleName, locale, ResourceBundle.Control.getControl(ResourceBundle.Control.FORMAT_PROPERTIES));
            if (!bundle.getLocale().equals(locale)) {
                throw new MissingResourceException("The resourcebundle is missing: ", bundleName, locale.getLanguage());
            }
            bundles[i] = bundle;
        }
        ResourceBundle biggestBundle = bundles[0];
        for (ResourceBundle bundle : bundles) {
            if (bundle.keySet().size() <= biggestBundle.keySet().size()) continue;
            biggestBundle = bundle;
        }
        Enumeration<String> keys = biggestBundle.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            for (int i = 0; i < bundles.length; ++i) {
                if (!bundles[i].containsKey(key)) {
                    builder.append("- Locale ");
                    builder.append(bundles[i].getLocale().toString());
                    builder.append(" doesn't contain '");
                    builder.append(key);
                    builder.append("' \n");
                    continue;
                }
                if (!bundles[i].getString(key).isEmpty()) continue;
                builder.append("Locale ");
                builder.append(bundles[i].getLocale().toString());
                builder.append(": '");
                builder.append(key);
                builder.append("': is empty.  \n");
            }
        }
        if (!builder.toString().isEmpty()) {
            throw new MissingKeysException(builder.toString());
        }
    }
}

