/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.database;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.unitils.core.Module;
import org.unitils.core.TestListener;
import org.unitils.core.Unitils;
import org.unitils.core.UnitilsException;
import org.unitils.core.config.Configuration;
import org.unitils.core.dbsupport.SQLHandler;
import org.unitils.core.util.ConfigUtils;
import org.unitils.database.DataSourceWrapper;
import org.unitils.database.annotations.TestDataSource;
import org.unitils.database.annotations.Transactional;
import org.unitils.database.config.DatabaseConfigurations;
import org.unitils.database.config.DatabaseConfigurationsFactory;
import org.unitils.database.transaction.UnitilsTransactionManager;
import org.unitils.database.transaction.impl.UnitilsTransactionManagementConfiguration;
import org.unitils.database.util.Flushable;
import org.unitils.database.util.TransactionMode;
import org.unitils.dbmaintainer.DBMaintainer;
import org.unitils.util.AnnotationUtils;
import org.unitils.util.ModuleUtils;
import org.unitils.util.PropertyUtils;
import org.unitils.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseModule
implements Module {
    public static final String PROPERTY_UPDATEDATABASESCHEMA_ENABLED = "updateDataBaseSchema.enabled";
    public static final String PROPERTY_WRAP_DATASOURCE_IN_TRANSACTIONAL_PROXY = "dataSource.wrapInTransactionalProxy";
    private static Log logger = LogFactory.getLog(DatabaseModule.class);
    protected Map<Class<? extends Annotation>, Map<String, String>> defaultAnnotationPropertyValues;
    protected DataSource dataSource;
    protected Properties configuration;
    protected boolean updateDatabaseSchemaEnabled;
    protected boolean wrapDataSourceInTransactionalProxy;
    protected UnitilsTransactionManager transactionManager;
    protected Set<UnitilsTransactionManagementConfiguration> transactionManagementConfigurations = new HashSet<UnitilsTransactionManagementConfiguration>();
    protected String dialect;
    private DatabaseConfigurations databaseConfigurations;
    private List<DataSourceWrapper> wrappers = new ArrayList<DataSourceWrapper>();

    public void init(Properties configuration) {
        this.configuration = configuration;
        DatabaseConfigurationsFactory configFactory = new DatabaseConfigurationsFactory(new Configuration(configuration));
        this.databaseConfigurations = configFactory.create();
        DataSourceWrapper wrapper = new DataSourceWrapper(this.databaseConfigurations.getDatabaseConfiguration(), configuration, this.getTransactionManager());
        this.setWrapper(wrapper);
        this.defaultAnnotationPropertyValues = ModuleUtils.getAnnotationPropertyDefaults(DatabaseModule.class, (Properties)configuration, (Class[])new Class[]{Transactional.class});
        this.updateDatabaseSchemaEnabled = PropertyUtils.getBoolean((String)PROPERTY_UPDATEDATABASESCHEMA_ENABLED, (Properties)configuration);
        this.wrapDataSourceInTransactionalProxy = PropertyUtils.getBoolean((String)PROPERTY_WRAP_DATASOURCE_IN_TRANSACTIONAL_PROXY, (Properties)configuration);
        this.dialect = PropertyUtils.getString((String)"database.dialect", (Properties)configuration);
        PlatformTransactionManager.class.getName();
    }

    public void afterInit() {
    }

    public void registerTransactionManagementConfiguration() {
        for (final DataSourceWrapper wrapper : this.wrappers) {
            this.registerTransactionManagementConfiguration(new UnitilsTransactionManagementConfiguration(){

                public boolean isApplicableFor(Object testObject) {
                    return true;
                }

                public PlatformTransactionManager getSpringPlatformTransactionManager(Object testObject) {
                    return new DataSourceTransactionManager(wrapper.getDataSourceAndActivateTransactionIfNeeded());
                }

                public boolean isTransactionalResourceAvailable(Object testObject) {
                    return wrapper.isDataSourceLoaded();
                }

                public Integer getPreference() {
                    return 1;
                }
            });
        }
    }

    public void activateTransactionIfNeeded() {
        if (this.transactionManager != null) {
            this.transactionManager.activateTransactionIfNeeded(this.getTestObject());
        }
    }

    public UnitilsTransactionManager getTransactionManager() {
        if (this.transactionManager == null) {
            this.transactionManager = (UnitilsTransactionManager)ConfigUtils.getInstanceOf(UnitilsTransactionManager.class, (Properties)this.configuration, (String[])new String[0]);
        }
        this.transactionManager.init(this.transactionManagementConfigurations);
        return this.transactionManager;
    }

    public void flushDatabaseUpdates(Object testObject) {
        List flushables = Unitils.getInstance().getModulesRepository().getModulesOfType(Flushable.class);
        for (Flushable flushable : flushables) {
            flushable.flushDatabaseUpdates(testObject);
        }
    }

    public void resetDatabaseState(SQLHandler sqlHandler) {
        DBMaintainer dbMaintainer = new DBMaintainer(this.configuration, sqlHandler, this.dialect);
        dbMaintainer.resetDatabaseState();
    }

    public void injectDataSource(Object testObject) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        TestDataSource annotation;
        Set fields = AnnotationUtils.getFieldsAnnotatedWith(testObject.getClass(), TestDataSource.class);
        Set methods = AnnotationUtils.getMethodsAnnotatedWith(testObject.getClass(), TestDataSource.class);
        HashMap<String, DataSource> mapDatasources = new HashMap<String, DataSource>();
        if (fields.isEmpty() && methods.isEmpty()) {
            return;
        }
        for (Field field : fields) {
            annotation = field.getAnnotation(TestDataSource.class);
            DataSource datasource = this.getDataSource(annotation.value(), mapDatasources, testObject);
            ReflectionUtils.setFieldValue((Object)testObject, (Field)field, (Object)datasource);
        }
        for (Method method : methods) {
            annotation = method.getAnnotation(TestDataSource.class);
            DataSource dataSource = this.getDataSource(annotation.value(), mapDatasources, testObject);
            method.invoke(testObject, dataSource);
        }
    }

    protected DataSource getDataSource(String databaseName, Map<String, DataSource> mapDatasources, Object testObject) {
        DataSource datasource = null;
        if (mapDatasources.containsKey(databaseName)) {
            datasource = mapDatasources.get(databaseName);
        } else {
            DataSourceWrapper wrapper = this.getWrapper(databaseName);
            datasource = wrapper.getTransactionalDataSourceAndActivateTransactionIfNeeded(testObject);
            mapDatasources.put(databaseName, datasource);
        }
        return datasource;
    }

    protected TransactionMode getTransactionMode(Object testObject, Method testMethod) {
        TransactionMode transactionMode = (TransactionMode)((Object)AnnotationUtils.getMethodOrClassLevelAnnotationProperty(Transactional.class, (String)"value", (Object)((Object)TransactionMode.DEFAULT), (Method)testMethod, testObject.getClass()));
        transactionMode = (TransactionMode)ModuleUtils.getEnumValueReplaceDefault(Transactional.class, (String)"value", (Enum)transactionMode, this.defaultAnnotationPropertyValues);
        return transactionMode;
    }

    protected void startTransactionForTestMethod(Object testObject, Method testMethod) {
        if (this.isTransactionsEnabled(testObject, testMethod)) {
            this.startTransaction(testObject);
        }
    }

    protected void endTransactionForTestMethod(Object testObject, Method testMethod) {
        if (this.isTransactionsEnabled(testObject, testMethod)) {
            if (this.getTransactionMode(testObject, testMethod) == TransactionMode.COMMIT) {
                this.commitTransaction(testObject);
            } else if (this.getTransactionMode(testObject, testMethod) == TransactionMode.ROLLBACK) {
                this.rollbackTransaction(testObject);
            }
        }
    }

    public void startTransaction(Object testObject) {
        this.getTransactionManager().startTransaction(testObject);
    }

    public void commitTransaction(Object testObject) {
        this.flushDatabaseUpdates(testObject);
        this.getTransactionManager().commit(testObject);
    }

    public void rollbackTransaction(Object testObject) {
        this.flushDatabaseUpdates(testObject);
        this.getTransactionManager().rollback(testObject);
    }

    public boolean isTransactionsEnabled(Object testObject, Method testMethod) {
        TransactionMode transactionMode = this.getTransactionMode(testObject, testMethod);
        return transactionMode != TransactionMode.DISABLED;
    }

    public void registerTransactionManagementConfiguration(UnitilsTransactionManagementConfiguration transactionManagementConfiguration) {
        this.transactionManagementConfigurations.add(transactionManagementConfiguration);
    }

    protected Object getTestObject() {
        return Unitils.getInstance().getTestContext().getTestObject();
    }

    public TestListener getTestListener() {
        return new DatabaseTestListener();
    }

    public List<String> getDatabaseName(Object testObject, Method testMethod) {
        Set lstDataSources;
        ArrayList<String> dataSources = new ArrayList<String>();
        TestDataSource dataSource = (TestDataSource)AnnotationUtils.getMethodOrClassLevelAnnotation(TestDataSource.class, (Method)testMethod, testObject.getClass());
        if (dataSource != null) {
            dataSources.add(dataSource.value());
        }
        if (!(lstDataSources = AnnotationUtils.getFieldLevelAnnotations(testObject.getClass(), TestDataSource.class)).isEmpty()) {
            for (TestDataSource testDataSource : lstDataSources) {
                dataSources.add(testDataSource.value());
            }
        }
        return dataSources;
    }

    public String getDialect() {
        return this.dialect;
    }

    public DataSourceWrapper getWrapper(String databaseName) {
        if (StringUtils.isEmpty((String)databaseName)) {
            return new DataSourceWrapper(this.databaseConfigurations.getDatabaseConfiguration(), this.configuration, this.getTransactionManager());
        }
        return new DataSourceWrapper(this.databaseConfigurations.getDatabaseConfiguration(databaseName), this.configuration, this.getTransactionManager());
    }

    public void setWrapper(DataSourceWrapper wrapper) {
        if (!this.wrappers.contains(wrapper)) {
            this.wrappers.add(wrapper);
        }
    }

    public DatabaseConfigurations getDatabaseConfigurations() {
        return this.databaseConfigurations;
    }

    protected class DatabaseTestListener
    extends TestListener {
        protected DatabaseTestListener() {
        }

        public void beforeTestSetUp(Object testObject, Method testMethod) {
            List<String> databaseNames = DatabaseModule.this.getDatabaseName(testObject, testMethod);
            if (!databaseNames.isEmpty()) {
                for (String databaseName : databaseNames) {
                    DataSourceWrapper wrapper = DatabaseModule.this.getWrapper(databaseName);
                    DatabaseModule.this.setWrapper(wrapper);
                }
            }
            DatabaseModule.this.registerTransactionManagementConfiguration();
            try {
                DatabaseModule.this.injectDataSource(testObject);
            }
            catch (Exception e) {
                new UnitilsException(e.getMessage(), (Throwable)e);
            }
            DatabaseModule.this.startTransactionForTestMethod(testObject, testMethod);
        }

        public void afterTestTearDown(Object testObject, Method testMethod) {
            DatabaseModule.this.endTransactionForTestMethod(testObject, testMethod);
        }
    }
}

