/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.database.config;

import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitils.core.config.Configuration;
import org.unitils.database.config.DataSourceFactory;
import org.unitils.database.config.DatabaseConfiguration;
import org.unitils.database.config.DatabaseConfigurations;
import org.unitils.database.config.DatabaseConfigurationsFactory;

public class PropertiesDataSourceFactory
implements DataSourceFactory {
    private static Log logger = LogFactory.getLog(PropertiesDataSourceFactory.class);
    private DatabaseConfiguration config;
    private String databaseName;

    public void init(Properties configuration, String databaseName) {
        DatabaseConfigurations factory = new DatabaseConfigurationsFactory(new Configuration(configuration)).create();
        this.config = factory.getDatabaseConfiguration(databaseName);
    }

    public void init(Properties configuration) {
        DatabaseConfigurations factory = new DatabaseConfigurationsFactory(new Configuration(configuration)).create();
        this.config = factory.getDatabaseConfiguration();
    }

    public void init(DatabaseConfiguration tempConfig) {
        this.config = tempConfig;
    }

    public DataSource createDataSource() {
        logger.info((Object)("Creating data source. Driver: " + this.config.getDriverClassName() + ", url: " + this.config.getUrl() + ", user: " + this.config.getUserName() + ", password: <not shown>"));
        BasicDataSource dataSource = this.getNewDataSource();
        dataSource.setDriverClassName(this.config.getDriverClassName());
        dataSource.setUsername(this.config.getUserName());
        dataSource.setPassword(this.config.getPassword());
        dataSource.setUrl(this.config.getUrl());
        return dataSource;
    }

    protected BasicDataSource getNewDataSource() {
        return new BasicDataSource();
    }
}

