/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.database.sqlassert;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitils.core.Unitils;
import org.unitils.core.UnitilsException;
import org.unitils.database.DatabaseModule;
import org.unitils.database.SQLUnitils;
import org.unitils.reflectionassert.ReflectionAssert;
import org.unitils.reflectionassert.ReflectionComparatorMode;
import org.unitils.thirdparty.org.apache.commons.dbutils.DbUtils;

public abstract class SqlAssert {
    private static Log logger = LogFactory.getLog(SqlAssert.class);

    public static void assertSingleRowSqlResult(String sql, String[] row) {
        SqlAssert.assertSingleRowSqlResult(sql, "", row);
    }

    public static void assertSingleRowSqlResult(String sql, String databaseName, String[] row) {
        SqlAssert.assertSingleRowSqlResult(sql, SqlAssert.getDataSourceFromUnitils(databaseName), row);
    }

    public static void assertMultipleRowSqlResult(String sql, String databaseName, String[] ... rows) {
        SqlAssert.assertMultipleRowSqlResult(sql, SqlAssert.getDataSourceFromUnitils(databaseName), rows);
    }

    public static void assertMultipleRowSqlResult(String sql, String[] ... rows) {
        SqlAssert.assertMultipleRowSqlResult(sql, "", rows);
    }

    public static void assertCountSqlResult(String sql, Long countResult) {
        SqlAssert.assertCountSqlResult(sql, countResult, "");
    }

    public static void assertCountSqlResult(String sql, Long countResult, String databaseName) {
        SqlAssert.assertCountSqlResult(sql, SqlAssert.getDataSourceFromUnitils(databaseName), countResult);
    }

    public static void assertSingleRowSqlResult(String sql, DataSource dataSource, String[] row) {
        SqlAssert.assertMultipleRowSqlResult(sql, dataSource, (String[][])new String[][]{row});
    }

    public static void assertMultipleRowSqlResult(String sql, DataSource dataSource, String[] ... rows) {
        String[][] itemAsString = SqlAssert.getItemAsString(sql, dataSource, rows[0].length);
        ReflectionAssert.assertReflectionEquals((Object)rows, (Object)itemAsString, (ReflectionComparatorMode[])new ReflectionComparatorMode[]{ReflectionComparatorMode.LENIENT_ORDER});
    }

    public static void assertCountSqlResult(String sql, DataSource dataSource, Long countResult) {
        Long itemAsLong = SQLUnitils.getItemAsLong(sql, dataSource);
        ReflectionAssert.assertReflectionEquals((Object)countResult, (Object)itemAsLong, (ReflectionComparatorMode[])new ReflectionComparatorMode[0]);
    }

    protected static String[][] getItemAsString(String sql, DataSource dataSource, Integer columnCount) {
        String[][] stringArray;
        logger.debug((Object)sql);
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = dataSource.getConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery(sql);
            ArrayList<String[]> resultList = new ArrayList<String[]>();
            while (resultSet.next()) {
                String[] row = new String[columnCount.intValue()];
                for (int i = 1; i <= columnCount; ++i) {
                    row[i - 1] = resultSet.getString(i);
                }
                resultList.add(row);
            }
            stringArray = (String[][])resultList.toArray((T[])new String[][]{new String[0]});
        }
        catch (Exception e) {
            try {
                throw new UnitilsException("Error while executing statement: " + sql, (Throwable)e);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly((Connection)connection, (Statement)statement, resultSet);
                throw throwable;
            }
        }
        DbUtils.closeQuietly((Connection)connection, (Statement)statement, (ResultSet)resultSet);
        return stringArray;
    }

    private static DataSource getDataSourceFromUnitils(String databaseName) {
        return ((DatabaseModule)Unitils.getInstance().getModulesRepository().getModuleOfType(DatabaseModule.class)).getWrapper(databaseName).getDataSource();
    }
}

