/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.dbmaintainer.locator;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitils.dbmaintainer.locator.ClassPathResourceLocator;
import org.unitils.dbmaintainer.locator.resourcepickingstrategie.ResourcePickingStrategie;

public class ClassPathDataLocator
extends ClassPathResourceLocator {
    private static Log logger = LogFactory.getLog(ClassPathDataLocator.class);

    public InputStream getDataResource(String resourceName, ResourcePickingStrategie resourcePickingStrategie) {
        List<URL> matchedResources = this.loadResources(resourceName, true);
        List<URL> resourcesF = resourcePickingStrategie.filter(matchedResources, resourceName);
        try {
            if (resourcesF.size() > 1) {
                logger.warn((Object)("Multiple resources found for '" + resourceName + "'. Ambigues resourceName. Will choose first occurence"));
                return resourcesF.get(0).openStream();
            }
            if (resourcesF.size() == 1) {
                logger.info((Object)("One resources found for '" + resourceName + "'. "));
                return resourcesF.get(0).openStream();
            }
        }
        catch (IOException e) {
            logger.error((Object)"could open stream", (Throwable)e);
        }
        return null;
    }
}

