/*
 * Copyright 2008,  Unitils.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.unitils.dbmaintainer.structure;

import org.unitils.dbmaintainer.util.DatabaseAccessing;

/**
 * Defines the contract for implementation classes that update all sequences and identity columns of a database to
 * a sufficiently high value, so that test data be inserted easily.
 *
 * @author Filip Neven
 * @author Tim Ducheyne
 */
public interface SequenceUpdater extends DatabaseAccessing {


    /**
     * Updates all database sequences and identity columns to a sufficiently high value, so that test data be inserted
     * easily.
     */
    void updateSequences();
    
    /**
     * Sets all the sequences to the lowest acceptable value.
     * This can be defined with the property "sequenceUpdater.sequencevalue.lowestacceptable".
     */
    void restartSequences();

}
