/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.dbmaintainer.locator.resourcepickingstrategie.impl;

import java.io.IOException;
import java.net.URL;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitils.dbmaintainer.locator.resourcepickingstrategie.ResourcePickingStrategie;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UniqueMostRecentPickingStrategie
implements ResourcePickingStrategie {
    private static Log logger = LogFactory.getLog(UniqueMostRecentPickingStrategie.class);

    @Override
    public List<URL> filter(List<URL> resources, String resourceSearchName) {
        ArrayList<URL> filteredResources = new ArrayList<URL>();
        for (URL url : resources) {
            try {
                this.addMostRecent(filteredResources, url, resourceSearchName);
            }
            catch (IOException e) {
                logger.error((Object)"could not add resource", (Throwable)e);
            }
        }
        return filteredResources;
    }

    public void addMostRecent(List<URL> filteredResources, URL urlNew, String resourceSearchName) throws IOException {
        SimpleDateFormat sdf = new SimpleDateFormat("MMM dd,yyyy HH:mm");
        for (int i = 0; i < filteredResources.size(); ++i) {
            URL url = filteredResources.get(i);
            String endingWith = url.toString().substring(url.toString().lastIndexOf(resourceSearchName));
            if (!urlNew.toString().endsWith(endingWith)) continue;
            Long inlistresource = url.openConnection().getLastModified();
            Long newresource = urlNew.openConnection().getLastModified();
            if (inlistresource < newresource) {
                logger.debug((Object)("Resource replace by more recent after PickingStrategie: '" + url + "'(" + sdf.format(new Date(inlistresource)) + ") replaced_by '" + urlNew + "' (" + sdf.format(new Date(newresource)) + ")"));
                filteredResources.remove(url);
                filteredResources.add(urlNew);
            } else {
                logger.debug((Object)("Duplicate Resource found after PickingStrategie but not more recent (not added): '" + url + "'(" + sdf.format(new Date(inlistresource)) + ") is choosen over '" + urlNew + "' (" + sdf.format(new Date(newresource)) + ")"));
            }
            return;
        }
        filteredResources.add(urlNew);
        logger.debug((Object)("Resource added after Picking Strategie " + urlNew + " "));
    }
}

