/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.dbunit.dataset;

import java.util.ArrayList;
import java.util.List;
import org.unitils.core.UnitilsException;
import org.unitils.dbunit.dataset.Table;
import org.unitils.dbunit.dataset.comparison.SchemaDifference;
import org.unitils.dbunit.dataset.comparison.TableDifference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Schema {
    private String name;
    private List<Table> tables = new ArrayList<Table>();

    public Schema(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public List<Table> getTables() {
        return this.tables;
    }

    public List<String> getTableNames() {
        ArrayList<String> tableNames = new ArrayList<String>();
        for (Table table : this.tables) {
            tableNames.add(table.getName());
        }
        return tableNames;
    }

    public Table getTable(String tableName) {
        for (Table table : this.tables) {
            if (!tableName.equalsIgnoreCase(table.getName())) continue;
            return table;
        }
        return null;
    }

    public void addTable(Table table) {
        Table existingTable = this.getTable(table.getName());
        if (existingTable != null) {
            throw new UnitilsException("Unable to add table to data set. A table with name " + table.getName() + " already exists.");
        }
        this.tables.add(table);
    }

    public SchemaDifference compare(Schema actualSchema) {
        SchemaDifference schemaDifference = new SchemaDifference(this, actualSchema);
        for (Table table : this.getTables()) {
            Table actualTable = actualSchema.getTable(table.getName());
            if (actualTable == null) {
                schemaDifference.addMissingTable(table);
                continue;
            }
            TableDifference tableDifference = table.compare(actualTable);
            if (tableDifference == null) continue;
            schemaDifference.addTableDifference(tableDifference);
        }
        if (schemaDifference.isMatch()) {
            return null;
        }
        return schemaDifference;
    }
}

