/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.dbunit.dataset;

import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.datatype.TypeCastException;
import org.unitils.core.UnitilsException;
import org.unitils.dbunit.dataset.comparison.ColumnDifference;

public class Column {
    private String name;
    private DataType type;
    private Object value;

    public Column(String name, DataType type, Object value) {
        this.name = name;
        this.type = type;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public DataType getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    public Object getCastedValue(DataType castType) {
        try {
            return castType.typeCast(this.value);
        }
        catch (TypeCastException e) {
            throw new UnitilsException("Unable to convert \"" + this.value + "\" to " + castType.toString() + ". Column name: " + this.name + ", current type: " + this.type.toString(), (Throwable)e);
        }
    }

    public ColumnDifference compare(Column actualColumn) {
        if (this.value == actualColumn.getValue()) {
            return null;
        }
        if (this.value == null && actualColumn.getValue() != null) {
            return new ColumnDifference(this, actualColumn);
        }
        Object castedValue = this.getCastedValue(actualColumn.getType());
        if (castedValue == null && actualColumn.getValue() == null) {
            return null;
        }
        if (castedValue == null && actualColumn.getValue() != null) {
            return new ColumnDifference(this, actualColumn);
        }
        if (!castedValue.equals(actualColumn.getValue())) {
            return new ColumnDifference(this, actualColumn);
        }
        return null;
    }
}

