/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.dbunit.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ReplacementDataSet;
import org.dbunit.dataset.datatype.DataType;
import org.unitils.core.UnitilsException;
import org.unitils.dbunit.datasetfactory.impl.DbUnitDataSet;
import org.unitils.dbunit.datasetfactory.impl.DbUnitTable;
import org.unitils.dbunit.util.MultiSchemaDataSet;
import org.unitils.thirdparty.org.apache.commons.io.IOUtils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class MultiSchemaXmlDataSetReader {
    private static Log logger = LogFactory.getLog(MultiSchemaXmlDataSetReader.class);
    private String defaultSchemaName;

    public MultiSchemaXmlDataSetReader(String defaultSchemaName) {
        this.defaultSchemaName = defaultSchemaName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiSchemaDataSet readDataSetXml(File ... dataSetFiles) {
        try {
            DataSetContentHandler dataSetContentHandler = new DataSetContentHandler(this.defaultSchemaName);
            XMLReader xmlReader = this.createXMLReader();
            xmlReader.setContentHandler(dataSetContentHandler);
            xmlReader.setErrorHandler(dataSetContentHandler);
            for (File dataSetFile : dataSetFiles) {
                FileInputStream dataSetInputStream = null;
                try {
                    dataSetInputStream = new FileInputStream(dataSetFile);
                    xmlReader.parse(new InputSource(dataSetInputStream));
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(dataSetInputStream);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)dataSetInputStream);
            }
            return dataSetContentHandler.getMultiSchemaDataSet();
        }
        catch (Exception e) {
            throw new UnitilsException("Unable to parse data set xml.", (Throwable)e);
        }
    }

    protected XMLReader createXMLReader() {
        try {
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            saxParserFactory.setNamespaceAware(true);
            this.disableValidation(saxParserFactory);
            return saxParserFactory.newSAXParser().getXMLReader();
        }
        catch (Exception e) {
            throw new UnitilsException("Unable to create SAX parser to read data set xml.", (Throwable)e);
        }
    }

    protected void disableValidation(SAXParserFactory saxParserFactory) {
        saxParserFactory.setValidating(false);
        try {
            saxParserFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        }
        catch (Exception e) {
            logger.debug((Object)("Unable to set http://xml.org/sax/features/external-parameter-entities feature on SAX parser factory to false. Igoring exception: " + e.getMessage()));
        }
        try {
            saxParserFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (Exception e) {
            logger.debug((Object)("Unable to set http://apache.org/xml/features/nonvalidating/load-external-dtd feature on SAX parser factory to false. Igoring exception: " + e.getMessage()));
        }
    }

    protected static class DataSetContentHandler
    extends DefaultHandler {
        protected String defaultSchemaName;
        protected Map<String, DbUnitDataSet> dbUnitDataSetsPerSchemaName = new LinkedHashMap<String, DbUnitDataSet>();

        public DataSetContentHandler(String defaultSchemaName) {
            this.defaultSchemaName = defaultSchemaName;
        }

        public MultiSchemaDataSet getMultiSchemaDataSet() {
            MultiSchemaDataSet multiSchemaDataSet = new MultiSchemaDataSet();
            for (String schemaName : this.dbUnitDataSetsPerSchemaName.keySet()) {
                DbUnitDataSet dataSet = this.dbUnitDataSetsPerSchemaName.get(schemaName);
                ReplacementDataSet replacementDataSet = new ReplacementDataSet((IDataSet)dataSet);
                replacementDataSet.addReplacementObject((Object)"[null]", null);
                multiSchemaDataSet.setDataSetForSchema(schemaName, (IDataSet)replacementDataSet);
            }
            return multiSchemaDataSet;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            DbUnitTable table;
            DbUnitDataSet dbUnitDataSet;
            if ("dataset".equals(localName)) {
                if (!StringUtils.isEmpty((String)uri)) {
                    this.defaultSchemaName = uri;
                }
                return;
            }
            String schemaName = this.defaultSchemaName;
            if (!StringUtils.isEmpty((String)uri)) {
                schemaName = uri;
            }
            if ((dbUnitDataSet = this.dbUnitDataSetsPerSchemaName.get(schemaName)) == null) {
                dbUnitDataSet = new DbUnitDataSet();
                this.dbUnitDataSetsPerSchemaName.put(schemaName, dbUnitDataSet);
            }
            if ((table = dbUnitDataSet.getDbUnitTable(localName)) == null) {
                table = new DbUnitTable(localName);
                dbUnitDataSet.addTable(table);
            }
            this.addRow(attributes, table);
        }

        protected void addRow(Attributes attributes, DbUnitTable table) {
            if (attributes.getLength() == 0) {
                return;
            }
            for (int i = 0; i < attributes.getLength(); ++i) {
                Column column = new Column(attributes.getQName(i), DataType.UNKNOWN);
                table.addColumn(column);
            }
            ArrayList<Object> row = new ArrayList<Object>(10);
            for (String columnName : table.getColumnNames()) {
                Object value = ITable.NO_VALUE;
                if (attributes.getIndex(columnName) != -1) {
                    value = attributes.getValue(columnName);
                }
                row.add(value);
            }
            table.addRow(row);
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            throw e;
        }
    }
}

