/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.dbunit;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import org.unitils.core.TestContext;
import org.unitils.core.Unitils;
import org.unitils.dbunit.DbUnitModule;
import org.unitils.dbunit.annotation.ExpectedDataSet;
import org.unitils.dbunit.datasetfactory.DataSetFactory;
import org.unitils.dbunit.datasetloadstrategy.DataSetLoadStrategy;
import org.unitils.dbunit.util.MultiSchemaDataSet;

public class DbUnitUnitils {
    public static void insertDefaultDataSet() {
        DbUnitUnitils.getDbUnitModule().insertDefaultDataSet(Unitils.getInstance().getTestContext().getTestClass());
    }

    public static void insertDataSet(String ... dataSetFileNames) {
        DbUnitUnitils.getDbUnitModule().insertDataSet(Unitils.getInstance().getTestContext().getTestClass(), dataSetFileNames);
    }

    public static void insertDataSet(File dataSetFile) {
        DbUnitUnitils.getDbUnitModule().insertDataSet(dataSetFile);
    }

    public static void insertDataSet(File dataSetFile, Class<? extends DataSetFactory> dataSetFactoryClass, Class<? extends DataSetLoadStrategy> dataSetLoadStrategyClass) {
        DbUnitUnitils.getDbUnitModule().insertDataSet(dataSetFile, dataSetFactoryClass, dataSetLoadStrategyClass);
    }

    public static void assertExpectedDataSet(File ... datasetFile) throws IOException {
        DbUnitModule dbUnitModule = DbUnitUnitils.getDbUnitModule();
        try {
            MultiSchemaDataSet dataSet = dbUnitModule.getDefaultDataSetFactory().createDataSet(datasetFile);
            dbUnitModule.assertExpectedDataSets(dataSet, Unitils.getInstance().getTestContext().getTestObject());
        }
        finally {
            dbUnitModule.closeJdbcConnection();
        }
    }

    public static void assertExpectedDataSet(final String ... datasetFile) {
        TestContext testContext = Unitils.getInstance().getTestContext();
        ExpectedDataSet expectedDataSetAnnotation = new ExpectedDataSet(){

            @Override
            public Class<? extends Annotation> annotationType() {
                return ExpectedDataSet.class;
            }

            @Override
            public String[] value() {
                return datasetFile;
            }

            @Override
            public Class<? extends DataSetFactory> factory() {
                return null;
            }

            @Override
            public String databaseName() {
                return null;
            }
        };
        DbUnitUnitils.getDbUnitModule().assertExpectedDataSets(expectedDataSetAnnotation, testContext.getTestObject(), testContext.getTestMethod());
    }

    private static DbUnitModule getDbUnitModule() {
        return (DbUnitModule)Unitils.getInstance().getModulesRepository().getModuleOfType(DbUnitModule.class);
    }
}

