/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.dbunit;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbunit.database.DatabaseConfig;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.datatype.IDataTypeFactory;
import org.unitils.core.Module;
import org.unitils.core.TestListener;
import org.unitils.core.Unitils;
import org.unitils.core.UnitilsException;
import org.unitils.core.dbsupport.DbSupport;
import org.unitils.core.dbsupport.DbSupportFactory;
import org.unitils.core.dbsupport.DefaultSQLHandler;
import org.unitils.core.dbsupport.SQLHandler;
import org.unitils.core.util.ConfigUtils;
import org.unitils.database.DatabaseModule;
import org.unitils.dbmaintainer.locator.ClassPathDataLocator;
import org.unitils.dbmaintainer.locator.resourcepickingstrategie.ResourcePickingStrategie;
import org.unitils.dbunit.annotation.DataSet;
import org.unitils.dbunit.annotation.ExpectedDataSet;
import org.unitils.dbunit.datasetfactory.DataSetFactory;
import org.unitils.dbunit.datasetfactory.DataSetResolver;
import org.unitils.dbunit.datasetloadstrategy.DataSetLoadStrategy;
import org.unitils.dbunit.util.DataSetAssert;
import org.unitils.dbunit.util.DbUnitDatabaseConnection;
import org.unitils.dbunit.util.FileHandler;
import org.unitils.dbunit.util.MultiSchemaDataSet;
import org.unitils.util.AnnotationUtils;
import org.unitils.util.ModuleUtils;
import org.unitils.util.PropertyUtils;
import org.unitils.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbUnitModule
implements Module {
    private static Log logger = LogFactory.getLog(DbUnitModule.class);
    protected Map<Class<? extends Annotation>, Map<String, String>> defaultAnnotationPropertyValues;
    protected Map<String, DbUnitDatabaseConnection> dbUnitDatabaseConnections = new HashMap<String, DbUnitDatabaseConnection>();
    protected Properties configuration;
    protected String dialect;
    protected String databaseName;
    protected String scriptExtension = "xml";
    private FileHandler fileHandler = new FileHandler();

    public void init(Properties configuration) {
        this.configuration = configuration;
        this.defaultAnnotationPropertyValues = ModuleUtils.getAnnotationPropertyDefaults(DbUnitModule.class, (Properties)configuration, (Class[])new Class[]{DataSet.class, ExpectedDataSet.class});
        this.dialect = PropertyUtils.getString((String)"database.dialect", (Properties)configuration);
    }

    public void afterInit() {
    }

    public DbUnitDatabaseConnection getDbUnitDatabaseConnection(String schemaName) {
        DbUnitDatabaseConnection dbUnitDatabaseConnection = this.dbUnitDatabaseConnections.get(schemaName);
        if (dbUnitDatabaseConnection == null) {
            dbUnitDatabaseConnection = this.createDbUnitConnection(schemaName);
            this.dbUnitDatabaseConnections.put(schemaName, dbUnitDatabaseConnection);
        }
        return dbUnitDatabaseConnection;
    }

    public void insertDataSet(Method testMethod, Object testObject) {
        try {
            MultiSchemaDataSet multiSchemaDataSet = this.getDataSet(testMethod, testObject);
            if (multiSchemaDataSet == null) {
                return;
            }
            DataSetLoadStrategy dataSetLoadStrategy = this.getDataSetLoadStrategy(testMethod, testObject.getClass());
            this.insertDataSet(multiSchemaDataSet, dataSetLoadStrategy);
        }
        catch (Exception e) {
            throw new UnitilsException("Error inserting test data from DbUnit dataset for method " + testMethod, (Throwable)e);
        }
        finally {
            this.closeJdbcConnection();
        }
    }

    public void insertDefaultDataSet(Class<?> testClass) {
        DataSetFactory dataSetFactory = this.getDefaultDataSetFactory();
        String[] dataSetFileNames = new String[]{this.getDefaultDataSetFileNameClassLevel(testClass, dataSetFactory.getDataSetFileExtension())};
        this.insertDataSet(testClass, dataSetFileNames);
    }

    public void insertDataSet(Class<?> testClass, String ... dataSetFileNames) {
        DataSetFactory dataSetFactory = this.getDefaultDataSetFactory();
        DataSetLoadStrategy dataSetLoadStrategy = this.getDefaultDataSetLoadStrategy();
        MultiSchemaDataSet dataSet = this.getDataSet(testClass, dataSetFileNames, dataSetFactory);
        this.insertDataSet(dataSet, dataSetLoadStrategy);
    }

    public void insertDataSet(File dataSetFile) {
        DataSetFactory dataSetFactory = this.getDefaultDataSetFactory();
        DataSetLoadStrategy dataSetLoadStrategy = this.getDefaultDataSetLoadStrategy();
        MultiSchemaDataSet multiSchemaDataSet = dataSetFactory.createDataSet(dataSetFile);
        this.insertDataSet(multiSchemaDataSet, dataSetLoadStrategy);
    }

    public void insertDataSet(File dataSetFile, Class<? extends DataSetFactory> dataSetFactoryClass, Class<? extends DataSetLoadStrategy> dataSetLoadStrategyClass) {
        DataSetLoadStrategy dataSetLoadStrategy = (DataSetLoadStrategy)ReflectionUtils.createInstanceOfType(dataSetLoadStrategyClass, (boolean)false);
        DataSetFactory dataSetFactory = this.getDataSetFactory(dataSetFactoryClass);
        MultiSchemaDataSet multiSchemaDataSet = dataSetFactory.createDataSet(dataSetFile);
        this.insertDataSet(multiSchemaDataSet, dataSetLoadStrategy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insertDataSet(MultiSchemaDataSet multiSchemaDataSet, DataSetLoadStrategy dataSetLoadStrategy) {
        try {
            for (String schemaName : multiSchemaDataSet.getSchemaNames()) {
                IDataSet schemaDataSet = multiSchemaDataSet.getDataSetForSchema(schemaName);
                dataSetLoadStrategy.execute(this.getDbUnitDatabaseConnection(schemaName), schemaDataSet);
            }
        }
        finally {
            this.closeJdbcConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertDbContentAsExpected(Method testMethod, Object testObject) {
        try {
            MultiSchemaDataSet multiSchemaExpectedDataSet = this.getExpectedDataSet(testMethod, testObject);
            if (multiSchemaExpectedDataSet == null) {
                return;
            }
            this.getDatabaseModule().flushDatabaseUpdates(testObject);
            DataSetAssert dataSetAssert = new DataSetAssert();
            for (String schemaName : multiSchemaExpectedDataSet.getSchemaNames()) {
                IDataSet expectedDataSet = multiSchemaExpectedDataSet.getDataSetForSchema(schemaName);
                IDataSet actualDataSet = this.getActualDataSet(schemaName);
                dataSetAssert.assertEqualDbUnitDataSets(schemaName, expectedDataSet, actualDataSet);
            }
        }
        finally {
            this.closeJdbcConnection();
        }
    }

    protected IDataSet getActualDataSet(String schemaName) {
        try {
            return this.getDbUnitDatabaseConnection(schemaName).createDataSet();
        }
        catch (Exception e) {
            throw new UnitilsException("Unable to get actual data set for schema " + schemaName, (Throwable)e);
        }
    }

    public MultiSchemaDataSet getDataSet(Method testMethod, Object testObject) {
        Class<?> testClass = testObject.getClass();
        DataSet dataSetAnnotation = (DataSet)AnnotationUtils.getMethodOrClassLevelAnnotation(DataSet.class, (Method)testMethod, testClass);
        if (dataSetAnnotation == null) {
            return null;
        }
        this.databaseName = dataSetAnnotation.databaseName();
        DataSetFactory dataSetFactory = this.getDataSetFactory(DataSet.class, testMethod, testClass);
        String[] dataSetFileNames = dataSetAnnotation.value();
        if (dataSetFileNames.length == 0) {
            dataSetFileNames = new String[]{this.getCorrectFileName(testClass, testMethod, dataSetFactory.getDataSetFileExtension())};
        }
        return this.getDataSet(testClass, dataSetFileNames, dataSetFactory);
    }

    public MultiSchemaDataSet getExpectedDataSet(Method testMethod, Object testObject) {
        Class<?> testClass = testObject.getClass();
        ExpectedDataSet expectedDataSetAnnotation = (ExpectedDataSet)AnnotationUtils.getMethodOrClassLevelAnnotation(ExpectedDataSet.class, (Method)testMethod, testClass);
        if (expectedDataSetAnnotation == null) {
            return null;
        }
        this.databaseName = expectedDataSetAnnotation.databaseName();
        DataSetFactory dataSetFactory = this.getDataSetFactory(ExpectedDataSet.class, testMethod, testClass);
        String[] dataSetFileNames = expectedDataSetAnnotation.value();
        if (dataSetFileNames.length == 0) {
            dataSetFileNames = new String[]{this.getDefaultExpectedDataSetFileName(testMethod, testClass, dataSetFactory.getDataSetFileExtension())};
        }
        return this.getDataSet(testMethod.getDeclaringClass(), dataSetFileNames, dataSetFactory);
    }

    protected MultiSchemaDataSet getDataSet(Class<?> testClass, String[] dataSetFileNames, DataSetFactory dataSetFactory) {
        ArrayList<File> dataSetFiles = new ArrayList<File>();
        ResourcePickingStrategie resourcePickingStrategie = this.getResourcePickingStrategie();
        for (String dataSetFileName : dataSetFileNames) {
            File dataSetFile = this.handleDataSetResource(new ClassPathDataLocator(), dataSetFileName, resourcePickingStrategie, testClass);
            dataSetFiles.add(dataSetFile);
        }
        logger.info((Object)("Loading DbUnit data set. File names: " + dataSetFiles));
        MultiSchemaDataSet dataSet = dataSetFactory.createDataSet(dataSetFiles.toArray(new File[dataSetFiles.size()]));
        this.fileHandler.deleteFiles(dataSetFiles);
        return dataSet;
    }

    protected File handleDataSetResource(ClassPathDataLocator locator, String nameResource, ResourcePickingStrategie strategy, Class<?> testClass) {
        InputStream in = locator.getDataResource(nameResource, strategy);
        if (in == null) {
            File resolvedFile = this.getDataSetResolver().resolve(testClass, nameResource);
            if (resolvedFile == null) {
                throw new UnitilsException("DataSetResource file with name '" + nameResource + "' cannot be found");
            }
            try {
                in = new FileInputStream(resolvedFile);
            }
            catch (FileNotFoundException e) {
                throw new UnitilsException("DataSetResource file with name '" + nameResource + "' cannot be found");
            }
        }
        File tempFile = this.fileHandler.createTempFile(nameResource);
        this.fileHandler.writeToFile(tempFile, in);
        return tempFile;
    }

    protected DataSetLoadStrategy getDataSetLoadStrategy(Method testMethod, Class<?> testClass) {
        Class dataSetOperationClass = (Class)AnnotationUtils.getMethodOrClassLevelAnnotationProperty(DataSet.class, (String)"loadStrategy", DataSetLoadStrategy.class, (Method)testMethod, testClass);
        dataSetOperationClass = ModuleUtils.getClassValueReplaceDefault(DataSet.class, (String)"loadStrategy", (Class)dataSetOperationClass, this.defaultAnnotationPropertyValues, DataSetLoadStrategy.class);
        return (DataSetLoadStrategy)ReflectionUtils.createInstanceOfType((Class)dataSetOperationClass, (boolean)false);
    }

    protected DbUnitDatabaseConnection createDbUnitConnection(String schemaName) {
        DataSource dataSource = this.getDatabaseModule().getWrapper(this.databaseName).getDataSourceAndActivateTransactionIfNeeded();
        DefaultSQLHandler sqlHandler = new DefaultSQLHandler(dataSource);
        DbSupport dbSupport = DbSupportFactory.getDbSupport((Properties)this.configuration, (SQLHandler)sqlHandler, (String)schemaName, (String)this.dialect);
        DbUnitDatabaseConnection connection = new DbUnitDatabaseConnection(dataSource, dbSupport.getSchemaName());
        DatabaseConfig config = connection.getConfig();
        IDataTypeFactory dataTypeFactory = (IDataTypeFactory)ConfigUtils.getInstanceOf(IDataTypeFactory.class, (Properties)this.configuration, (String[])new String[]{dbSupport.getDatabaseDialect()});
        config.setProperty("http://www.dbunit.org/properties/datatypeFactory", (Object)dataTypeFactory);
        if (dbSupport.getIdentifierQuoteString() != null) {
            config.setProperty("http://www.dbunit.org/properties/escapePattern", (Object)(dbSupport.getIdentifierQuoteString() + '?' + dbSupport.getIdentifierQuoteString()));
        }
        config.setProperty("http://www.dbunit.org/features/batchedStatements", (Object)"true");
        config.setProperty("http://www.dbunit.org/features/skipOracleRecycleBinTables", (Object)"true");
        return connection;
    }

    protected void closeJdbcConnection() {
        try {
            for (DbUnitDatabaseConnection dbUnitDatabaseConnection : this.dbUnitDatabaseConnections.values()) {
                dbUnitDatabaseConnection.closeJdbcConnection();
            }
        }
        catch (SQLException e) {
            throw new UnitilsException("Error while closing connection.", (Throwable)e);
        }
    }

    protected String getCorrectFileName(Class<?> testClass, Method method, String extension) {
        String name = this.getDefaultDataSetFileNameMethodLevel(testClass, method, extension);
        DataSetResolver dataSetResolver = this.getDataSetResolver();
        try {
            dataSetResolver.resolve(testClass, name);
            return testClass.getPackage().getName() + "." + name;
        }
        catch (Exception e) {
            return this.getDefaultDataSetFileNameClassLevel(testClass, extension);
        }
    }

    protected String getDefaultDataSetFileNameClassLevel(Class<?> testClass, String extension) {
        String className = testClass.getName();
        StringBuilder builder = new StringBuilder();
        if (className.contains(".")) {
            className = className.replace(".", "/");
        }
        builder.append(className);
        builder.append(".");
        builder.append(extension);
        return builder.toString();
    }

    protected String getDefaultDataSetFileNameMethodLevel(Class<?> testClass, Method method, String extension) {
        String className = testClass.getName();
        StringBuilder builder = new StringBuilder();
        if (className.contains(".")) {
            className = className.substring(className.lastIndexOf(".") + 1);
        }
        builder.append(className);
        builder.append("-");
        builder.append(method.getName());
        builder.append(".");
        builder.append(extension);
        return builder.toString();
    }

    protected String getDefaultExpectedDataSetFileName(Method method, Class<?> testClass, String extension) {
        String className = testClass.getName();
        return className.replace(".", "/") + "." + method.getName() + "-result." + extension;
    }

    protected DataSetFactory getDefaultDataSetFactory() {
        Class dataSetFactoryClass = ReflectionUtils.getClassWithName((String)ModuleUtils.getAnnotationPropertyDefault(DbUnitModule.class, DataSet.class, (String)"factory", (Properties)this.configuration));
        return this.getDataSetFactory(dataSetFactoryClass);
    }

    protected DataSetFactory getDataSetFactory(Class<? extends Annotation> annotationClass, Method testMethod, Class<?> testClass) {
        Class dataSetFactoryClass = (Class)AnnotationUtils.getMethodOrClassLevelAnnotationProperty(annotationClass, (String)"factory", DataSetFactory.class, (Method)testMethod, testClass);
        dataSetFactoryClass = ModuleUtils.getClassValueReplaceDefault(annotationClass, (String)"factory", (Class)dataSetFactoryClass, this.defaultAnnotationPropertyValues, DataSetFactory.class);
        return this.getDataSetFactory(dataSetFactoryClass);
    }

    protected DataSetFactory getDataSetFactory(Class<? extends DataSetFactory> dataSetFactoryClass) {
        DataSetFactory dataSetFactory = (DataSetFactory)ReflectionUtils.createInstanceOfType(dataSetFactoryClass, (boolean)false);
        dataSetFactory.init(this.configuration, this.getDefaultDbSupport().getSchemaName());
        return dataSetFactory;
    }

    protected DataSetLoadStrategy getDefaultDataSetLoadStrategy() {
        Class dataSetLoadStrategyClassName = ReflectionUtils.getClassWithName((String)ModuleUtils.getAnnotationPropertyDefault(DbUnitModule.class, DataSet.class, (String)"loadStrategy", (Properties)this.configuration));
        return (DataSetLoadStrategy)ReflectionUtils.createInstanceOfType((Class)dataSetLoadStrategyClassName, (boolean)false);
    }

    protected DataSetResolver getDataSetResolver() {
        return (DataSetResolver)ConfigUtils.getConfiguredInstanceOf(DataSetResolver.class, (Properties)this.configuration, (String[])new String[0]);
    }

    protected DbSupport getDefaultDbSupport() {
        DataSource dataSource = this.getDatabaseModule().getWrapper(this.databaseName).getDataSourceAndActivateTransactionIfNeeded();
        DefaultSQLHandler sqlHandler = new DefaultSQLHandler(dataSource);
        return DbSupportFactory.getDefaultDbSupport((Properties)this.configuration, (SQLHandler)sqlHandler, (String)this.dialect);
    }

    protected DatabaseModule getDatabaseModule() {
        return (DatabaseModule)Unitils.getInstance().getModulesRepository().getModuleOfType(DatabaseModule.class);
    }

    protected ResourcePickingStrategie getResourcePickingStrategie() {
        return (ResourcePickingStrategie)ConfigUtils.getInstanceOf(ResourcePickingStrategie.class, (Properties)this.configuration, (String[])new String[]{""});
    }

    public TestListener getTestListener() {
        return new DbUnitListener();
    }

    protected class DbUnitListener
    extends TestListener {
        protected DbUnitListener() {
        }

        public void beforeTestSetUp(Object testObject, Method testMethod) {
            DbUnitModule.this.insertDataSet(testMethod, testObject);
        }

        public void afterTestMethod(Object testObject, Method testMethod, Throwable throwable) {
            if (throwable == null) {
                DbUnitModule.this.assertDbContentAsExpected(testMethod, testObject);
            }
        }
    }
}

