/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.dbunit.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitils.thirdparty.org.apache.commons.io.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileHandler {
    private static final Log LOGGER = LogFactory.getLog(FileHandler.class);

    public File createTempFile(String dataSetResourceName) {
        int lastIndexOfSlash;
        LOGGER.debug((Object)"Creating temp file.");
        String tempDataSetResourceName = new String(dataSetResourceName);
        if (tempDataSetResourceName.endsWith("/")) {
            tempDataSetResourceName = tempDataSetResourceName.substring(0, tempDataSetResourceName.length() - 1);
        }
        String nameFile = tempDataSetResourceName.substring((lastIndexOfSlash = tempDataSetResourceName.lastIndexOf("/")) < 0 ? 0 : lastIndexOfSlash + 1, tempDataSetResourceName.lastIndexOf("."));
        try {
            return File.createTempFile(nameFile + "-", ".xml");
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public void writeToFile(File file, InputStream in) {
        try {
            FileOutputStream fos = new FileOutputStream(file);
            String path = file.getAbsolutePath();
            LOGGER.debug((Object)("Writing preprocessed dataset to temp file: " + path));
            if (in.markSupported()) {
                in.mark(Integer.MAX_VALUE);
                IOUtils.copy((InputStream)in, (OutputStream)fos);
                in.reset();
            } else {
                IOUtils.copy((InputStream)in, (OutputStream)fos);
            }
            LOGGER.trace((Object)("inputstream visualised: \n" + IOUtils.toString((InputStream)in)));
            fos.close();
            LOGGER.debug((Object)("End writing preprocessed dataset to file: " + path));
        }
        catch (IOException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void deleteFiles(List<File> files) {
        for (File file : files) {
            LOGGER.debug((Object)("Deleting temp file: " + file.getAbsolutePath()));
            if (file.exists()) {
                file.delete();
                continue;
            }
            LOGGER.warn((Object)("File " + file.getName() + " not found."));
        }
    }
}

