/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.easymock;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.easymock.classextension.internal.MocksClassControl;
import org.easymock.internal.MocksControl;
import org.easymock.internal.ReplayState;
import org.unitils.core.Module;
import org.unitils.core.TestListener;
import org.unitils.core.UnitilsException;
import org.unitils.easymock.annotation.AfterCreateMock;
import org.unitils.easymock.annotation.Mock;
import org.unitils.easymock.annotation.RegularMock;
import org.unitils.easymock.util.Calls;
import org.unitils.easymock.util.Dates;
import org.unitils.easymock.util.Defaults;
import org.unitils.easymock.util.InvocationOrder;
import org.unitils.easymock.util.LenientMocksControl;
import org.unitils.easymock.util.Order;
import org.unitils.reflectionassert.ReflectionComparatorMode;
import org.unitils.util.AnnotationUtils;
import org.unitils.util.ModuleUtils;
import org.unitils.util.PropertyUtils;
import org.unitils.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EasyMockModule
implements Module {
    public static final String PROPKEY_AUTO_VERIFY_AFTER_TEST_ENABLED = "EasyMockModule.autoVerifyAfterTest.enabled";
    private List<MocksControl> mocksControls;
    private Map<Class<? extends Annotation>, Map<String, String>> defaultAnnotationPropertyValues;
    private boolean autoVerifyAfterTestEnabled;

    public void init(Properties configuration) {
        this.mocksControls = new ArrayList<MocksControl>();
        this.defaultAnnotationPropertyValues = ModuleUtils.getAnnotationPropertyDefaults(EasyMockModule.class, (Properties)configuration, (Class[])new Class[]{RegularMock.class, Mock.class});
        this.autoVerifyAfterTestEnabled = PropertyUtils.getBoolean((String)PROPKEY_AUTO_VERIFY_AFTER_TEST_ENABLED, (Properties)configuration);
    }

    public void afterInit() {
    }

    public TestListener getTestListener() {
        return new EasyMockTestListener();
    }

    public <T> T createRegularMock(Class<T> mockType, InvocationOrder invocationOrder, Calls calls) {
        invocationOrder = (InvocationOrder)ModuleUtils.getEnumValueReplaceDefault(RegularMock.class, (String)"invocationOrder", (Enum)invocationOrder, this.defaultAnnotationPropertyValues);
        MocksClassControl mocksControl = Calls.LENIENT == (calls = (Calls)ModuleUtils.getEnumValueReplaceDefault(RegularMock.class, (String)"calls", (Enum)calls, this.defaultAnnotationPropertyValues)) ? new MocksClassControl(MocksControl.MockType.NICE) : new MocksClassControl(MocksControl.MockType.DEFAULT);
        if (InvocationOrder.STRICT == invocationOrder) {
            mocksControl.checkOrder(true);
        }
        this.mocksControls.add((MocksControl)mocksControl);
        return (T)mocksControl.createMock(mockType);
    }

    public <T> T createMock(Class<T> mockType, InvocationOrder invocationOrder, Calls calls, Order order, Dates dates, Defaults defaults) {
        invocationOrder = (InvocationOrder)ModuleUtils.getEnumValueReplaceDefault(Mock.class, (String)"invocationOrder", (Enum)invocationOrder, this.defaultAnnotationPropertyValues);
        calls = (Calls)ModuleUtils.getEnumValueReplaceDefault(Mock.class, (String)"calls", (Enum)calls, this.defaultAnnotationPropertyValues);
        order = (Order)ModuleUtils.getEnumValueReplaceDefault(Mock.class, (String)"order", (Enum)order, this.defaultAnnotationPropertyValues);
        dates = (Dates)ModuleUtils.getEnumValueReplaceDefault(Mock.class, (String)"dates", (Enum)dates, this.defaultAnnotationPropertyValues);
        defaults = (Defaults)ModuleUtils.getEnumValueReplaceDefault(Mock.class, (String)"defaults", (Enum)defaults, this.defaultAnnotationPropertyValues);
        ArrayList<ReflectionComparatorMode> comparatorModes = new ArrayList<ReflectionComparatorMode>();
        if (Order.LENIENT == order) {
            comparatorModes.add(ReflectionComparatorMode.LENIENT_ORDER);
        }
        if (Dates.LENIENT == dates) {
            comparatorModes.add(ReflectionComparatorMode.LENIENT_DATES);
        }
        if (Defaults.IGNORE_DEFAULTS == defaults) {
            comparatorModes.add(ReflectionComparatorMode.IGNORE_DEFAULTS);
        }
        LenientMocksControl mocksControl = Calls.LENIENT == calls ? new LenientMocksControl(MocksControl.MockType.NICE, comparatorModes.toArray(new ReflectionComparatorMode[0])) : new LenientMocksControl(MocksControl.MockType.DEFAULT, comparatorModes.toArray(new ReflectionComparatorMode[0]));
        if (InvocationOrder.STRICT == invocationOrder) {
            mocksControl.checkOrder(true);
        }
        this.mocksControls.add((MocksControl)mocksControl);
        return (T)mocksControl.createMock(mockType);
    }

    public void replay() {
        for (MocksControl mocksControl : this.mocksControls) {
            mocksControl.replay();
        }
    }

    public void reset() {
        for (MocksControl mocksControl : this.mocksControls) {
            mocksControl.reset();
        }
    }

    public void verify() {
        for (MocksControl mocksControl : this.mocksControls) {
            if (!(mocksControl.getState() instanceof ReplayState)) {
                mocksControl.replay();
            }
            mocksControl.verify();
        }
    }

    protected void createAndInjectRegularMocksIntoTest(Object testObject) {
        Set mockFields = AnnotationUtils.getFieldsAnnotatedWith(testObject.getClass(), RegularMock.class);
        for (Field mockField : mockFields) {
            Class<?> mockType = mockField.getType();
            RegularMock regularMockAnnotation = mockField.getAnnotation(RegularMock.class);
            Object mockObject = this.createRegularMock(mockType, regularMockAnnotation.invocationOrder(), regularMockAnnotation.calls());
            ReflectionUtils.setFieldValue((Object)testObject, (Field)mockField, mockObject);
            this.callAfterCreateMockMethods(testObject, mockObject, mockField.getName(), mockType);
        }
    }

    protected void createAndInjectMocksIntoTest(Object testObject) {
        Set mockFields = AnnotationUtils.getFieldsAnnotatedWith(testObject.getClass(), Mock.class);
        for (Field mockField : mockFields) {
            Class<?> mockType = mockField.getType();
            Mock mockAnnotation = mockField.getAnnotation(Mock.class);
            Object mockObject = this.createMock(mockType, mockAnnotation.invocationOrder(), mockAnnotation.calls(), mockAnnotation.order(), mockAnnotation.dates(), mockAnnotation.defaults());
            ReflectionUtils.setFieldValue((Object)testObject, (Field)mockField, mockObject);
            this.callAfterCreateMockMethods(testObject, mockObject, mockField.getName(), mockType);
        }
    }

    protected void callAfterCreateMockMethods(Object testObject, Object mockObject, String name, Class<?> type) {
        Set methods = AnnotationUtils.getMethodsAnnotatedWith(testObject.getClass(), AfterCreateMock.class);
        for (Method method : methods) {
            try {
                ReflectionUtils.invokeMethod((Object)testObject, (Method)method, (Object[])new Object[]{mockObject, name, type});
            }
            catch (InvocationTargetException e) {
                throw new UnitilsException("An exception occurred while invoking an after create mock method.", (Throwable)e);
            }
            catch (Exception e) {
                throw new UnitilsException("Unable to invoke after create mock method. Ensure that this method has following signature: void myMethod(Object mock, String name, Class type)", (Throwable)e);
            }
        }
    }

    protected class EasyMockTestListener
    extends TestListener {
        protected EasyMockTestListener() {
        }

        public void beforeTestSetUp(Object testObject, Method testMethod) {
            EasyMockModule.this.mocksControls.clear();
            EasyMockModule.this.createAndInjectRegularMocksIntoTest(testObject);
            EasyMockModule.this.createAndInjectMocksIntoTest(testObject);
        }

        public void afterTestMethod(Object testObject, Method testMethod, Throwable throwable) {
            if (EasyMockModule.this.autoVerifyAfterTestEnabled && throwable == null) {
                EasyMockModule.this.verify();
            }
        }
    }
}

