/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.io.filecontent.impl;

import java.io.InputStream;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.unitils.core.UnitilsException;
import org.unitils.io.conversion.ConversionStrategy;
import org.unitils.io.filecontent.FileContentReader;
import org.unitils.io.reader.ReadingStrategy;
import org.unitils.thirdparty.org.apache.commons.io.IOUtils;

public class DefaultFileContentReader
implements FileContentReader {
    protected ReadingStrategy readingStrategy;
    protected List<ConversionStrategy<?>> conversionStrategies;
    protected String defaultEncoding;

    public DefaultFileContentReader(ReadingStrategy readingStrategy, List<ConversionStrategy<?>> conversionStrategies, String defaultEncoding) {
        this.readingStrategy = readingStrategy;
        this.conversionStrategies = conversionStrategies;
        this.defaultEncoding = defaultEncoding;
    }

    @Override
    public <T> T readFileContent(String fileName, Class<T> targetType, String encoding, Class<?> testClass) {
        Object obj;
        ConversionStrategy<?> conversionStrategy = this.determineConversionStrategy(targetType);
        if (StringUtils.isBlank((String)encoding)) {
            encoding = this.defaultEncoding;
        }
        InputStream inputStream = null;
        try {
            inputStream = StringUtils.isBlank((String)fileName) ? this.readingStrategy.getDefaultInputStream(conversionStrategy.getDefaultFileExtension(), testClass) : this.readingStrategy.getInputStream(fileName, testClass);
            obj = conversionStrategy.convertContent(inputStream, encoding);
        }
        catch (Exception e) {
            try {
                throw new UnitilsException("Unable to read file content for file " + fileName + " and target type " + targetType.getSimpleName(), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return (T)obj;
    }

    protected ConversionStrategy<?> determineConversionStrategy(Class<?> targetType) {
        for (ConversionStrategy<?> conversionStrategy : this.conversionStrategies) {
            if (!conversionStrategy.getTargetType().isAssignableFrom(targetType)) continue;
            return conversionStrategy;
        }
        throw new UnitilsException("Unable to determine conversion strategy for target type " + targetType);
    }
}

