/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.mock.core.matching;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.unitils.core.UnitilsException;
import org.unitils.mock.Mock;
import org.unitils.mock.argumentmatcher.ArgumentMatcher;
import org.unitils.mock.argumentmatcher.ArgumentMatcherPositionFinder;
import org.unitils.mock.argumentmatcher.ArgumentMatcherRepository;
import org.unitils.mock.argumentmatcher.impl.DefaultArgumentMatcher;
import org.unitils.mock.core.matching.MatchingInvocationHandler;
import org.unitils.mock.core.proxy.ProxyFactory;
import org.unitils.mock.core.proxy.ProxyInvocation;
import org.unitils.mock.core.proxy.ProxyInvocationHandler;
import org.unitils.mock.core.proxy.StackTraceUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatchingInvocationBuilder {
    protected String currentMockName;
    protected String definingMethodName;
    protected StackTraceElement[] invokedAt;

    public synchronized <T> T startMatchingInvocation(String mockName, Class<T> mockedType, MatchingInvocationHandler matchingInvocationHandler) {
        this.assertNotExpectingInvocation();
        this.currentMockName = mockName;
        this.invokedAt = StackTraceUtils.getInvocationStackTrace(Mock.class);
        this.definingMethodName = this.invokedAt[0].getMethodName();
        ArgumentMatcherRepository.getInstance().registerStartOfMatchingInvocation(this.invokedAt[1].getLineNumber());
        return ProxyFactory.createUninitializedProxy(mockName, new InvocationHandler(matchingInvocationHandler), mockedType, new Class[0]);
    }

    public synchronized void reset() {
        this.currentMockName = null;
        this.invokedAt = null;
        this.definingMethodName = null;
    }

    public synchronized void assertNotExpectingInvocation() {
        if (this.currentMockName != null && !this.currentMockName.contains(".")) {
            UnitilsException exception = new UnitilsException("Invalid syntax. " + this.currentMockName + "." + this.definingMethodName + "() must be followed by a method invocation on the returned proxy. E.g. " + this.currentMockName + "." + this.definingMethodName + "().myMethod();");
            exception.setStackTrace(StackTraceUtils.getStackTraceStartingFrom(this.invokedAt, 1));
            this.reset();
            throw exception;
        }
        this.reset();
    }

    protected Object handleProxyInvocation(ProxyInvocation proxyInvocation, MatchingInvocationHandler matchingInvocationHandler) throws Throwable {
        ArgumentMatcherRepository.getInstance().registerEndOfMatchingInvocation(proxyInvocation.getLineNumber(), proxyInvocation.getMethod().getName());
        this.reset();
        List<ArgumentMatcher> argumentMatchers = this.createArgumentMatchers(proxyInvocation);
        Object result = matchingInvocationHandler.handleInvocation(proxyInvocation, argumentMatchers);
        ArgumentMatcherRepository.getInstance().reset();
        return result;
    }

    protected List<ArgumentMatcher> createArgumentMatchers(ProxyInvocation proxyInvocation) {
        ArrayList<ArgumentMatcher> result = new ArrayList<ArgumentMatcher>();
        ArgumentMatcherRepository argumentMatcherRepository = ArgumentMatcherRepository.getInstance();
        int matchInvocationStartLineNr = argumentMatcherRepository.getMatchInvocationStartLineNr();
        int matchInvocationEndLineNr = argumentMatcherRepository.getMatchInvocationEndLineNr();
        int matchInvocationIndex = argumentMatcherRepository.getMatchInvocationIndex();
        List<Integer> argumentMatcherIndexes = ArgumentMatcherPositionFinder.getArgumentMatcherIndexes(proxyInvocation, matchInvocationStartLineNr, matchInvocationEndLineNr, matchInvocationIndex);
        int argumentIndex = 0;
        Iterator<ArgumentMatcher> argumentMatcherIterator = ArgumentMatcherRepository.getInstance().getArgumentMatchers().iterator();
        for (Object argument : proxyInvocation.getArguments()) {
            if (argumentMatcherIndexes.contains(argumentIndex++)) {
                result.add(argumentMatcherIterator.next());
                continue;
            }
            result.add(new DefaultArgumentMatcher(argument));
        }
        argumentMatcherRepository.reset();
        return result;
    }

    protected class InvocationHandler
    implements ProxyInvocationHandler {
        private MatchingInvocationHandler matchingInvocationHandler;

        public InvocationHandler(MatchingInvocationHandler matchingInvocationHandler) {
            this.matchingInvocationHandler = matchingInvocationHandler;
        }

        public Object handleInvocation(ProxyInvocation proxyInvocation) throws Throwable {
            return MatchingInvocationBuilder.this.handleProxyInvocation(proxyInvocation, this.matchingInvocationHandler);
        }
    }
}

