/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.mock.core.proxy;

import java.util.Arrays;
import java.util.HashSet;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.Factory;
import net.sf.cglib.proxy.MethodInterceptor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.objenesis.ObjenesisStd;
import org.unitils.core.UnitilsException;
import org.unitils.mock.core.proxy.CglibProxyMethodInterceptor;
import org.unitils.mock.core.proxy.ProxyInvocationHandler;
import org.unitils.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyFactory {
    private static Log logger = LogFactory.getLog(ProxyFactory.class);

    public static <T> T createProxy(String mockName, ProxyInvocationHandler invocationHandler, Class<T> proxiedClass, Class<?> ... implementedInterfaces) {
        return ProxyFactory.createProxy(mockName, true, invocationHandler, proxiedClass, implementedInterfaces);
    }

    public static <T> T createUninitializedProxy(String mockName, ProxyInvocationHandler invocationHandler, Class<T> proxiedClass, Class<?> ... implementedInterfaces) {
        return ProxyFactory.createProxy(mockName, false, invocationHandler, proxiedClass, implementedInterfaces);
    }

    protected static <T> T createProxy(String mockName, boolean initialize, ProxyInvocationHandler invocationHandler, Class<T> proxiedClass, Class<?> ... implementedInterfaces) {
        Class<T> enhancedClass = ProxyFactory.createEnhancedClass(proxiedClass, implementedInterfaces);
        Factory proxy = initialize && !proxiedClass.isInterface() ? (Factory)ProxyFactory.createInitializedOrUnitializedInstanceOfType(enhancedClass) : (Factory)ProxyFactory.createUninitializedInstanceOfType(enhancedClass);
        proxy.setCallbacks(new Callback[]{new CglibProxyMethodInterceptor<T>(mockName, proxiedClass, invocationHandler)});
        return (T)proxy;
    }

    public static <T> T createInitializedOrUnitializedInstanceOfType(Class<T> clazz) {
        try {
            return (T)ReflectionUtils.createInstanceOfType(clazz, (boolean)true);
        }
        catch (UnitilsException e) {
            logger.warn((Object)("Could not create initialized instance of type " + clazz.getSimpleName() + ". No no-arg constructor found. All fields in the instance will have the java default values. Add a default constructor (can be private) if the fields should be initialized. If this concerns an innerclass, make sure it is declared static. Partial mocking of non-static innerclasses is not supported."));
            return ProxyFactory.createUninitializedInstanceOfType(clazz);
        }
    }

    public static <T> T createUninitializedInstanceOfType(Class<T> clazz) {
        ObjenesisStd objenesis = new ObjenesisStd();
        return (T)objenesis.newInstance(clazz);
    }

    protected static <T> Class<T> createEnhancedClass(Class<T> proxiedClass, Class<?> ... implementedInterfaces) {
        Enhancer enhancer = new Enhancer();
        HashSet interfaces = new HashSet();
        if (proxiedClass.isInterface()) {
            enhancer.setSuperclass(Object.class);
            interfaces.add(proxiedClass);
        } else {
            enhancer.setSuperclass(proxiedClass);
        }
        if (implementedInterfaces != null && implementedInterfaces.length > 0) {
            interfaces.addAll(Arrays.asList(implementedInterfaces));
        }
        if (!interfaces.isEmpty()) {
            enhancer.setInterfaces(interfaces.toArray(new Class[interfaces.size()]));
        }
        enhancer.setCallbackType(MethodInterceptor.class);
        enhancer.setUseFactory(true);
        return enhancer.createClass();
    }
}

