/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.mock.core.proxy;

import java.util.ArrayList;
import java.util.Arrays;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Factory;
import org.unitils.core.UnitilsException;
import org.unitils.mock.core.MockObject;
import org.unitils.mock.core.proxy.CglibProxyMethodInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyUtils {
    public static Class<?> getProxiedTypeIfProxy(Object object) {
        if (object == null) {
            return null;
        }
        Class<?> type = object.getClass();
        if (object instanceof Factory) {
            Callback[] callbacks = ((Factory)object).getCallbacks();
            if (callbacks == null || callbacks.length == 0) {
                return null;
            }
            if (callbacks[0] instanceof CglibProxyMethodInterceptor) {
                return ((CglibProxyMethodInterceptor)callbacks[0]).getProxiedType();
            }
        }
        return null;
    }

    public static boolean isProxyClassName(String className) {
        return className.contains("$$EnhancerByCGLIB$$");
    }

    public static String getMockName(Object object) {
        Callback callback;
        if (object == null) {
            return null;
        }
        if (object instanceof MockObject) {
            return ((MockObject)object).getName();
        }
        Class<?> type = object.getClass();
        if (object instanceof Factory && (callback = ((Factory)object).getCallback(0)) instanceof CglibProxyMethodInterceptor) {
            return ((CglibProxyMethodInterceptor)callback).getMockName();
        }
        return null;
    }

    public static StackTraceElement[] getProxiedMethodStackTrace() {
        Object[] stackTraceElements;
        ArrayList<StackTraceElement> stackTrace = new ArrayList<StackTraceElement>();
        boolean foundProxyMethod = false;
        for (StackTraceElement stackTraceElement : stackTraceElements = Thread.currentThread().getStackTrace()) {
            if (foundProxyMethod) {
                stackTrace.add(stackTraceElement);
                continue;
            }
            if (!ProxyUtils.isProxyClassName(stackTraceElement.getClassName())) continue;
            foundProxyMethod = true;
        }
        if (stackTrace.isEmpty()) {
            throw new UnitilsException("No invocation of a cglib proxy method found in stacktrace: " + Arrays.toString(stackTraceElements));
        }
        return stackTrace.toArray(new StackTraceElement[stackTrace.size()]);
    }
}

