/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.mock;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitils.core.Module;
import org.unitils.core.TestListener;
import org.unitils.core.UnitilsException;
import org.unitils.mock.Mock;
import org.unitils.mock.PartialMock;
import org.unitils.mock.annotation.AfterCreateMock;
import org.unitils.mock.annotation.Dummy;
import org.unitils.mock.core.MockObject;
import org.unitils.mock.core.PartialMockObject;
import org.unitils.mock.core.Scenario;
import org.unitils.mock.dummy.DummyObjectUtil;
import org.unitils.util.AnnotationUtils;
import org.unitils.util.PropertyUtils;
import org.unitils.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockModule
implements Module {
    private static Log logger = LogFactory.getLog(MockModule.class);
    public static final String PROPERTY_LOG_FULL_SCENARIO_REPORT = "mockModule.logFullScenarioReport";
    public static final String PROPERTY_LOG_OBSERVED_SCENARIO = "mockModule.logObservedScenario";
    public static final String PROPERTY_LOG_DETAILED_OBSERVED_SCENARIO = "mockModule.logDetailedObservedScenario";
    public static final String PROPERTY_LOG_SUGGESTED_ASSERTS = "mockModule.logSuggestedAsserts";
    protected boolean logFullScenarioReport;
    protected boolean logObservedScenario;
    protected boolean logDetailedObservedScenario;
    protected boolean logSuggestedAsserts;

    public void init(Properties configuration) {
        this.logFullScenarioReport = PropertyUtils.getBoolean((String)PROPERTY_LOG_FULL_SCENARIO_REPORT, (Properties)configuration);
        this.logObservedScenario = PropertyUtils.getBoolean((String)PROPERTY_LOG_OBSERVED_SCENARIO, (Properties)configuration);
        this.logDetailedObservedScenario = PropertyUtils.getBoolean((String)PROPERTY_LOG_DETAILED_OBSERVED_SCENARIO, (Properties)configuration);
        this.logSuggestedAsserts = PropertyUtils.getBoolean((String)PROPERTY_LOG_SUGGESTED_ASSERTS, (Properties)configuration);
    }

    public void afterInit() {
    }

    public Scenario getScenario() {
        return MockObject.getCurrentScenario();
    }

    public void logFullScenarioReport() {
        String report = "\n\n" + this.getScenario().createFullReport();
        logger.info((Object)report);
    }

    public void logObservedScenario() {
        String report = "\n\nObserved scenario:\n\n" + this.getScenario().createObservedInvocationsReport();
        logger.info((Object)report);
    }

    public void logDetailedObservedScenario() {
        String report = "\n\nDetailed observed scenario:\n\n" + this.getScenario().createDetailedObservedInvocationsReport();
        logger.info((Object)report);
    }

    public void logSuggestedAsserts() {
        String report = "\n\nSuggested assert statements:\n\n" + this.getScenario().createSuggestedAssertsReport();
        logger.info((Object)report);
    }

    public <T> Mock<T> createMock(Object testObject, String name, Class<?> type) {
        return new MockObject(name, type, testObject);
    }

    public <T> Mock<T> createPartialMock(Object testObject, String name, Class<?> type) {
        return new PartialMockObject(name, type, testObject);
    }

    protected Class<?> getMockedClass(Field field) {
        try {
            Type type = ReflectionUtils.getGenericType((Field)field);
            return ReflectionUtils.getClassForType((Type)type);
        }
        catch (UnitilsException e) {
            throw new UnitilsException("Unable to determine type of mock. A mock should be declared using the generic Mock<YourTypeToMock> or PartialMock<YourTypeToMock> types. Field: " + field, (Throwable)e);
        }
    }

    protected void createAndInjectMocksIntoTest(Object testObject) {
        Set mockFields = ReflectionUtils.getFieldsOfType(testObject.getClass(), Mock.class, (boolean)false);
        for (Field field : mockFields) {
            Mock mock = (Mock)ReflectionUtils.getFieldValue((Object)testObject, (Field)field);
            if (mock != null) {
                mock.resetBehavior();
                continue;
            }
            mock = this.createMock(testObject, field.getName(), this.getMockedClass(field));
            this.injectMock(testObject, field, mock);
        }
    }

    protected void createAndInjectPartialMocksIntoTest(Object testObject) {
        Set partialMockFields = ReflectionUtils.getFieldsOfType(testObject.getClass(), PartialMock.class, (boolean)false);
        for (Field field : partialMockFields) {
            Mock mock = (Mock)ReflectionUtils.getFieldValue((Object)testObject, (Field)field);
            if (mock != null) {
                mock.resetBehavior();
                continue;
            }
            mock = this.createPartialMock(testObject, field.getName(), this.getMockedClass(field));
            this.injectMock(testObject, field, mock);
        }
    }

    protected void injectMock(Object testObject, Field field, Mock<?> mock) {
        ReflectionUtils.setFieldValue((Object)testObject, (Field)field, mock);
        this.callAfterCreateMockMethods(testObject, mock, field.getName(), field.getType());
    }

    protected void createAndInjectDummiesIntoTest(Object testObject) {
        Set dummyFields = AnnotationUtils.getFieldsAnnotatedWith(testObject.getClass(), Dummy.class);
        for (Field dummyField : dummyFields) {
            Object dummy = DummyObjectUtil.createDummy(dummyField.getType());
            ReflectionUtils.setFieldValue((Object)testObject, (Field)dummyField, dummy);
        }
    }

    protected void callAfterCreateMockMethods(Object testObject, Mock<?> mockObject, String name, Class<?> type) {
        Set methods = AnnotationUtils.getMethodsAnnotatedWith(testObject.getClass(), AfterCreateMock.class);
        for (Method method : methods) {
            try {
                ReflectionUtils.invokeMethod((Object)testObject, (Method)method, (Object[])new Object[]{mockObject.getMock(), name, ((MockObject)mockObject).getMockedType()});
            }
            catch (InvocationTargetException e) {
                throw new UnitilsException("An exception occurred while invoking an after create mock method.", (Throwable)e);
            }
            catch (Exception e) {
                throw new UnitilsException("Unable to invoke after create mock method. Ensure that this method has following signature: void myMethod(Object mock, String name, Class type)", (Throwable)e);
            }
        }
    }

    public TestListener getTestListener() {
        return new MockTestListener();
    }

    protected class MockTestListener
    extends TestListener {
        protected MockTestListener() {
        }

        public void beforeTestSetUp(Object testObject, Method testMethod) {
            MockModule.this.createAndInjectPartialMocksIntoTest(testObject);
            MockModule.this.createAndInjectMocksIntoTest(testObject);
            MockModule.this.createAndInjectDummiesIntoTest(testObject);
        }

        public void afterTestTearDown(Object testObject, Method testMethod) {
            if (MockModule.this.logFullScenarioReport) {
                MockModule.this.logFullScenarioReport();
                return;
            }
            if (MockModule.this.logObservedScenario) {
                MockModule.this.logObservedScenario();
            }
            if (MockModule.this.logDetailedObservedScenario) {
                MockModule.this.logDetailedObservedScenario();
            }
            if (MockModule.this.logSuggestedAsserts) {
                MockModule.this.logSuggestedAsserts();
            }
        }
    }
}

