/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.mock.core;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import org.unitils.core.util.ObjectToInjectHolder;
import org.unitils.mock.Mock;
import org.unitils.mock.annotation.MatchStatement;
import org.unitils.mock.argumentmatcher.ArgumentMatcherRepository;
import org.unitils.mock.core.BehaviorDefiningInvocations;
import org.unitils.mock.core.MockFactory;
import org.unitils.mock.core.MockProxy;
import org.unitils.mock.core.Scenario;
import org.unitils.mock.core.matching.MatchingInvocationBuilder;
import org.unitils.mock.core.matching.MatchingInvocationHandler;
import org.unitils.mock.core.matching.impl.AssertInvokedInSequenceVerifyingMatchingInvocationHandler;
import org.unitils.mock.core.matching.impl.AssertInvokedVerifyingMatchingInvocationHandler;
import org.unitils.mock.core.matching.impl.AssertNotInvokedVerifyingMatchingInvocationHandler;
import org.unitils.mock.core.matching.impl.BehaviorDefiningMatchingInvocationHandler;
import org.unitils.mock.core.proxy.ProxyFactory;
import org.unitils.mock.mockbehavior.MockBehavior;
import org.unitils.mock.mockbehavior.impl.ExceptionThrowingMockBehavior;
import org.unitils.mock.mockbehavior.impl.ValueReturningMockBehavior;
import org.unitils.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockObject<T>
implements Mock<T>,
MockFactory,
ObjectToInjectHolder<T> {
    protected String name;
    protected Class<T> mockedType;
    protected MockProxy<T> mockProxy;
    protected BehaviorDefiningInvocations oneTimeMatchingBehaviorDefiningInvocations;
    protected BehaviorDefiningInvocations alwaysMatchingBehaviorDefiningInvocations;
    protected static ThreadLocal<Scenario> scenarioThreadLocal = new ThreadLocal();
    protected static ThreadLocal<MatchingInvocationBuilder> matchingInvocationBuilderThreadLocal = new ThreadLocal();

    public static Scenario getCurrentScenario() {
        return scenarioThreadLocal.get();
    }

    public MockObject(String name, Class<?> mockedType, Object testObject) {
        this.name = name;
        this.mockedType = mockedType;
        this.oneTimeMatchingBehaviorDefiningInvocations = this.createOneTimeMatchingBehaviorDefiningInvocations();
        this.alwaysMatchingBehaviorDefiningInvocations = this.createAlwaysMatchingBehaviorDefiningInvocations();
        Scenario scenario = this.getScenario(testObject);
        if (scenario.getTestObject() != testObject) {
            scenario.reset();
            this.getMatchingInvocationBuilder().reset();
            scenario.setTestObject(testObject);
        }
        this.mockProxy = this.createMockProxy();
    }

    public T getObjectToInject() {
        return this.getMock();
    }

    public Type getObjectToInjectType(Field field) {
        if (field == null) {
            return this.mockedType;
        }
        return ReflectionUtils.getGenericType((Field)field);
    }

    @Override
    public T getMock() {
        return this.mockProxy.getProxy();
    }

    public Class<?> getMockedType() {
        return this.mockedType;
    }

    @Override
    @MatchStatement
    public T returns(Object returnValue) {
        MatchingInvocationHandler matchingInvocationHandler = this.createAlwaysMatchingBehaviorDefiningMatchingInvocationHandler(new ValueReturningMockBehavior(returnValue));
        return this.startMatchingInvocation(matchingInvocationHandler);
    }

    @Override
    @MatchStatement
    public T raises(Throwable exception) {
        MatchingInvocationHandler matchingInvocationHandler = this.createAlwaysMatchingBehaviorDefiningMatchingInvocationHandler(new ExceptionThrowingMockBehavior(exception));
        return this.startMatchingInvocation(matchingInvocationHandler);
    }

    @Override
    @MatchStatement
    public T raises(Class<? extends Throwable> exceptionClass) {
        Throwable exception = ProxyFactory.createInitializedOrUnitializedInstanceOfType(exceptionClass);
        exception.fillInStackTrace();
        MatchingInvocationHandler matchingInvocationHandler = this.createAlwaysMatchingBehaviorDefiningMatchingInvocationHandler(new ExceptionThrowingMockBehavior(exception));
        return this.startMatchingInvocation(matchingInvocationHandler);
    }

    @Override
    @MatchStatement
    public T performs(MockBehavior mockBehavior) {
        MatchingInvocationHandler matchingInvocationHandler = this.createAlwaysMatchingBehaviorDefiningMatchingInvocationHandler(mockBehavior);
        return this.startMatchingInvocation(matchingInvocationHandler);
    }

    @Override
    @MatchStatement
    public T onceReturns(Object returnValue) {
        MatchingInvocationHandler matchingInvocationHandler = this.createOneTimeMatchingBehaviorDefiningMatchingInvocationHandler(new ValueReturningMockBehavior(returnValue));
        return this.startMatchingInvocation(matchingInvocationHandler);
    }

    @Override
    @MatchStatement
    public T onceRaises(Throwable exception) {
        MatchingInvocationHandler matchingInvocationHandler = this.createOneTimeMatchingBehaviorDefiningMatchingInvocationHandler(new ExceptionThrowingMockBehavior(exception));
        return this.startMatchingInvocation(matchingInvocationHandler);
    }

    @Override
    @MatchStatement
    public T onceRaises(Class<? extends Throwable> exceptionClass) {
        Throwable exception = ProxyFactory.createInitializedOrUnitializedInstanceOfType(exceptionClass);
        MatchingInvocationHandler matchingInvocationHandler = this.createOneTimeMatchingBehaviorDefiningMatchingInvocationHandler(new ExceptionThrowingMockBehavior(exception));
        return this.startMatchingInvocation(matchingInvocationHandler);
    }

    @Override
    @MatchStatement
    public T oncePerforms(MockBehavior mockBehavior) {
        MatchingInvocationHandler matchingInvocationHandler = this.createOneTimeMatchingBehaviorDefiningMatchingInvocationHandler(mockBehavior);
        return this.startMatchingInvocation(matchingInvocationHandler);
    }

    @Override
    @MatchStatement
    public T assertInvoked() {
        MatchingInvocationHandler matchingInvocationHandler = this.createAssertInvokedVerifyingMatchingInvocationHandler();
        return this.startMatchingInvocation(matchingInvocationHandler);
    }

    @Override
    @MatchStatement
    public T assertInvokedInSequence() {
        MatchingInvocationHandler matchingInvocationHandler = this.createAssertInvokedInSequenceVerifyingMatchingInvocationHandler();
        return this.startMatchingInvocation(matchingInvocationHandler);
    }

    @Override
    @MatchStatement
    public T assertNotInvoked() {
        MatchingInvocationHandler matchingInvocationHandler = this.createAssertNotInvokedVerifyingMatchingInvocationHandler();
        return this.startMatchingInvocation(matchingInvocationHandler);
    }

    @Override
    @MatchStatement
    public void resetBehavior() {
        this.oneTimeMatchingBehaviorDefiningInvocations.clear();
        this.alwaysMatchingBehaviorDefiningInvocations.clear();
        this.getMatchingInvocationBuilder().reset();
        ArgumentMatcherRepository.getInstance().reset();
    }

    public <M> Mock<M> createMock(String name, Class<M> mockedType) {
        try {
            if (Void.class.equals(mockedType) || mockedType.isPrimitive() || mockedType.isArray()) {
                return null;
            }
            return new MockObject<T>(name, mockedType, MockObject.getCurrentScenario().getTestObject());
        }
        catch (Throwable t) {
            return null;
        }
    }

    public String getName() {
        return this.name;
    }

    protected T startMatchingInvocation(MatchingInvocationHandler matchingInvocationHandler) {
        return this.getMatchingInvocationBuilder().startMatchingInvocation(this.name, this.mockedType, matchingInvocationHandler);
    }

    protected synchronized MatchingInvocationBuilder getMatchingInvocationBuilder() {
        MatchingInvocationBuilder matchingInvocationBuilder = matchingInvocationBuilderThreadLocal.get();
        if (matchingInvocationBuilder == null) {
            matchingInvocationBuilder = this.createMatchingInvocationBuilder();
            matchingInvocationBuilderThreadLocal.set(matchingInvocationBuilder);
        }
        return matchingInvocationBuilder;
    }

    protected synchronized Scenario getScenario(Object testObject) {
        Scenario scenario = scenarioThreadLocal.get();
        if (scenario == null) {
            scenario = this.createScenario(testObject);
            scenarioThreadLocal.set(scenario);
        }
        return scenario;
    }

    protected MockProxy<T> createMockProxy() {
        return new MockProxy<T>(this.name, this.mockedType, this.oneTimeMatchingBehaviorDefiningInvocations, this.alwaysMatchingBehaviorDefiningInvocations, MockObject.getCurrentScenario(), this.getMatchingInvocationBuilder());
    }

    protected MatchingInvocationHandler createOneTimeMatchingBehaviorDefiningMatchingInvocationHandler(MockBehavior mockBehavior) {
        return new BehaviorDefiningMatchingInvocationHandler(mockBehavior, this.oneTimeMatchingBehaviorDefiningInvocations, this);
    }

    protected MatchingInvocationHandler createAlwaysMatchingBehaviorDefiningMatchingInvocationHandler(MockBehavior mockBehavior) {
        return new BehaviorDefiningMatchingInvocationHandler(mockBehavior, this.alwaysMatchingBehaviorDefiningInvocations, this);
    }

    protected BehaviorDefiningInvocations createOneTimeMatchingBehaviorDefiningInvocations() {
        return new BehaviorDefiningInvocations(true);
    }

    protected BehaviorDefiningInvocations createAlwaysMatchingBehaviorDefiningInvocations() {
        return new BehaviorDefiningInvocations(false);
    }

    protected MatchingInvocationHandler createAssertInvokedVerifyingMatchingInvocationHandler() {
        return new AssertInvokedVerifyingMatchingInvocationHandler(MockObject.getCurrentScenario(), this);
    }

    protected MatchingInvocationHandler createAssertInvokedInSequenceVerifyingMatchingInvocationHandler() {
        return new AssertInvokedInSequenceVerifyingMatchingInvocationHandler(MockObject.getCurrentScenario(), this);
    }

    protected MatchingInvocationHandler createAssertNotInvokedVerifyingMatchingInvocationHandler() {
        return new AssertNotInvokedVerifyingMatchingInvocationHandler(MockObject.getCurrentScenario(), this);
    }

    protected Scenario createScenario(Object testObject) {
        return new Scenario(testObject);
    }

    protected MatchingInvocationBuilder createMatchingInvocationBuilder() {
        return new MatchingInvocationBuilder();
    }
}

