/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.mock.report.impl;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.unitils.mock.core.ObservedInvocation;
import org.unitils.mock.report.impl.ProxyInvocationsReport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObservedInvocationsReport
extends ProxyInvocationsReport {
    public ObservedInvocationsReport(Object testedObject) {
        super(testedObject);
    }

    public String createReport(List<ObservedInvocation> observedInvocations) {
        StringBuilder result = new StringBuilder();
        ArrayList<ProxyInvocationsReport.FormattedObject> currentLargeObjects = new ArrayList<ProxyInvocationsReport.FormattedObject>();
        IdentityHashMap<Object, ProxyInvocationsReport.FormattedObject> allLargeObjects = new IdentityHashMap<Object, ProxyInvocationsReport.FormattedObject>();
        HashMap largeObjectNameIndexes = new HashMap();
        int invocationIndex = 0;
        for (ObservedInvocation observedInvocation : observedInvocations) {
            result.append(this.formatInvocationIndex(++invocationIndex, observedInvocations.size()));
            result.append(this.formatObservedInvocation(observedInvocation, currentLargeObjects, allLargeObjects, largeObjectNameIndexes));
            result.append(this.formatInvokedAt(observedInvocation));
            result.append("\n");
        }
        return result.toString();
    }

    protected String formatObservedInvocation(ObservedInvocation observedInvocation, List<ProxyInvocationsReport.FormattedObject> currentLargeObjects, Map<Object, ProxyInvocationsReport.FormattedObject> allLargeObjects, Map<Class<?>, Integer> largeObjectNameIndexes) {
        StringBuilder result = new StringBuilder();
        Method method = observedInvocation.getMethod();
        result.append(observedInvocation.getMockName());
        result.append('.');
        result.append(method.getName());
        result.append('(');
        Class<?>[] argumentTypes = method.getParameterTypes();
        if (argumentTypes.length > 0) {
            Iterator<Object> arguments = observedInvocation.getArguments().iterator();
            Iterator<Object> argumentsAtInvocationTime = observedInvocation.getArgumentsAtInvocationTime().iterator();
            for (Class<?> argumentType : argumentTypes) {
                result.append(this.formatValue(argumentsAtInvocationTime.next(), arguments.next(), argumentType, currentLargeObjects, allLargeObjects, largeObjectNameIndexes));
                result.append(", ");
            }
            result.setLength(result.length() - 2);
        }
        result.append(")");
        Class<?> resultType = method.getReturnType();
        if (!Void.TYPE.equals(resultType)) {
            result.append(" -> ");
            Object resultValue = observedInvocation.getResult();
            Object resultAtInvocationTime = observedInvocation.getResultAtInvocationTime();
            result.append(this.formatValue(resultAtInvocationTime, resultValue, resultType, currentLargeObjects, allLargeObjects, largeObjectNameIndexes));
        }
        return result.toString();
    }
}

