/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.orm.hibernate.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Configuration;
import org.springframework.orm.hibernate3.LocalSessionFactoryBean;
import org.unitils.core.UnitilsException;
import org.unitils.util.ReflectionUtils;

public class UnitilsLocalSessionFactoryBean
extends LocalSessionFactoryBean {
    private Object testObject;
    private Method customConfigMethod;

    public void setTestObject(Object testObject) {
        this.testObject = testObject;
    }

    public void setCustomConfigMethod(Method customConfigMethod) {
        this.customConfigMethod = customConfigMethod;
    }

    protected void postProcessConfiguration(Configuration config) throws HibernateException {
        if (this.customConfigMethod != null) {
            try {
                ReflectionUtils.invokeMethod((Object)this.testObject, (Method)this.customConfigMethod, (Object[])new Object[]{config});
            }
            catch (InvocationTargetException e) {
                throw new UnitilsException("Error while invoking custom config method", e.getCause());
            }
        }
    }
}

