/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.orm.jpa.util.spring;

import java.util.Collection;
import javax.persistence.EntityManagerFactory;
import org.springframework.orm.jpa.AbstractEntityManagerFactoryBean;
import org.unitils.core.Unitils;
import org.unitils.orm.common.spring.OrmSpringSupport;
import org.unitils.orm.common.util.ConfiguredOrmPersistenceUnit;
import org.unitils.orm.jpa.JpaModule;
import org.unitils.spring.SpringModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaSpringSupport
implements OrmSpringSupport<EntityManagerFactory, Object> {
    @Override
    public boolean isPersistenceUnitConfiguredInSpring(Object testObject) {
        return this.getEntityManagerFactoryBean(testObject) != null;
    }

    @Override
    public ConfiguredOrmPersistenceUnit<EntityManagerFactory, Object> getConfiguredPersistenceUnit(Object testObject) {
        AbstractEntityManagerFactoryBean factoryBean = this.getEntityManagerFactoryBean(testObject);
        EntityManagerFactory entityManagerFactory = factoryBean.getObject();
        Object providerSpecificConfigurationObject = this.getJpaModule().getJpaProviderSupport().getProviderSpecificConfigurationObject(factoryBean.getPersistenceProvider());
        return new ConfiguredOrmPersistenceUnit<EntityManagerFactory, Object>(entityManagerFactory, providerSpecificConfigurationObject);
    }

    protected AbstractEntityManagerFactoryBean getEntityManagerFactoryBean(Object testObject) {
        if (!this.getSpringModule().isApplicationContextConfiguredFor(testObject)) {
            return null;
        }
        Collection entityManagerFactoryBeans = this.getSpringModule().getApplicationContext(testObject).getBeansOfType(AbstractEntityManagerFactoryBean.class).values();
        if (entityManagerFactoryBeans.size() == 0) {
            return null;
        }
        return (AbstractEntityManagerFactoryBean)entityManagerFactoryBeans.iterator().next();
    }

    protected SpringModule getSpringModule() {
        return (SpringModule)Unitils.getInstance().getModulesRepository().getModuleOfType(SpringModule.class);
    }

    protected JpaModule getJpaModule() {
        return (JpaModule)Unitils.getInstance().getModulesRepository().getModuleOfType(JpaModule.class);
    }
}

