/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.orm.hibernate.util;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import org.hibernate.Session;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;
import org.hibernate.tool.hbm2ddl.DatabaseMetadata;
import org.unitils.core.UnitilsException;

public class HibernateAssert {
    public static void assertMappingWithDatabaseConsistent(Configuration configuration, Session session, Dialect databaseDialect) {
        String[] script = HibernateAssert.generateDatabaseUpdateScript(configuration, session, databaseDialect);
        ArrayList<String> differences = new ArrayList<String>();
        for (String line : script) {
            if (line.indexOf("add constraint") != -1) continue;
            differences.add(line);
        }
        Assert.assertTrue((String)("Found mismatches between Java objects and database tables. Applying following DDL statements to the database should resolve the problem: \n" + HibernateAssert.formatErrorMessage(differences)), (boolean)differences.isEmpty());
    }

    private static String[] generateDatabaseUpdateScript(Configuration configuration, Session session, Dialect databaseDialect) {
        try {
            DatabaseMetadata dbm = new DatabaseMetadata(session.connection(), databaseDialect);
            return configuration.generateSchemaUpdateScript(databaseDialect, dbm);
        }
        catch (SQLException e) {
            throw new UnitilsException("Could not retrieve database metadata", (Throwable)e);
        }
    }

    private static String formatErrorMessage(List<String> messageParts) {
        StringBuffer message = new StringBuffer();
        for (String messagePart : messageParts) {
            message.append(messagePart);
            message.append(";\n");
        }
        return message.toString();
    }
}

