/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.orm.hibernate;

import java.lang.reflect.Method;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;
import org.springframework.orm.hibernate3.HibernateTransactionManager;
import org.springframework.orm.hibernate3.SessionFactoryUtils;
import org.springframework.orm.hibernate3.SessionHolder;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.unitils.core.Module;
import org.unitils.core.TestListener;
import org.unitils.core.UnitilsException;
import org.unitils.database.transaction.impl.UnitilsTransactionManagementConfiguration;
import org.unitils.database.util.Flushable;
import org.unitils.orm.common.OrmModule;
import org.unitils.orm.common.util.ConfiguredOrmPersistenceUnit;
import org.unitils.orm.common.util.OrmConfig;
import org.unitils.orm.common.util.OrmPersistenceUnitLoader;
import org.unitils.orm.hibernate.annotation.HibernateSessionFactory;
import org.unitils.orm.hibernate.util.HibernateAnnotationConfigLoader;
import org.unitils.orm.hibernate.util.HibernateAssert;
import org.unitils.orm.hibernate.util.HibernateSessionFactoryLoader;
import org.unitils.util.PropertyUtils;
import org.unitils.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateModule
extends OrmModule<SessionFactory, Session, Configuration, HibernateSessionFactory, OrmConfig, HibernateAnnotationConfigLoader>
implements Module,
Flushable {
    public static final String PROPKEY_CONFIGURATION_CLASS_NAME = "HibernateModule.configuration.implClassName";
    private static Log logger = LogFactory.getLog(HibernateModule.class);
    private Class<? extends Configuration> configurationObjectClass;

    @Override
    public void init(Properties configuration) {
        super.init(configuration);
        String configurationImplClassName = PropertyUtils.getString((String)PROPKEY_CONFIGURATION_CLASS_NAME, (Properties)configuration);
        this.configurationObjectClass = ReflectionUtils.getClassWithName((String)configurationImplClassName);
    }

    @Override
    public void afterInit() {
        super.afterInit();
    }

    public void registerTransactionManagementConfiguration() {
        this.getDatabaseModule().registerTransactionManagementConfiguration(new UnitilsTransactionManagementConfiguration(){

            public boolean isApplicableFor(Object testObject) {
                return HibernateModule.this.isPersistenceUnitConfiguredFor(testObject);
            }

            public PlatformTransactionManager getSpringPlatformTransactionManager(Object testObject) {
                SessionFactory sessionFactory = (SessionFactory)HibernateModule.this.getPersistenceUnit(testObject);
                HibernateTransactionManager hibernateTransactionManager = new HibernateTransactionManager(sessionFactory);
                hibernateTransactionManager.setDataSource(HibernateModule.this.getDataSource());
                return hibernateTransactionManager;
            }

            public boolean isTransactionalResourceAvailable(Object testObject) {
                return HibernateModule.this.getDatabaseModule().getWrapper(HibernateModule.this.databaseName).isDataSourceLoaded();
            }

            public Integer getPreference() {
                return 10;
            }
        });
    }

    @Override
    protected HibernateAnnotationConfigLoader createOrmConfigLoader() {
        return new HibernateAnnotationConfigLoader();
    }

    @Override
    protected Class<HibernateSessionFactory> getPersistenceUnitConfigAnnotationClass() {
        return HibernateSessionFactory.class;
    }

    @Override
    protected Class<SessionFactory> getPersistenceUnitClass() {
        return SessionFactory.class;
    }

    @Override
    protected OrmPersistenceUnitLoader<SessionFactory, Configuration, OrmConfig> createOrmPersistenceUnitLoader() {
        return new HibernateSessionFactoryLoader(this.databaseName);
    }

    @Override
    protected String getOrmSpringSupportImplClassName() {
        return "org.unitils.orm.hibernate.util.HibernateSpringSupport";
    }

    @Override
    protected Session doGetPersistenceContext(Object testObject) {
        return SessionFactoryUtils.getSession((SessionFactory)((SessionFactory)this.getPersistenceUnit(testObject)), (boolean)true);
    }

    @Override
    protected Session doGetActivePersistenceContext(Object testObject) {
        SessionHolder sessionHolder = (SessionHolder)TransactionSynchronizationManager.getResource(this.getPersistenceUnit(testObject));
        if (sessionHolder != null && sessionHolder.getSession() != null && sessionHolder.getSession().isOpen()) {
            return sessionHolder.getSession();
        }
        return null;
    }

    @Override
    protected void flushOrmPersistenceContext(Session activeSession) {
        logger.info((Object)("Flushing session " + activeSession));
        activeSession.flush();
    }

    public void assertMappingWithDatabaseConsistent(Object testObject) {
        ConfiguredOrmPersistenceUnit configuredPersistenceUnit = this.getConfiguredPersistenceUnit(testObject);
        Configuration configuration = (Configuration)configuredPersistenceUnit.getOrmConfigurationObject();
        Session session = (Session)this.getPersistenceContext(testObject);
        Dialect databaseDialect = this.getDatabaseDialect(configuration);
        HibernateAssert.assertMappingWithDatabaseConsistent(configuration, session, databaseDialect);
    }

    public Class<? extends Configuration> getConfigurationObjectClass() {
        return this.configurationObjectClass;
    }

    protected Dialect getDatabaseDialect(Configuration configuration) {
        String dialectClassName = configuration.getProperty("hibernate.dialect");
        if (StringUtils.isEmpty((String)dialectClassName)) {
            throw new UnitilsException("Property hibernate.dialect not specified");
        }
        try {
            return (Dialect)Class.forName(dialectClassName).newInstance();
        }
        catch (Exception e) {
            throw new UnitilsException("Could not instantiate dialect class " + dialectClassName, (Throwable)e);
        }
    }

    protected DataSource getDataSource() {
        return this.getDatabaseModule().getWrapper(this.databaseName).getDataSourceAndActivateTransactionIfNeeded();
    }

    public TestListener getTestListener() {
        return new HibernateTestListener();
    }

    protected class HibernateTestListener
    extends OrmModule.OrmTestListener {
        protected HibernateTestListener() {
        }

        public void beforeTestMethod(Object testObject, Method testMethod) {
            HibernateModule.this.databaseName = HibernateModule.this.getDatabaseName(testObject, testMethod);
            HibernateModule.this.registerTransactionManagementConfiguration();
            super.beforeTestMethod(testObject, testMethod);
        }
    }
}

