/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.orm.jpa;

import java.lang.reflect.Method;
import java.util.Properties;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceUnit;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.orm.jpa.AbstractEntityManagerFactoryBean;
import org.springframework.orm.jpa.EntityManagerFactoryUtils;
import org.springframework.orm.jpa.EntityManagerHolder;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.unitils.core.TestListener;
import org.unitils.core.util.ConfigUtils;
import org.unitils.database.transaction.impl.UnitilsTransactionManagementConfiguration;
import org.unitils.orm.common.OrmModule;
import org.unitils.orm.common.util.OrmPersistenceUnitLoader;
import org.unitils.orm.jpa.annotation.JpaEntityManagerFactory;
import org.unitils.orm.jpa.util.JpaAnnotationConfigLoader;
import org.unitils.orm.jpa.util.JpaConfig;
import org.unitils.orm.jpa.util.JpaEntityManagerFactoryLoader;
import org.unitils.orm.jpa.util.JpaProviderSupport;
import org.unitils.util.AnnotationUtils;
import org.unitils.util.PropertyUtils;
import org.unitils.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaModule
extends OrmModule<EntityManagerFactory, EntityManager, Object, JpaEntityManagerFactory, JpaConfig, JpaAnnotationConfigLoader> {
    public static final String PROPKEY_PERSISTENCE_PROVIDER = "jpa.persistenceProvider";
    private static Log logger = LogFactory.getLog(JpaModule.class);
    protected JpaProviderSupport jpaProviderSupport;

    public JpaModule() {
        AbstractEntityManagerFactoryBean.class.getName();
    }

    @Override
    public void init(Properties configuration) {
        super.init(configuration);
        String persistenceProviderImplClassName = PropertyUtils.getString((String)PROPKEY_PERSISTENCE_PROVIDER, (Properties)configuration);
        this.jpaProviderSupport = (JpaProviderSupport)ConfigUtils.getInstanceOf(JpaProviderSupport.class, (Properties)configuration, (String[])new String[]{persistenceProviderImplClassName});
    }

    @Override
    public void afterInit() {
        super.afterInit();
    }

    public void registerTransactionManagementConfiguration() {
        this.getDatabaseModule().registerTransactionManagementConfiguration(new UnitilsTransactionManagementConfiguration(){

            public boolean isApplicableFor(Object testObject) {
                return JpaModule.this.isPersistenceUnitConfiguredFor(testObject);
            }

            public PlatformTransactionManager getSpringPlatformTransactionManager(Object testObject) {
                EntityManagerFactory entityManagerFactory = (EntityManagerFactory)JpaModule.this.getPersistenceUnit(testObject);
                JpaTransactionManager jpaTransactionManager = new JpaTransactionManager(entityManagerFactory);
                jpaTransactionManager.setDataSource(JpaModule.this.getDataSource());
                jpaTransactionManager.setJpaDialect(JpaModule.this.jpaProviderSupport.getSpringJpaVendorAdaptor().getJpaDialect());
                return jpaTransactionManager;
            }

            public boolean isTransactionalResourceAvailable(Object testObject) {
                return JpaModule.this.getDatabaseModule().getWrapper(JpaModule.this.databaseName).isDataSourceLoaded();
            }

            public Integer getPreference() {
                return 10;
            }
        });
    }

    @Override
    protected JpaAnnotationConfigLoader createOrmConfigLoader() {
        return new JpaAnnotationConfigLoader();
    }

    @Override
    protected Class<JpaEntityManagerFactory> getPersistenceUnitConfigAnnotationClass() {
        return JpaEntityManagerFactory.class;
    }

    @Override
    protected Class<EntityManagerFactory> getPersistenceUnitClass() {
        return EntityManagerFactory.class;
    }

    @Override
    protected OrmPersistenceUnitLoader<EntityManagerFactory, Object, JpaConfig> createOrmPersistenceUnitLoader() {
        return new JpaEntityManagerFactoryLoader(this.databaseName);
    }

    @Override
    protected String getOrmSpringSupportImplClassName() {
        return "org.unitils.orm.jpa.util.spring.JpaSpringSupport";
    }

    @Override
    protected EntityManager doGetPersistenceContext(Object testObject) {
        return EntityManagerFactoryUtils.getTransactionalEntityManager((EntityManagerFactory)((EntityManagerFactory)this.getPersistenceUnit(testObject)));
    }

    @Override
    protected EntityManager doGetActivePersistenceContext(Object testObject) {
        EntityManagerHolder entityManagerHolder = (EntityManagerHolder)TransactionSynchronizationManager.getResource(this.getPersistenceUnit(testObject));
        if (entityManagerHolder != null && entityManagerHolder.getEntityManager() != null && entityManagerHolder.getEntityManager().isOpen()) {
            return entityManagerHolder.getEntityManager();
        }
        return null;
    }

    @Override
    protected void flushOrmPersistenceContext(EntityManager activeEntityManager) {
        logger.info((Object)("Flushing entity manager " + activeEntityManager));
        activeEntityManager.flush();
    }

    public void assertMappingWithDatabaseConsistent(Object testObject) {
        this.jpaProviderSupport.assertMappingWithDatabaseConsistent(((EntityManagerFactory)this.getPersistenceUnit(testObject)).createEntityManager(), this.getConfiguredPersistenceUnit(testObject).getOrmConfigurationObject());
    }

    public void injectJpaResourcesIntoTestObject(Object testObject) {
        if (!this.isPersistenceUnitConfiguredFor(testObject)) {
            return;
        }
        this.injectJpaResourcesInto(testObject, testObject);
    }

    public void injectJpaResourcesInto(Object testObject, Object target) {
        this.injectEntityManagerFactory(testObject, target);
        this.injectEntityManager(testObject, target);
    }

    public void injectEntityManagerFactory(Object testObject, Object target) {
        Set fields = AnnotationUtils.getFieldsAnnotatedWith(target.getClass(), PersistenceUnit.class);
        Set methods = AnnotationUtils.getMethodsAnnotatedWith(target.getClass(), PersistenceUnit.class);
        if (fields.isEmpty() && methods.isEmpty()) {
            return;
        }
        EntityManagerFactory entityManagerFactory = (EntityManagerFactory)this.getPersistenceUnit(testObject);
        ReflectionUtils.setFieldAndSetterValue((Object)target, (Set)fields, (Set)methods, (Object)entityManagerFactory);
    }

    public void injectEntityManager(Object testObject, Object target) {
        Set fields = AnnotationUtils.getFieldsAnnotatedWith(target.getClass(), PersistenceContext.class);
        Set methods = AnnotationUtils.getMethodsAnnotatedWith(target.getClass(), PersistenceContext.class);
        if (fields.isEmpty() && methods.isEmpty()) {
            return;
        }
        EntityManager entityManager = (EntityManager)this.getPersistenceContext(testObject);
        ReflectionUtils.setFieldAndSetterValue((Object)target, (Set)fields, (Set)methods, (Object)entityManager);
    }

    protected DataSource getDataSource() {
        return this.getDatabaseModule().getWrapper(this.databaseName).getDataSourceAndActivateTransactionIfNeeded();
    }

    public JpaProviderSupport getJpaProviderSupport() {
        return this.jpaProviderSupport;
    }

    public TestListener getTestListener() {
        return new JpaTestListener();
    }

    protected class JpaTestListener
    extends OrmModule.OrmTestListener {
        protected JpaTestListener() {
        }

        public void beforeTestSetUp(Object testObject, Method testMethod) {
            JpaModule.this.getDatabaseName(testObject, testMethod);
            JpaModule.this.registerTransactionManagementConfiguration();
            JpaModule.this.injectJpaResourcesIntoTestObject(testObject);
        }
    }
}

