/*
 * Decompiled with CFR 0.152.
 */
package org.unitils;

import java.util.Iterator;
import java.util.List;
import junit.framework.Assert;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.unitils.TestExecutor;
import org.unitils.TracingTestListener;
import org.unitils.UnitilsJUnit3TestBase;
import org.unitils.UnitilsJUnit4TestBase;
import org.unitils.core.TestListener;
import org.unitils.core.Unitils;
import org.unitils.inject.util.InjectionUtils;
import org.unitils.spring.SpringUnitilsJUnit38TestBase;
import org.unitils.spring.SpringUnitilsJUnit4TestBase;

public abstract class UnitilsInvocationTestBase {
    private static TestListener originalTestListener;
    protected TracingTestListener tracingTestListener;
    private Iterator<TracingTestListener.Call> callListIterator;
    protected TracingTestListener.TestFramework testFramework;
    protected TestExecutor testExecutor;

    public UnitilsInvocationTestBase(TracingTestListener.TestFramework testFramework, TestExecutor testExecutor) {
        this.testFramework = testFramework;
        this.testExecutor = testExecutor;
    }

    @BeforeClass
    public static void storeOriginalTestListener() {
        originalTestListener = Unitils.getInstance().getTestListener();
    }

    @AfterClass
    public static void restoreOrginalTestListener() {
        InjectionUtils.injectInto((Object)originalTestListener, (Object)Unitils.getInstance(), (String)"testListener");
    }

    @Before
    public void init() throws Exception {
        this.tracingTestListener = new TracingTestListener(originalTestListener);
        UnitilsJUnit3TestBase.setTracingTestListener(this.tracingTestListener);
        SpringUnitilsJUnit38TestBase.setTracingTestListener(this.tracingTestListener);
        UnitilsJUnit4TestBase.setTracingTestListener(this.tracingTestListener);
        SpringUnitilsJUnit4TestBase.setTracingTestListener(this.tracingTestListener);
        InjectionUtils.injectInto((Object)((Object)this.tracingTestListener), (Object)Unitils.getInstance(), (String)"testListener");
    }

    @After
    public void cleanUp() throws Exception {
        UnitilsJUnit3TestBase.setTracingTestListener(null);
        SpringUnitilsJUnit38TestBase.setTracingTestListener(null);
        UnitilsJUnit4TestBase.setTracingTestListener(null);
        SpringUnitilsJUnit4TestBase.setTracingTestListener(null);
    }

    public void assertInvocationOrder(Class<?> testClass1, Class<?> testClass2) throws Exception {
        this.assertInvocation(TracingTestListener.ListenerInvocation.LISTENER_BEFORE_CLASS, testClass1, new TracingTestListener.TestFramework[0]);
        this.assertInvocation(TracingTestListener.ListenerInvocation.LISTENER_AFTER_CREATE_TEST_OBJECT, testClass1, TracingTestListener.TestFramework.TESTNG);
        this.assertInvocation(TracingTestListener.TestInvocation.TEST_BEFORE_CLASS, testClass1, TracingTestListener.TestFramework.JUNIT4, TracingTestListener.TestFramework.TESTNG);
        this.assertInvocation(TracingTestListener.ListenerInvocation.LISTENER_AFTER_CREATE_TEST_OBJECT, testClass1, TracingTestListener.TestFramework.JUNIT3, TracingTestListener.TestFramework.JUNIT4);
        this.assertInvocation(TracingTestListener.ListenerInvocation.LISTENER_BEFORE_TEST_SET_UP, testClass1, new TracingTestListener.TestFramework[0]);
        this.assertInvocation(TracingTestListener.TestInvocation.TEST_SET_UP, testClass1, new TracingTestListener.TestFramework[0]);
        this.assertInvocation(TracingTestListener.ListenerInvocation.LISTENER_BEFORE_TEST_METHOD, testClass1, new TracingTestListener.TestFramework[0]);
        this.assertInvocation(TracingTestListener.TestInvocation.TEST_METHOD, testClass1, new TracingTestListener.TestFramework[0]);
        this.assertInvocation(TracingTestListener.ListenerInvocation.LISTENER_AFTER_TEST_METHOD, testClass1, new TracingTestListener.TestFramework[0]);
        this.assertInvocation(TracingTestListener.TestInvocation.TEST_TEAR_DOWN, testClass1, new TracingTestListener.TestFramework[0]);
        this.assertInvocation(TracingTestListener.ListenerInvocation.LISTENER_AFTER_TEST_TEARDOWN, testClass1, new TracingTestListener.TestFramework[0]);
        this.assertInvocation(TracingTestListener.ListenerInvocation.LISTENER_AFTER_CREATE_TEST_OBJECT, testClass1, TracingTestListener.TestFramework.JUNIT3, TracingTestListener.TestFramework.JUNIT4);
        this.assertInvocation(TracingTestListener.ListenerInvocation.LISTENER_BEFORE_TEST_SET_UP, testClass1, new TracingTestListener.TestFramework[0]);
        this.assertInvocation(TracingTestListener.TestInvocation.TEST_SET_UP, testClass1, new TracingTestListener.TestFramework[0]);
        this.assertInvocation(TracingTestListener.ListenerInvocation.LISTENER_BEFORE_TEST_METHOD, testClass1, new TracingTestListener.TestFramework[0]);
        this.assertInvocation(TracingTestListener.TestInvocation.TEST_METHOD, testClass1, new TracingTestListener.TestFramework[0]);
        this.assertInvocation(TracingTestListener.ListenerInvocation.LISTENER_AFTER_TEST_METHOD, testClass1, new TracingTestListener.TestFramework[0]);
        this.assertInvocation(TracingTestListener.TestInvocation.TEST_TEAR_DOWN, testClass1, new TracingTestListener.TestFramework[0]);
        this.assertInvocation(TracingTestListener.ListenerInvocation.LISTENER_AFTER_TEST_TEARDOWN, testClass1, new TracingTestListener.TestFramework[0]);
        this.assertInvocation(TracingTestListener.TestInvocation.TEST_AFTER_CLASS, testClass1, TracingTestListener.TestFramework.JUNIT4, TracingTestListener.TestFramework.TESTNG);
        this.assertInvocation(TracingTestListener.ListenerInvocation.LISTENER_BEFORE_CLASS, testClass2, new TracingTestListener.TestFramework[0]);
        this.assertInvocation(TracingTestListener.ListenerInvocation.LISTENER_AFTER_CREATE_TEST_OBJECT, testClass2, TracingTestListener.TestFramework.TESTNG);
        this.assertInvocation(TracingTestListener.TestInvocation.TEST_BEFORE_CLASS, testClass2, TracingTestListener.TestFramework.JUNIT4, TracingTestListener.TestFramework.TESTNG);
        this.assertInvocation(TracingTestListener.ListenerInvocation.LISTENER_AFTER_CREATE_TEST_OBJECT, testClass2, TracingTestListener.TestFramework.JUNIT3, TracingTestListener.TestFramework.JUNIT4);
        this.assertInvocation(TracingTestListener.ListenerInvocation.LISTENER_BEFORE_TEST_SET_UP, testClass2, new TracingTestListener.TestFramework[0]);
        this.assertInvocation(TracingTestListener.TestInvocation.TEST_SET_UP, testClass2, new TracingTestListener.TestFramework[0]);
        this.assertInvocation(TracingTestListener.ListenerInvocation.LISTENER_BEFORE_TEST_METHOD, testClass2, new TracingTestListener.TestFramework[0]);
        this.assertInvocation(TracingTestListener.TestInvocation.TEST_METHOD, testClass2, new TracingTestListener.TestFramework[0]);
        this.assertInvocation(TracingTestListener.ListenerInvocation.LISTENER_AFTER_TEST_METHOD, testClass2, new TracingTestListener.TestFramework[0]);
        this.assertInvocation(TracingTestListener.TestInvocation.TEST_TEAR_DOWN, testClass2, new TracingTestListener.TestFramework[0]);
        this.assertInvocation(TracingTestListener.ListenerInvocation.LISTENER_AFTER_TEST_TEARDOWN, testClass2, new TracingTestListener.TestFramework[0]);
        this.assertInvocation(TracingTestListener.ListenerInvocation.LISTENER_AFTER_CREATE_TEST_OBJECT, testClass2, TracingTestListener.TestFramework.JUNIT3, TracingTestListener.TestFramework.JUNIT4);
        this.assertInvocation(TracingTestListener.ListenerInvocation.LISTENER_BEFORE_TEST_SET_UP, testClass2, new TracingTestListener.TestFramework[0]);
        this.assertInvocation(TracingTestListener.TestInvocation.TEST_SET_UP, testClass2, new TracingTestListener.TestFramework[0]);
        this.assertInvocation(TracingTestListener.ListenerInvocation.LISTENER_BEFORE_TEST_METHOD, testClass2, new TracingTestListener.TestFramework[0]);
        this.assertInvocation(TracingTestListener.TestInvocation.TEST_METHOD, testClass2, new TracingTestListener.TestFramework[0]);
        this.assertInvocation(TracingTestListener.ListenerInvocation.LISTENER_AFTER_TEST_METHOD, testClass2, new TracingTestListener.TestFramework[0]);
        this.assertInvocation(TracingTestListener.TestInvocation.TEST_TEAR_DOWN, testClass2, new TracingTestListener.TestFramework[0]);
        this.assertInvocation(TracingTestListener.ListenerInvocation.LISTENER_AFTER_TEST_TEARDOWN, testClass2, new TracingTestListener.TestFramework[0]);
        this.assertInvocation(TracingTestListener.TestInvocation.TEST_AFTER_CLASS, testClass2, TracingTestListener.TestFramework.JUNIT4, TracingTestListener.TestFramework.TESTNG);
        this.assertNoMoreInvocations();
        Assert.assertEquals((int)4, (int)this.testExecutor.getRunCount());
        Assert.assertEquals((int)0, (int)this.testExecutor.getFailureCount());
    }

    protected void assertInvocation(TracingTestListener.Invocation invocation, Class<?> testClass, TracingTestListener.TestFramework ... testFrameworks) {
        if (this.isApplicableFor(testFrameworks)) {
            if (!this.getCallListIterator().hasNext()) {
                Assert.fail((String)("No more invocations in calllist. Calllist:\n" + this.toString(this.tracingTestListener.getCallList())));
            }
            Assert.assertEquals((String)("Calllist:\n" + this.toString(this.tracingTestListener.getCallList())), (Object)new TracingTestListener.Call(invocation, testClass), (Object)this.getCallListIterator().next());
        }
    }

    protected void assertNoMoreInvocations() {
        Assert.assertFalse((String)("No more invocations expected, calllist:\n" + this.toString(this.tracingTestListener.getCallList())), (boolean)this.getCallListIterator().hasNext());
    }

    private Iterator<TracingTestListener.Call> getCallListIterator() {
        if (this.callListIterator == null) {
            this.callListIterator = this.tracingTestListener.getCallList().iterator();
        }
        return this.callListIterator;
    }

    protected boolean isApplicableFor(TracingTestListener.TestFramework[] testFrameworks) {
        if (testFrameworks.length == 0) {
            return true;
        }
        for (TracingTestListener.TestFramework framework : testFrameworks) {
            if (!framework.equals((Object)this.testFramework)) continue;
            return true;
        }
        return false;
    }

    private String toString(List<TracingTestListener.Call> callList) {
        StringBuffer result = new StringBuffer();
        for (TracingTestListener.Call call : callList) {
            result.append(call.toString()).append("\n");
        }
        return result.toString();
    }
}

