/*
 * Decompiled with CFR 0.152.
 */
package org.unitils;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import org.unitils.core.TestListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TracingTestListener
extends TestListener {
    private List<Call> callList = new ArrayList<Call>();
    private Invocation exceptionMethod;
    private boolean throwAssertionFailedError;
    private TestListener delegate;
    private Method currentTestMethod;
    private Throwable currentThrowable;

    public TracingTestListener(TestListener delegate) {
        this();
        this.delegate = delegate;
    }

    public TracingTestListener() {
    }

    public List<Call> getCallList() {
        return this.callList;
    }

    public String getCallListAsString() {
        StringBuffer result = new StringBuffer();
        for (Call call : this.callList) {
            result.append(call);
            result.append('\n');
        }
        return result.toString();
    }

    public void expectExceptionInMethod(Invocation exceptionMethod, boolean throwAssertionFailedError) {
        this.exceptionMethod = exceptionMethod;
        this.throwAssertionFailedError = throwAssertionFailedError;
    }

    public void registerTestInvocation(TestInvocation invocation, Class<?> testClass, String methodName) {
        this.callList.add(new Call(invocation, testClass, methodName));
        this.throwExceptionIfRequested(invocation);
    }

    public void registerListenerInvocation(ListenerInvocation listenerInvocation, Class<?> testClass, Object test, Method testMethod, Throwable throwable) {
        this.callList.add(new Call(listenerInvocation, testClass, testMethod == null ? null : testMethod.getName(), throwable));
    }

    public void beforeTestClass(Class<?> testClass) {
        this.registerListenerInvocation(ListenerInvocation.LISTENER_BEFORE_CLASS, testClass, null, null, null);
    }

    public void afterCreateTestObject(Object testObject) {
        this.registerListenerInvocation(ListenerInvocation.LISTENER_AFTER_CREATE_TEST_OBJECT, testObject.getClass(), testObject, null, null);
        this.delegate.afterCreateTestObject(testObject);
        this.throwExceptionIfRequested(ListenerInvocation.LISTENER_AFTER_CREATE_TEST_OBJECT);
    }

    public void beforeTestSetUp(Object testObject, Method testMethod) {
        this.currentTestMethod = testMethod;
        this.currentThrowable = null;
        this.registerListenerInvocation(ListenerInvocation.LISTENER_BEFORE_TEST_SET_UP, testObject.getClass(), testObject, testMethod, null);
        this.throwExceptionIfRequested(ListenerInvocation.LISTENER_BEFORE_TEST_SET_UP);
    }

    public void beforeTestMethod(Object testObject, Method testMethod) {
        Assert.assertEquals((Object)this.currentTestMethod, (Object)testMethod);
        this.registerListenerInvocation(ListenerInvocation.LISTENER_BEFORE_TEST_METHOD, testObject.getClass(), testObject, testMethod, null);
        this.throwExceptionIfRequested(ListenerInvocation.LISTENER_BEFORE_TEST_METHOD);
    }

    public void afterTestMethod(Object testObject, Method testMethod, Throwable throwable) {
        Assert.assertEquals((Object)this.currentTestMethod, (Object)testMethod);
        Assert.assertTrue((throwable == null || this.currentThrowable != null && this.currentThrowable.equals(throwable) ? 1 : 0) != 0);
        this.registerListenerInvocation(ListenerInvocation.LISTENER_AFTER_TEST_METHOD, testObject.getClass(), testObject, testMethod, throwable);
        this.throwExceptionIfRequested(ListenerInvocation.LISTENER_AFTER_TEST_METHOD);
    }

    public void afterTestTearDown(Object testObject, Method testMethod) {
        this.registerListenerInvocation(ListenerInvocation.LISTENER_AFTER_TEST_TEARDOWN, testObject.getClass(), testObject, testMethod, null);
        this.throwExceptionIfRequested(ListenerInvocation.LISTENER_AFTER_TEST_TEARDOWN);
    }

    public boolean shouldInvokeTestMethod(Object testObject, Method testMethod) {
        return this.delegate.shouldInvokeTestMethod(testObject, testMethod);
    }

    private void throwExceptionIfRequested(Invocation exceptionMethod) {
        if (this.exceptionMethod == null || !this.exceptionMethod.equals(exceptionMethod)) {
            return;
        }
        if (this.throwAssertionFailedError) {
            AssertionFailedError error = new AssertionFailedError(exceptionMethod.toString());
            this.currentThrowable = error;
            throw error;
        }
        RuntimeException exception = new RuntimeException(exceptionMethod.toString());
        this.currentThrowable = exception;
        throw exception;
    }

    public Throwable getCurrentThrowable() {
        return this.currentThrowable;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Call {
        private InvocationSource invocationSource;
        private Invocation invocation;
        private Class<?> testClass;
        private String testMethod;
        private Throwable throwable;

        public Call(Invocation invocation, Class<?> testClass) {
            this(invocation, testClass, null);
        }

        public Call(Invocation invocation, Class<?> testClass, String testMethod) {
            this(invocation, testClass, testMethod, null);
        }

        public Call(Invocation invocation, Class<?> testClass, String testMethod, Throwable throwable) {
            this.invocationSource = invocation instanceof TestInvocation ? InvocationSource.TEST : InvocationSource.UNITILS;
            this.invocation = invocation;
            this.testClass = testClass;
            this.testMethod = testMethod;
            this.throwable = throwable;
        }

        public Invocation getInvocation() {
            return this.invocation;
        }

        public Class<?> getTestClass() {
            return this.testClass;
        }

        public String getTestMethod() {
            return this.testMethod;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.invocation == null ? 0 : this.invocation.hashCode());
            result = 31 * result + (this.invocationSource == null ? 0 : this.invocationSource.hashCode());
            result = 31 * result + (this.testClass == null ? 0 : this.testClass.hashCode());
            result = 31 * result + (this.testMethod == null ? 0 : this.testMethod.hashCode());
            result = 31 * result + (this.throwable == null ? 0 : this.throwable.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Call other = (Call)obj;
            if (this.invocation == null ? other.invocation != null : !this.invocation.equals(other.invocation)) {
                return false;
            }
            if (this.invocationSource == null ? other.invocationSource != null : !this.invocationSource.equals((Object)other.invocationSource)) {
                return false;
            }
            return !(this.testClass == null ? other.testClass != null : !this.testClass.equals(other.testClass));
        }

        public String toString() {
            return (Object)((Object)this.invocationSource) + " " + this.invocation + " " + (this.testClass == null ? "" : this.testClass.getSimpleName()) + (this.testMethod == null ? "" : " " + this.testMethod) + (this.throwable == null ? "" : " " + this.throwable);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum InvocationSource {
        TEST,
        UNITILS;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TestInvocation implements Invocation
    {
        TEST_BEFORE_CLASS,
        TEST_SET_UP,
        TEST_METHOD,
        TEST_TEAR_DOWN,
        TEST_AFTER_CLASS;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ListenerInvocation implements Invocation
    {
        LISTENER_BEFORE_CLASS,
        LISTENER_AFTER_CREATE_TEST_OBJECT,
        LISTENER_BEFORE_TEST_SET_UP,
        LISTENER_BEFORE_TEST_METHOD,
        LISTENER_AFTER_TEST_METHOD,
        LISTENER_AFTER_TEST_TEARDOWN;

    }

    public static interface Invocation {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TestFramework {
        JUNIT3,
        JUNIT4,
        TESTNG;

    }
}

