/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitils.core.UnitilsException;
import org.unitils.thirdparty.org.apache.commons.io.IOUtils;
import org.unitils.util.PropertyUtils;

public class ConfigurationLoader {
    public static final String DEFAULT_PROPERTIES_FILE_NAME = "unitils-default.properties";
    public static final String PROPKEY_CUSTOM_CONFIGURATION = "unitils.configuration.customFileName";
    public static final String PROPKEY_LOCAL_CONFIGURATION = "unitils.configuration.localFileName";
    private static Log logger = LogFactory.getLog(ConfigurationLoader.class);

    public Properties loadConfiguration() {
        return this.loadConfiguration(null);
    }

    public Properties loadConfiguration(String customConfigurationFileName) {
        Properties customProperties;
        Properties properties = new Properties();
        Properties defaultProperties = this.loadPropertiesFileFromClasspath(DEFAULT_PROPERTIES_FILE_NAME);
        if (defaultProperties == null) {
            throw new UnitilsException("Configuration file: unitils-default.properties not found in classpath.");
        }
        properties.putAll((Map<?, ?>)defaultProperties);
        if (customConfigurationFileName == null) {
            customConfigurationFileName = PropertyUtils.getString(PROPKEY_CUSTOM_CONFIGURATION, properties);
        }
        if ((customProperties = this.loadPropertiesFileFromClasspath(customConfigurationFileName)) == null) {
            logger.warn((Object)("No custom configuration file " + customConfigurationFileName + " found."));
        } else {
            properties.putAll((Map<?, ?>)customProperties);
        }
        String localConfigurationFileName = PropertyUtils.getString(PROPKEY_LOCAL_CONFIGURATION, properties);
        Properties localProperties = this.loadPropertiesFileFromUserHome(localConfigurationFileName);
        if (localProperties == null) {
            localProperties = this.loadPropertiesFileFromClasspath(localConfigurationFileName);
        }
        if (localProperties == null) {
            logger.info((Object)("No custom configuration file " + customConfigurationFileName + " found."));
        } else {
            properties.putAll((Map<?, ?>)localProperties);
        }
        return properties;
    }

    protected Properties loadPropertiesFileFromClasspath(String propertiesFileName) {
        Properties properties;
        Properties properties2;
        InputStream inputStream;
        block5: {
            inputStream = null;
            properties2 = new Properties();
            inputStream = this.getClass().getClassLoader().getResourceAsStream(propertiesFileName);
            if (inputStream != null) break block5;
            Properties properties3 = null;
            IOUtils.closeQuietly(inputStream);
            return properties3;
        }
        try {
            properties2.load(inputStream);
            properties = properties2;
        }
        catch (Exception e) {
            try {
                throw new UnitilsException("Unable to load configuration file: " + propertiesFileName, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(inputStream);
        return properties;
    }

    protected Properties loadPropertiesFileFromUserHome(String propertiesFileName) {
        FileInputStream inputStream = null;
        try {
            Properties properties = new Properties();
            String userHomeDir = System.getProperty("user.home");
            File localPropertiesFile = new File(userHomeDir, propertiesFileName);
            if (!localPropertiesFile.exists()) {
                Properties properties2 = null;
                return properties2;
            }
            inputStream = new FileInputStream(localPropertiesFile);
            properties.load(inputStream);
            logger.info((Object)("Loaded configuration file " + propertiesFileName + " from user home"));
            Properties properties3 = properties;
            IOUtils.closeQuietly(inputStream);
            return properties3;
        }
        catch (Exception e) {
            throw new UnitilsException("Unable to load configuration file: " + propertiesFileName + " from user home", e);
        }
        finally {
            IOUtils.closeQuietly(inputStream);
        }
    }
}

