/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.core.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.IdentityHashMap;
import java.util.Map;
import org.objenesis.Objenesis;
import org.objenesis.ObjenesisStd;
import org.unitils.core.UnitilsException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloneUtil {
    private static Objenesis objenesis = new ObjenesisStd();

    public static <T> T createDeepClone(T object) {
        try {
            return (T)CloneUtil.cloneObject(object, new IdentityHashMap<Object, Object>());
        }
        catch (Throwable e) {
            throw new UnitilsException("Unexpected exception during cloning of " + object, e);
        }
    }

    protected static Object cloneObject(Object instanceToClone, Map<Object, Object> cloneCache) throws Throwable {
        if (instanceToClone == null) {
            return null;
        }
        Object clonedInstance = cloneCache.get(instanceToClone);
        if (clonedInstance != null) {
            return clonedInstance;
        }
        clonedInstance = CloneUtil.getValueIfImmutable(instanceToClone);
        if (clonedInstance != null) {
            return clonedInstance;
        }
        if (instanceToClone.getClass().isArray()) {
            clonedInstance = CloneUtil.cloneArray(instanceToClone, cloneCache);
        }
        if (clonedInstance == null) {
            clonedInstance = CloneUtil.createInstanceUsingClone(instanceToClone);
        }
        if (clonedInstance == null && (clonedInstance = CloneUtil.createInstanceUsingObjenesis(instanceToClone)) == null) {
            return instanceToClone;
        }
        cloneCache.put(instanceToClone, clonedInstance);
        CloneUtil.cloneFields(instanceToClone.getClass(), instanceToClone, clonedInstance, cloneCache);
        return clonedInstance;
    }

    protected static Object getValueIfImmutable(Object instanceToClone) {
        Class<?> clazz = instanceToClone.getClass();
        if (clazz.isPrimitive() || clazz.isEnum() || clazz.isAnnotation()) {
            return instanceToClone;
        }
        if (instanceToClone instanceof Number || instanceToClone instanceof String || instanceToClone instanceof Character || instanceToClone instanceof Boolean) {
            return instanceToClone;
        }
        return null;
    }

    protected static Object createInstanceUsingClone(Object instanceToClone) {
        if (!(instanceToClone instanceof Cloneable)) {
            return null;
        }
        try {
            Method cloneMethod = Object.class.getDeclaredMethod("clone", new Class[0]);
            cloneMethod.setAccessible(true);
            return cloneMethod.invoke(instanceToClone, new Object[0]);
        }
        catch (Throwable t) {
            return null;
        }
    }

    protected static Object createInstanceUsingObjenesis(Object instanceToClone) {
        try {
            return objenesis.newInstance(instanceToClone.getClass());
        }
        catch (Throwable t) {
            return null;
        }
    }

    protected static void cloneFields(Class<?> clazz, Object instanceToClone, Object clonedInstance, Map<Object, Object> cloneCache) throws Throwable {
        if (clazz == null || Object.class.equals(clazz)) {
            return;
        }
        AccessibleObject[] fields = clazz.getDeclaredFields();
        AccessibleObject.setAccessible(fields, true);
        for (AccessibleObject field : fields) {
            if (Modifier.isStatic(((Field)field).getModifiers())) continue;
            Object fieldValue = ((Field)field).get(instanceToClone);
            Object clonedFieldValue = CloneUtil.cloneObject(fieldValue, cloneCache);
            ((Field)field).set(clonedInstance, clonedFieldValue);
        }
        CloneUtil.cloneFields(clazz.getSuperclass(), instanceToClone, clonedInstance, cloneCache);
    }

    protected static Object cloneArray(Object arrayToClone, Map<Object, Object> cloneCache) throws Throwable {
        int lenght = Array.getLength(arrayToClone);
        Object clonedArray = Array.newInstance(arrayToClone.getClass().getComponentType(), lenght);
        for (int i = 0; i < lenght; ++i) {
            Object elementValue = Array.get(arrayToClone, i);
            Object clonedElementValue = CloneUtil.cloneObject(elementValue, cloneCache);
            Array.set(clonedArray, i, clonedElementValue);
        }
        return clonedArray;
    }
}

