/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.dbmaintainer.script.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Properties;
import org.unitils.core.UnitilsException;
import org.unitils.dbmaintainer.script.ScriptParser;
import org.unitils.dbmaintainer.script.StatementBuilder;
import org.unitils.dbmaintainer.script.parsingstate.ParsingState;
import org.unitils.dbmaintainer.script.parsingstate.impl.InBlockCommentParsingState;
import org.unitils.dbmaintainer.script.parsingstate.impl.InDoubleQuotesParsingState;
import org.unitils.dbmaintainer.script.parsingstate.impl.InLineCommentParsingState;
import org.unitils.dbmaintainer.script.parsingstate.impl.InSingleQuotesParsingState;
import org.unitils.dbmaintainer.script.parsingstate.impl.NormalParsingState;
import org.unitils.util.PropertyUtils;

public class DefaultScriptParser
implements ScriptParser {
    public static final String PROPKEY_BACKSLASH_ESCAPING_ENABLED = "org.unitils.dbmaintainer.script.ScriptParser.backSlashEscapingEnabled";
    protected ParsingState initialParsingState;
    protected ParsingState currentParsingState;
    protected int currentChar;
    protected Reader scriptReader;

    public void init(Properties configuration, Reader scriptReader) {
        boolean backSlashEscapingEnabled = PropertyUtils.getBoolean(PROPKEY_BACKSLASH_ESCAPING_ENABLED, configuration);
        this.currentParsingState = this.initialParsingState = this.createInitialParsingState(backSlashEscapingEnabled);
        this.scriptReader = new BufferedReader(scriptReader);
    }

    public String getNextStatement() {
        try {
            return this.getNextStatementImpl();
        }
        catch (IOException e) {
            throw new UnitilsException("Unable to parse next statement out of script.", e);
        }
    }

    protected String getNextStatementImpl() throws IOException {
        String finalStatement;
        this.currentChar = this.scriptReader.read();
        if (this.currentChar == -1) {
            return null;
        }
        char previousChar = '\u0000';
        this.currentParsingState = this.initialParsingState;
        StatementBuilder statementBuilder = this.createStatementBuilder();
        while (this.currentChar != -1) {
            if (statementBuilder.getLength() == 0 && this.currentChar <= 32) {
                this.currentChar = this.scriptReader.read();
                continue;
            }
            int nextCharInt = this.scriptReader.read();
            char nextChar = nextCharInt == -1 ? (char)'\u0000' : (char)nextCharInt;
            this.currentParsingState = this.currentParsingState.handleNextChar(previousChar, (char)this.currentChar, nextChar, statementBuilder);
            previousChar = (char)this.currentChar;
            this.currentChar = nextCharInt;
            if (this.currentParsingState != null) continue;
            String statement = statementBuilder.createStatement();
            previousChar = '\u0000';
            statementBuilder.clear();
            statementBuilder.setExecutable(false);
            this.currentParsingState = this.initialParsingState;
            if (statement == null) continue;
            return statement;
        }
        if (statementBuilder.isExecutable() && (finalStatement = statementBuilder.createStatement()) != null) {
            throw new UnitilsException("Last statement in script was not ended correctly. Each statement should end with one of " + Arrays.toString(statementBuilder.getTrailingSeparatorCharsToRemove()));
        }
        return null;
    }

    protected ParsingState createInitialParsingState(boolean backSlashEscapingEnabled) {
        NormalParsingState normalParsingState = this.createNormalParsingState();
        InLineCommentParsingState inLineCommentParsingState = this.createInLineCommentParsingState();
        InBlockCommentParsingState inBlockCommentParsingState = this.createInBlockCommentParsingState();
        InSingleQuotesParsingState inSingleQuotesParsingState = this.createInSingleQuotesParsingState();
        InDoubleQuotesParsingState inDoubleQuotesParsingState = this.createInDoubleQuotesParsingState();
        inLineCommentParsingState.init(normalParsingState);
        inBlockCommentParsingState.init(normalParsingState);
        inSingleQuotesParsingState.init(normalParsingState, backSlashEscapingEnabled);
        inDoubleQuotesParsingState.init(normalParsingState, backSlashEscapingEnabled);
        normalParsingState.init(inLineCommentParsingState, inBlockCommentParsingState, inSingleQuotesParsingState, inDoubleQuotesParsingState, backSlashEscapingEnabled);
        return normalParsingState;
    }

    protected StatementBuilder createStatementBuilder() {
        return new StatementBuilder();
    }

    protected NormalParsingState createNormalParsingState() {
        return new NormalParsingState();
    }

    protected InLineCommentParsingState createInLineCommentParsingState() {
        return new InLineCommentParsingState();
    }

    protected InBlockCommentParsingState createInBlockCommentParsingState() {
        return new InBlockCommentParsingState();
    }

    protected InSingleQuotesParsingState createInSingleQuotesParsingState() {
        return new InSingleQuotesParsingState();
    }

    protected InDoubleQuotesParsingState createInDoubleQuotesParsingState() {
        return new InDoubleQuotesParsingState();
    }
}

