/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.dbmaintainer.structure.impl;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitils.core.dbsupport.DbSupport;
import org.unitils.dbmaintainer.structure.ConstraintsDisabler;
import org.unitils.dbmaintainer.util.BaseDatabaseAccessor;

public class DefaultConstraintsDisabler
extends BaseDatabaseAccessor
implements ConstraintsDisabler {
    private static Log logger = LogFactory.getLog(DefaultConstraintsDisabler.class);

    public void disableConstraints() {
        for (DbSupport dbSupport : this.dbSupports) {
            logger.info((Object)("Disabling contraints in database schema " + dbSupport.getSchemaName()));
            this.disableReferentialConstraints(dbSupport);
            this.disableValueConstraints(dbSupport);
        }
    }

    protected void disableReferentialConstraints(DbSupport dbSupport) {
        try {
            dbSupport.disableReferentialConstraints();
        }
        catch (Throwable t) {
            logger.error((Object)"Unable to remove referential constraints.", t);
        }
    }

    protected void disableValueConstraints(DbSupport dbSupport) {
        try {
            dbSupport.disableValueConstraints();
        }
        catch (Throwable t) {
            logger.error((Object)"Unable to remove value constraints.", t);
        }
    }
}

