/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.dbunit.util;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.SortedSet;
import java.util.TreeSet;
import junit.framework.AssertionFailedError;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.FilteredDataSet;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableIterator;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.filter.ITableFilter;
import org.dbunit.dataset.filter.IncludeTableFilter;
import org.unitils.core.UnitilsException;
import org.unitils.dbunit.util.DbUnitDatabaseConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbUnitAssert {
    public static void assertDbContentAsExpected(IDataSet expectedDataSet, DbUnitDatabaseConnection dbUnitDatabaseConnection) {
        if (expectedDataSet == null) {
            return;
        }
        try {
            IDataSet actualDataSet = dbUnitDatabaseConnection.createDataSet();
            FilteredDataSet filteredActualDataSet = new FilteredDataSet((ITableFilter)new IncludeTableFilter(expectedDataSet.getTableNames()), actualDataSet);
            DbUnitAssert.assertEqualsDataSet(expectedDataSet, (IDataSet)filteredActualDataSet);
        }
        catch (SQLException e) {
            throw new UnitilsException("Unable to assert whether db content is as expected.", e);
        }
        catch (DataSetException e) {
            throw new UnitilsException("Unable to assert whether db content is as expected", e);
        }
    }

    public static void assertEqualsDataSet(IDataSet expectedDataSet, IDataSet actualDataSet) {
        try {
            HashMap<String, TreeSet<Integer>> result = new HashMap<String, TreeSet<Integer>>();
            ITableIterator tables = expectedDataSet.iterator();
            int currentIndex = 1;
            while (tables.next()) {
                ITable expectedTable = tables.getTable();
                String expectedTableName = expectedTable.getTableMetaData().getTableName();
                TreeSet<Integer> foundIndices = (TreeSet<Integer>)result.get(expectedTableName);
                if (foundIndices == null) {
                    foundIndices = new TreeSet<Integer>();
                    result.put(expectedTableName, foundIndices);
                }
                int rowCount = expectedTable.getRowCount();
                for (int i = 0; i < rowCount; ++i) {
                    if (!DbUnitAssert.containsRow(i, expectedTable, actualDataSet, foundIndices)) {
                        throw new AssertionFailedError(DbUnitAssert.formatErrorMessage(expectedTable, i, currentIndex));
                    }
                    ++currentIndex;
                }
            }
        }
        catch (DataSetException e) {
            throw new UnitilsException("Unable to assert whether data sets are equal.", e);
        }
    }

    private static boolean containsRow(int rowIndex, ITable expectedTable, IDataSet filteredActualDataSet, SortedSet<Integer> foundIndices) throws DataSetException {
        int actualRowIndex = 0;
        String expectedTableName = expectedTable.getTableMetaData().getTableName();
        ITableIterator actualTables = filteredActualDataSet.iterator();
        while (actualTables.next()) {
            ITable actualTable = actualTables.getTable();
            if (!expectedTableName.equalsIgnoreCase(actualTable.getTableMetaData().getTableName())) continue;
            Column[] columns = expectedTable.getTableMetaData().getColumns();
            int rowCount = actualTable.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                boolean equal = true;
                for (Column column : columns) {
                    String columnName = column.getColumnName();
                    Object expectedValue = expectedTable.getValue(rowIndex, columnName);
                    Object actualValue = actualTable.getValue(i, columnName);
                    String expectedValueString = DataType.asString((Object)expectedValue);
                    String actualValueString = DataType.asString((Object)actualValue);
                    if (expectedValueString == null && actualValueString == null || expectedValueString != null && expectedValueString.equals(actualValueString)) continue;
                    equal = false;
                    break;
                }
                if (equal && foundIndices.add(i)) {
                    return true;
                }
                ++actualRowIndex;
            }
        }
        return false;
    }

    private static String formatErrorMessage(ITable table, int rowIndex, int dataSetIndex) throws DataSetException {
        Column[] columns;
        StringBuffer message = new StringBuffer("Difference found in expected data set at line " + dataSetIndex);
        ITableMetaData tableMetaData = table.getTableMetaData();
        message.append(", Table: " + tableMetaData.getTableName() + ", values: ");
        for (Column column : columns = tableMetaData.getColumns()) {
            String columnName = column.getColumnName();
            Object expectedValue = table.getValue(rowIndex, columnName);
            message.append("\n   " + columnName + " = " + DataType.asString((Object)expectedValue));
        }
        return message.toString();
    }
}

