/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.mock.argumentmatcher;

import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.BasicValue;
import org.objectweb.asm.tree.analysis.Interpreter;
import org.objectweb.asm.tree.analysis.Value;
import org.unitils.core.UnitilsException;
import org.unitils.mock.annotation.ArgumentMatcher;
import org.unitils.mock.annotation.MatchStatement;
import org.unitils.mock.proxy.ProxyInvocation;
import org.unitils.thirdparty.org.apache.commons.io.IOUtils;
import org.unitils.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArgumentMatcherPositionFinder {
    public static List<Integer> getArgumentMatcherIndexes(ProxyInvocation proxyInvocation, int fromLineNr, int toLineNr) {
        Class testClass = ReflectionUtils.getClassWithName(proxyInvocation.getInvokedAt().getClassName());
        String testMethodName = proxyInvocation.getInvokedAt().getMethodName();
        Method method = proxyInvocation.getMethod();
        return ArgumentMatcherPositionFinder.getArgumentMatcherIndexes(testClass, testMethodName, method, fromLineNr, toLineNr);
    }

    public static List<Integer> getArgumentMatcherIndexes(Class<?> clazz, String methodName, Method invokedMethod, int fromLineNr, int toLineNr) {
        ClassNode restClassNode = ArgumentMatcherPositionFinder.readClass(clazz);
        List testMethodNodes = restClassNode.methods;
        for (MethodNode testMethodNode : testMethodNodes) {
            List<Integer> result;
            if (!methodName.equals(testMethodNode.name) || (result = ArgumentMatcherPositionFinder.findArgumentMatcherIndexes(restClassNode, testMethodNode, clazz, methodName, invokedMethod, fromLineNr, toLineNr)) == null) continue;
            return result;
        }
        throw new UnitilsException("Unable to find indexes of argument matcher. Method not found: " + methodName);
    }

    protected static ClassNode readClass(Class<?> clazz) {
        ClassNode classNode;
        InputStream inputStream = null;
        try {
            inputStream = clazz.getClassLoader().getResourceAsStream(clazz.getName().replace('.', '/') + ".class");
            ClassReader classReader = new ClassReader(inputStream);
            ClassNode classNode2 = new ClassNode();
            classReader.accept((ClassVisitor)classNode2, 0);
            classNode = classNode2;
        }
        catch (Exception e) {
            try {
                throw new UnitilsException("Unable to read class file for " + clazz, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(inputStream);
        return classNode;
    }

    protected static List<Integer> findArgumentMatcherIndexes(ClassNode classNode, MethodNode methodNode, Class<?> interpretedClass, String interpretedMethodName, Method invokedMethod, int fromLineNr, int toLineNr) {
        String invokedMethodName = invokedMethod.getName();
        String invokedMethodDescriptor = Type.getMethodDescriptor((Method)invokedMethod);
        try {
            MethodInterpreter methodInterpreter = new MethodInterpreter(interpretedClass, interpretedMethodName, invokedMethodName, invokedMethodDescriptor, fromLineNr, toLineNr);
            MethodAnalyzer analyzer = new MethodAnalyzer(methodNode, methodInterpreter);
            analyzer.analyze(classNode.name, methodNode);
            return methodInterpreter.getResultArgumentMatcherIndexes();
        }
        catch (AnalyzerException e) {
            if (e.getCause() instanceof UnitilsException) {
                throw (UnitilsException)e.getCause();
            }
            throw new UnitilsException("Unable to find argument matchers for method invocation. Method name: " + invokedMethodName + ", method description; " + invokedMethodDescriptor + ", line nr; " + fromLineNr, e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class MethodInterpreter
    implements Interpreter {
        protected static final Value REGULAR_VALUE = BasicValue.UNINITIALIZED_VALUE;
        protected static final Value ARGUMENT_MATCHER = BasicValue.REFERENCE_VALUE;
        protected Class<?> interpretedMethodClass;
        protected String interpretedMethodName;
        protected String invokedMethodName;
        protected String invokedMethodDescriptor;
        protected int fromLineNr;
        protected int toLineNr;
        protected int currentLineNr = 0;
        protected boolean currentlyInMatchStatement = false;
        protected boolean matchStatementFound = false;
        protected List<Integer> resultArgumentMatcherIndexes;

        public MethodInterpreter(Class<?> interpretedMethodClass, String interpretedMethodName, String invokedMethodName, String invokedMethodDescriptor, int fromLineNr, int toLineNr) {
            this.interpretedMethodClass = interpretedMethodClass;
            this.interpretedMethodName = interpretedMethodName;
            this.invokedMethodName = invokedMethodName;
            this.invokedMethodDescriptor = invokedMethodDescriptor;
            this.fromLineNr = fromLineNr;
            this.toLineNr = toLineNr;
        }

        public List<Integer> getResultArgumentMatcherIndexes() {
            return this.resultArgumentMatcherIndexes;
        }

        public void setCurrentLineNr(int currentLineNr) {
            this.currentLineNr = currentLineNr;
        }

        public Value newValue(Type type) {
            return REGULAR_VALUE;
        }

        public Value newOperation(AbstractInsnNode instructionNode) throws AnalyzerException {
            return REGULAR_VALUE;
        }

        public Value copyOperation(AbstractInsnNode instructionNode, Value value) throws AnalyzerException {
            return value;
        }

        public Value unaryOperation(AbstractInsnNode instructionNode, Value value) throws AnalyzerException {
            return value;
        }

        public Value binaryOperation(AbstractInsnNode instructionNode, Value value1, Value value2) throws AnalyzerException {
            return REGULAR_VALUE;
        }

        public Value ternaryOperation(AbstractInsnNode instructionNode, Value value1, Value value2, Value value3) throws AnalyzerException {
            return REGULAR_VALUE;
        }

        public Value naryOperation(AbstractInsnNode instructionNode, List values) throws AnalyzerException {
            if (this.currentLineNr < this.fromLineNr || this.currentLineNr > this.toLineNr) {
                return REGULAR_VALUE;
            }
            if (!(instructionNode instanceof MethodInsnNode)) {
                return REGULAR_VALUE;
            }
            MethodInsnNode methodInsnNode = (MethodInsnNode)instructionNode;
            if (this.invokedMethodName.equals(methodInsnNode.name) && this.invokedMethodDescriptor.equals(methodInsnNode.desc)) {
                if (!this.currentlyInMatchStatement) {
                    this.throwUnitilsException("Method invocation occurs more than once within the same clause");
                }
                this.currentlyInMatchStatement = false;
                boolean isStatic = methodInsnNode.getOpcode() == 184;
                this.resultArgumentMatcherIndexes = new ArrayList<Integer>();
                for (int i = 0; i < values.size(); ++i) {
                    if (values.get(i) != ARGUMENT_MATCHER) continue;
                    this.resultArgumentMatcherIndexes.add(isStatic ? i : i - 1);
                }
                return REGULAR_VALUE;
            }
            Method matcherMethod = this.getMethod(methodInsnNode);
            if (matcherMethod != null) {
                if (matcherMethod.getAnnotation(MatchStatement.class) != null) {
                    if (this.matchStatementFound) {
                        this.throwUnitilsException("Two match statements found on the same line. This is not supported");
                    }
                    this.matchStatementFound = true;
                    this.currentlyInMatchStatement = true;
                }
                if (matcherMethod.getAnnotation(ArgumentMatcher.class) != null) {
                    if (!this.currentlyInMatchStatement) {
                        this.throwUnitilsException("An argument matcher cannot be used outside the context of a match statement");
                    }
                    return ARGUMENT_MATCHER;
                }
            }
            for (Value value : values) {
                if (value != ARGUMENT_MATCHER) continue;
                this.throwUnitilsException("An argument matcher's return value cannot be used inside an expression");
            }
            return REGULAR_VALUE;
        }

        protected void throwUnitilsException(String errorMessage) {
            UnitilsException exception = new UnitilsException(errorMessage);
            exception.setStackTrace(new StackTraceElement[]{new StackTraceElement(this.interpretedMethodClass.getName(), this.interpretedMethodName, this.interpretedMethodClass.getName(), this.currentLineNr)});
            throw exception;
        }

        public Value merge(Value value1, Value value2) {
            return REGULAR_VALUE;
        }

        protected Method getMethod(MethodInsnNode methodNode) {
            Method[] methods;
            String internalClassName = methodNode.owner;
            String className = internalClassName.replace('/', '.');
            String methodName = methodNode.name;
            String methodDescriptor = methodNode.desc;
            Class clazz = ReflectionUtils.getClassWithName(className);
            for (Method method : methods = clazz.getMethods()) {
                if (!methodName.equals(method.getName()) || !methodDescriptor.equals(Type.getMethodDescriptor((Method)method))) continue;
                return method;
            }
            return null;
        }
    }

    protected static class MethodAnalyzer
    extends Analyzer {
        protected MethodNode methodNode;
        protected MethodInterpreter methodInterpreter;

        public MethodAnalyzer(MethodNode methodNode, MethodInterpreter methodInterpreter) {
            super((Interpreter)methodInterpreter);
            this.methodNode = methodNode;
            this.methodInterpreter = methodInterpreter;
        }

        protected void newControlFlowEdge(int instructionIndex, int nextInstructionIndex) {
            AbstractInsnNode insnNode = this.methodNode.instructions.get(instructionIndex);
            if (insnNode instanceof LineNumberNode) {
                LineNumberNode lineNumberNode = (LineNumberNode)insnNode;
                this.methodInterpreter.setCurrentLineNr(lineNumberNode.line);
            }
        }
    }
}

