/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.mock.core;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.unitils.core.util.CloneUtil;
import org.unitils.inject.util.ObjectToInjectHolder;
import org.unitils.mock.Mock;
import org.unitils.mock.PartialMock;
import org.unitils.mock.annotation.MatchStatement;
import org.unitils.mock.argumentmatcher.ArgumentMatcher;
import org.unitils.mock.argumentmatcher.ArgumentMatcherPositionFinder;
import org.unitils.mock.argumentmatcher.ArgumentMatcherRepository;
import org.unitils.mock.argumentmatcher.impl.DefaultArgumentMatcher;
import org.unitils.mock.core.BehaviorDefiningInvocation;
import org.unitils.mock.core.ObservedInvocation;
import org.unitils.mock.core.Scenario;
import org.unitils.mock.core.SyntaxMonitor;
import org.unitils.mock.mockbehavior.MockBehavior;
import org.unitils.mock.mockbehavior.impl.DefaultValueReturningMockBehavior;
import org.unitils.mock.mockbehavior.impl.ExceptionThrowingMockBehavior;
import org.unitils.mock.mockbehavior.impl.OriginalBehaviorInvokingMockBehavior;
import org.unitils.mock.mockbehavior.impl.ValueReturningMockBehavior;
import org.unitils.mock.proxy.ProxyInvocation;
import org.unitils.mock.proxy.ProxyInvocationHandler;
import org.unitils.mock.proxy.ProxyUtil;
import org.unitils.util.CallStackUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockObject<T>
implements Mock<T>,
PartialMock<T>,
ObjectToInjectHolder {
    protected String name;
    protected Class<T> mockedClass;
    protected boolean partialMock;
    protected List<BehaviorDefiningInvocation> oneTimeMatchingMockBehaviors = new ArrayList<BehaviorDefiningInvocation>();
    protected List<BehaviorDefiningInvocation> alwaysMatchingMockBehaviors = new ArrayList<BehaviorDefiningInvocation>();
    protected Scenario scenario;
    protected T instance;

    public MockObject(String name, Class<T> mockedClass, boolean partialMock, Scenario scenario) {
        this.name = name;
        this.mockedClass = mockedClass;
        this.partialMock = partialMock;
        this.scenario = scenario;
        this.instance = this.createInstance();
    }

    @Override
    public Object getObjectToInject() {
        return this.instance;
    }

    @Override
    public Class<?> getObjectToInjectType() {
        return this.mockedClass;
    }

    @Override
    public T getMock() {
        return this.instance;
    }

    public Class<?> getMockedClass() {
        return this.mockedClass;
    }

    @Override
    @MatchStatement
    public T returns(Object returnValue) {
        AlwaysMatchingMockBehaviorInvocationHandler proxyInvocationHandler = new AlwaysMatchingMockBehaviorInvocationHandler(new ValueReturningMockBehavior(returnValue));
        return this.startBehaviorDefinition(proxyInvocationHandler, "returns");
    }

    @Override
    @MatchStatement
    public T raises(Throwable exception) {
        AlwaysMatchingMockBehaviorInvocationHandler proxyInvocationHandler = new AlwaysMatchingMockBehaviorInvocationHandler(new ExceptionThrowingMockBehavior(exception));
        return this.startBehaviorDefinition(proxyInvocationHandler, "raises");
    }

    @Override
    @MatchStatement
    public T raises(Class<? extends Throwable> exceptionClass) {
        Throwable exception = ProxyUtil.createInstanceOfType(exceptionClass);
        exception.setStackTrace(this.getInvokedAt());
        AlwaysMatchingMockBehaviorInvocationHandler proxyInvocationHandler = new AlwaysMatchingMockBehaviorInvocationHandler(new ExceptionThrowingMockBehavior(exception));
        return this.startBehaviorDefinition(proxyInvocationHandler, "raises");
    }

    @Override
    @MatchStatement
    public T performs(MockBehavior mockBehavior) {
        AlwaysMatchingMockBehaviorInvocationHandler proxyInvocationHandler = new AlwaysMatchingMockBehaviorInvocationHandler(mockBehavior);
        return this.startBehaviorDefinition(proxyInvocationHandler, "performs");
    }

    @Override
    @MatchStatement
    public T onceReturns(Object returnValue) {
        OneTimeMatchingMockBehaviorInvocationHandler proxyInvocationHandler = new OneTimeMatchingMockBehaviorInvocationHandler(new ValueReturningMockBehavior(returnValue));
        return this.startBehaviorDefinition(proxyInvocationHandler, "onceReturns");
    }

    @Override
    @MatchStatement
    public T onceRaises(Throwable exception) {
        exception.setStackTrace(this.getInvokedAt());
        OneTimeMatchingMockBehaviorInvocationHandler proxyInvocationHandler = new OneTimeMatchingMockBehaviorInvocationHandler(new ExceptionThrowingMockBehavior(exception));
        return this.startBehaviorDefinition(proxyInvocationHandler, "onceRaises");
    }

    @Override
    @MatchStatement
    public T onceRaises(Class<? extends Throwable> exceptionClass) {
        Throwable exception = ProxyUtil.createInstanceOfType(exceptionClass);
        OneTimeMatchingMockBehaviorInvocationHandler proxyInvocationHandler = new OneTimeMatchingMockBehaviorInvocationHandler(new ExceptionThrowingMockBehavior(exception));
        return this.startBehaviorDefinition(proxyInvocationHandler, "onceRaises");
    }

    @Override
    @MatchStatement
    public T oncePerforms(MockBehavior mockBehavior) {
        OneTimeMatchingMockBehaviorInvocationHandler proxyInvocationHandler = new OneTimeMatchingMockBehaviorInvocationHandler(mockBehavior);
        return this.startBehaviorDefinition(proxyInvocationHandler, "oncePerforms");
    }

    @Override
    @MatchStatement
    public T assertInvoked() {
        AssertInvokedInvocationHandler proxyInvocationHandler = new AssertInvokedInvocationHandler(this.getInvokedAt());
        return this.startAssertion(proxyInvocationHandler, "assertInvoked");
    }

    @Override
    @MatchStatement
    public T assertInvokedInSequence() {
        AssertInvokedInOrderInvocationHandler proxyInvocationHandler = new AssertInvokedInOrderInvocationHandler(this.getInvokedAt());
        return this.startAssertion(proxyInvocationHandler, "assertInvokedInOrder");
    }

    @Override
    @MatchStatement
    public T assertNotInvoked() {
        AssertNotInvokedInvocationHandler proxyInvocationHandler = new AssertNotInvokedInvocationHandler(this.getInvokedAt());
        return this.startAssertion(proxyInvocationHandler, "assertNotInvoked");
    }

    protected T startBehaviorDefinition(ProxyInvocationHandler proxyInvocationHandler, String behaviorDefinitionMethodName) {
        StackTraceElement[] invokedAt = this.getInvokedAt();
        ArgumentMatcherRepository.getInstance().registerStartOfMatchingInvocation(invokedAt[0].getLineNumber());
        this.getSyntaxMonitor().startDefinition(this.name, behaviorDefinitionMethodName, proxyInvocationHandler, invokedAt);
        return this.createMockObjectProxy(proxyInvocationHandler);
    }

    protected T startAssertion(ProxyInvocationHandler proxyInvocationHandler, String assertMethodName) {
        StackTraceElement[] invokedAt = this.getInvokedAt();
        ArgumentMatcherRepository.getInstance().registerStartOfMatchingInvocation(invokedAt[0].getLineNumber());
        this.getSyntaxMonitor().startDefinition(this.name, assertMethodName, proxyInvocationHandler, invokedAt);
        return this.createMockObjectProxy(proxyInvocationHandler);
    }

    protected Object handleMockObjectInvocation(ProxyInvocation proxyInvocation) throws Throwable {
        this.getSyntaxMonitor().assertNotExpectingInvocation();
        BehaviorDefiningInvocation behaviorDefiningInvocation = this.getMatchingBehaviorDefiningInvocation(proxyInvocation);
        MockBehavior mockBehavior = this.getMockBehavior(proxyInvocation, behaviorDefiningInvocation);
        ObservedInvocation mockInvocation = this.createObservedInvocation(proxyInvocation, behaviorDefiningInvocation, mockBehavior);
        this.scenario.addObservedMockInvocation(mockInvocation);
        Object result = null;
        if (mockBehavior != null) {
            result = mockBehavior.execute(proxyInvocation);
        }
        mockInvocation.setResultAtInvocationTime(CloneUtil.createDeepClone(result));
        return result;
    }

    protected void handleOneTimeMatchingMockBehaviorInvocation(ProxyInvocation proxyInvocation, MockBehavior mockBehavior) {
        this.getSyntaxMonitor().endDefinition();
        BehaviorDefiningInvocation behaviorDefiningInvocation = this.createBehaviorDefiningInvocation(proxyInvocation, mockBehavior);
        this.oneTimeMatchingMockBehaviors.add(behaviorDefiningInvocation);
    }

    protected void handleAlwaysMatchingMockBehaviorInvocation(ProxyInvocation proxyInvocation, MockBehavior mockBehavior) {
        this.getSyntaxMonitor().endDefinition();
        BehaviorDefiningInvocation behaviorDefiningInvocation = this.createBehaviorDefiningInvocation(proxyInvocation, mockBehavior);
        this.alwaysMatchingMockBehaviors.add(behaviorDefiningInvocation);
    }

    protected void handleAssertInvokedInvocation(ProxyInvocation proxyInvocation, StackTraceElement[] assertedAt) {
        this.getSyntaxMonitor().endDefinition();
        BehaviorDefiningInvocation behaviorDefiningInvocation = this.createBehaviorDefiningInvocation(proxyInvocation, null);
        this.scenario.assertInvoked(behaviorDefiningInvocation, assertedAt);
    }

    protected void handleAssertInvokedInOrderInvocation(ProxyInvocation proxyInvocation, StackTraceElement[] assertedAt) {
        this.getSyntaxMonitor().endDefinition();
        BehaviorDefiningInvocation behaviorDefiningInvocation = this.createBehaviorDefiningInvocation(proxyInvocation, null);
        this.scenario.assertInvokedInOrder(behaviorDefiningInvocation, assertedAt);
    }

    protected void handleAssertNotInvokedInvocation(ProxyInvocation proxyInvocation, StackTraceElement[] assertedAt) {
        this.getSyntaxMonitor().endDefinition();
        BehaviorDefiningInvocation behaviorDefiningInvocation = this.createBehaviorDefiningInvocation(proxyInvocation, null);
        this.scenario.assertNotInvoked(behaviorDefiningInvocation, assertedAt);
    }

    protected BehaviorDefiningInvocation getMatchingBehaviorDefiningInvocation(ProxyInvocation proxyInvocation) throws Throwable {
        for (BehaviorDefiningInvocation behaviorDefiningInvocation : this.oneTimeMatchingMockBehaviors) {
            if (behaviorDefiningInvocation.isUsed() || !behaviorDefiningInvocation.matches(proxyInvocation)) continue;
            behaviorDefiningInvocation.markAsUsed();
            return behaviorDefiningInvocation;
        }
        for (BehaviorDefiningInvocation behaviorDefiningInvocation : this.alwaysMatchingMockBehaviors) {
            if (!behaviorDefiningInvocation.matches(proxyInvocation)) continue;
            behaviorDefiningInvocation.markAsUsed();
            return behaviorDefiningInvocation;
        }
        return null;
    }

    protected MockBehavior getMockBehavior(ProxyInvocation proxyInvocation, BehaviorDefiningInvocation behaviorDefiningInvocation) {
        if (behaviorDefiningInvocation != null) {
            return behaviorDefiningInvocation.getMockBehavior();
        }
        if (this.partialMock) {
            return new OriginalBehaviorInvokingMockBehavior();
        }
        if (proxyInvocation.getMethod().getReturnType() == Void.TYPE) {
            return null;
        }
        return new DefaultValueReturningMockBehavior();
    }

    protected StackTraceElement[] getInvokedAt() {
        return CallStackUtils.getInvocationStackTrace(MockObject.class);
    }

    protected T createInstance() {
        return this.createMockObjectProxy(new MockObjectInvocationHandler());
    }

    protected T createMockObjectProxy(ProxyInvocationHandler invocationHandler) {
        return ProxyUtil.createProxy(this.mockedClass, invocationHandler);
    }

    protected BehaviorDefiningInvocation createBehaviorDefiningInvocation(ProxyInvocation proxyInvocation, MockBehavior mockBehavior) {
        List<ArgumentMatcher> argumentMatchers = this.createArgumentMatchers(proxyInvocation);
        Method method = proxyInvocation.getMethod();
        List<Object> arguments = proxyInvocation.getArguments();
        List<Object> argumentsAtInvocationTime = CloneUtil.createDeepClone(arguments);
        StackTraceElement invokedAt = proxyInvocation.getInvokedAt();
        return new BehaviorDefiningInvocation(proxyInvocation.getProxy(), this.name, method, arguments, argumentsAtInvocationTime, invokedAt, argumentMatchers, mockBehavior);
    }

    protected ObservedInvocation createObservedInvocation(ProxyInvocation proxyInvocation, BehaviorDefiningInvocation behaviorDefiningInvocation, MockBehavior mockBehavior) {
        Method method = proxyInvocation.getMethod();
        List<Object> arguments = proxyInvocation.getArguments();
        List<Object> argumentsAtInvocationTime = CloneUtil.createDeepClone(arguments);
        StackTraceElement invokedAt = proxyInvocation.getInvokedAt();
        return new ObservedInvocation(proxyInvocation.getProxy(), this.name, method, arguments, argumentsAtInvocationTime, invokedAt, behaviorDefiningInvocation, mockBehavior);
    }

    protected List<ArgumentMatcher> createArgumentMatchers(ProxyInvocation proxyInvocation) {
        ArrayList<ArgumentMatcher> result = new ArrayList<ArgumentMatcher>();
        int matchInvocationStartLineNr = ArgumentMatcherRepository.getInstance().getMatchInvocationStartLineNr();
        int matchInvocationEndLineNr = ArgumentMatcherRepository.getInstance().getMatchInvocationEndLineNr();
        List<Integer> argumentMatcherIndexes = ArgumentMatcherPositionFinder.getArgumentMatcherIndexes(proxyInvocation, matchInvocationStartLineNr, matchInvocationEndLineNr);
        int argumentIndex = 0;
        Iterator<ArgumentMatcher> argumentMatcherIterator = ArgumentMatcherRepository.getInstance().getArgumentMatchers().iterator();
        for (Object argument : proxyInvocation.getArguments()) {
            if (argumentMatcherIndexes.contains(argumentIndex++)) {
                result.add(argumentMatcherIterator.next());
                continue;
            }
            result.add(new DefaultArgumentMatcher(argument));
        }
        ArgumentMatcherRepository.getInstance().registerEndOfMatchingInvocation();
        return result;
    }

    protected SyntaxMonitor getSyntaxMonitor() {
        return this.scenario.getSyntaxMonitor();
    }

    protected class AssertNotInvokedInvocationHandler
    implements ProxyInvocationHandler {
        private StackTraceElement[] assertedAt;

        public AssertNotInvokedInvocationHandler(StackTraceElement[] assertedAt) {
            this.assertedAt = assertedAt;
        }

        public Object handleInvocation(ProxyInvocation proxyInvocation) throws Throwable {
            MockObject.this.handleAssertNotInvokedInvocation(proxyInvocation, this.assertedAt);
            return null;
        }
    }

    protected class AssertInvokedInOrderInvocationHandler
    implements ProxyInvocationHandler {
        private StackTraceElement[] assertedAt;

        public AssertInvokedInOrderInvocationHandler(StackTraceElement[] assertedAt) {
            this.assertedAt = assertedAt;
        }

        public Object handleInvocation(ProxyInvocation proxyInvocation) throws Throwable {
            MockObject.this.handleAssertInvokedInOrderInvocation(proxyInvocation, this.assertedAt);
            return null;
        }
    }

    protected class AssertInvokedInvocationHandler
    implements ProxyInvocationHandler {
        private StackTraceElement[] assertedAt;

        public AssertInvokedInvocationHandler(StackTraceElement[] assertedAt) {
            this.assertedAt = assertedAt;
        }

        public Object handleInvocation(ProxyInvocation proxyInvocation) throws Throwable {
            MockObject.this.handleAssertInvokedInvocation(proxyInvocation, this.assertedAt);
            return null;
        }
    }

    protected class MockObjectInvocationHandler
    implements ProxyInvocationHandler {
        protected MockObjectInvocationHandler() {
        }

        public Object handleInvocation(ProxyInvocation invocation) throws Throwable {
            return MockObject.this.handleMockObjectInvocation(invocation);
        }
    }

    protected class OneTimeMatchingMockBehaviorInvocationHandler
    implements ProxyInvocationHandler {
        private MockBehavior mockBehavior;

        public OneTimeMatchingMockBehaviorInvocationHandler(MockBehavior mockBehavior) {
            this.mockBehavior = mockBehavior;
        }

        public Object handleInvocation(ProxyInvocation invocation) throws Throwable {
            MockObject.this.handleOneTimeMatchingMockBehaviorInvocation(invocation, this.mockBehavior);
            return null;
        }
    }

    protected class AlwaysMatchingMockBehaviorInvocationHandler
    implements ProxyInvocationHandler {
        private MockBehavior mockBehavior;

        public AlwaysMatchingMockBehaviorInvocationHandler(MockBehavior mockBehavior) {
            this.mockBehavior = mockBehavior;
        }

        public Object handleInvocation(ProxyInvocation invocation) throws Throwable {
            MockObject.this.handleAlwaysMatchingMockBehaviorInvocation(invocation, this.mockBehavior);
            return null;
        }
    }
}

