/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.mock.dummy;

import java.lang.reflect.Method;
import org.unitils.mock.dummy.DummyObject;
import org.unitils.mock.mockbehavior.MockBehavior;
import org.unitils.mock.mockbehavior.impl.DefaultValueReturningMockBehavior;
import org.unitils.mock.proxy.ProxyInvocation;
import org.unitils.mock.proxy.ProxyInvocationHandler;
import org.unitils.mock.proxy.ProxyUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DummyObjectUtil {
    public static <T> T createDummy(Class<T> type) {
        Class[] interfaces;
        Class superClass;
        if (type.isInterface()) {
            superClass = Object.class;
            interfaces = new Class[]{type, DummyObject.class, Cloneable.class};
        } else {
            superClass = type;
            interfaces = new Class[]{DummyObject.class, Cloneable.class};
        }
        return (T)ProxyUtil.createProxy(superClass, interfaces, new DummyObjectInvocationHandler(type));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DummyObjectInvocationHandler
    implements ProxyInvocationHandler {
        private Class<?> dummyObjectClass;
        private Integer dummyObjectHashCode = new Object().hashCode();
        private MockBehavior dummyObjectBehavior = new DefaultValueReturningMockBehavior();

        public DummyObjectInvocationHandler(Class<?> dummyObjectClass) {
            this.dummyObjectClass = dummyObjectClass;
        }

        @Override
        public Object handleInvocation(ProxyInvocation invocation) throws Throwable {
            if (this.isEqualsMethod(invocation.getMethod())) {
                Object other = invocation.getArguments().get(0);
                return invocation.getProxy() == other;
            }
            if (this.isHashCodeMethod(invocation.getMethod())) {
                return this.dummyObjectHashCode;
            }
            if (this.isCloneMethod(invocation.getMethod())) {
                return invocation.getProxy();
            }
            if (this.isToStringMethod(invocation.getMethod()) || this.isFormatAdviseFormatMethod(invocation.getMethod())) {
                return "DUMMY " + this.dummyObjectClass.getSimpleName() + "@" + Integer.toHexString(this.dummyObjectHashCode);
            }
            return this.dummyObjectBehavior.execute(invocation);
        }

        protected boolean isEqualsMethod(Method method) {
            return "equals".equals(method.getName()) && 1 == method.getParameterTypes().length && Object.class.equals(method.getParameterTypes()[0]);
        }

        protected boolean isHashCodeMethod(Method method) {
            return "hashCode".equals(method.getName()) && 0 == method.getParameterTypes().length;
        }

        protected boolean isToStringMethod(Method method) {
            return "toString".equals(method.getName()) && 0 == method.getParameterTypes().length;
        }

        protected boolean isCloneMethod(Method method) {
            return "clone".equals(method.getName()) && 0 == method.getParameterTypes().length;
        }

        protected boolean isFormatAdviseFormatMethod(Method method) {
            return "$_format".equals(method.getName()) && 0 == method.getParameterTypes().length;
        }
    }
}

