/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.reflectionassert;

import java.util.Collection;
import java.util.Map;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import ognl.DefaultMemberAccess;
import ognl.MemberAccess;
import ognl.Ognl;
import ognl.OgnlContext;
import ognl.OgnlException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang.StringUtils;
import org.unitils.core.UnitilsException;
import org.unitils.reflectionassert.ReflectionComparator;
import org.unitils.reflectionassert.ReflectionComparatorFactory;
import org.unitils.reflectionassert.ReflectionComparatorMode;
import org.unitils.reflectionassert.difference.Difference;
import org.unitils.reflectionassert.report.impl.DefaultDifferenceReport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionAssert {
    public static void assertLenEquals(Object expected, Object actual) throws AssertionFailedError {
        ReflectionAssert.assertLenientEquals(expected, actual);
    }

    public static void assertLenientEquals(Object expected, Object actual) throws AssertionFailedError {
        ReflectionAssert.assertLenientEquals(null, expected, actual);
    }

    public static void assertRefEquals(Object expected, Object actual, ReflectionComparatorMode ... modes) throws AssertionFailedError {
        ReflectionAssert.assertReflectionEquals(expected, actual, modes);
    }

    public static void assertReflectionEquals(Object expected, Object actual, ReflectionComparatorMode ... modes) throws AssertionFailedError {
        ReflectionAssert.assertReflectionEquals(null, expected, actual, modes);
    }

    public static void assertLenEquals(String message, Object expected, Object actual) throws AssertionFailedError {
        ReflectionAssert.assertLenientEquals(message, expected, actual);
    }

    public static void assertLenientEquals(String message, Object expected, Object actual) throws AssertionFailedError {
        ReflectionAssert.assertReflectionEquals(message, expected, actual, ReflectionComparatorMode.LENIENT_ORDER, ReflectionComparatorMode.IGNORE_DEFAULTS);
    }

    public static void assertRefEquals(String message, Object expected, Object actual, ReflectionComparatorMode ... modes) throws AssertionFailedError {
        ReflectionAssert.assertReflectionEquals(message, expected, actual, modes);
    }

    public static void assertReflectionEquals(String message, Object expected, Object actual, ReflectionComparatorMode ... modes) throws AssertionFailedError {
        ReflectionComparator reflectionComparator = ReflectionComparatorFactory.createRefectionComparator(modes);
        Difference difference = reflectionComparator.getDifference(expected, actual);
        if (difference != null) {
            DefaultDifferenceReport differenceReport = new DefaultDifferenceReport();
            Assert.fail((String)differenceReport.createReport(message, difference));
        }
    }

    public static void assertPropertyLenEquals(String propertyName, Object expectedPropertyValue, Object actualObject) throws AssertionFailedError {
        ReflectionAssert.assertPropertyLenientEquals(propertyName, expectedPropertyValue, actualObject);
    }

    public static void assertPropertyLenientEquals(String propertyName, Object expectedPropertyValue, Object actualObject) throws AssertionFailedError {
        ReflectionAssert.assertPropertyLenientEquals(null, propertyName, expectedPropertyValue, actualObject);
    }

    public static void assertPropertyRefEquals(String propertyName, Object expectedPropertyValue, Object actualObject, ReflectionComparatorMode ... modes) throws AssertionFailedError {
        ReflectionAssert.assertPropertyReflectionEquals(propertyName, expectedPropertyValue, actualObject, modes);
    }

    public static void assertPropertyReflectionEquals(String propertyName, Object expectedPropertyValue, Object actualObject, ReflectionComparatorMode ... modes) throws AssertionFailedError {
        ReflectionAssert.assertPropertyReflectionEquals(null, propertyName, expectedPropertyValue, actualObject, modes);
    }

    public static void assertPropertyLenEquals(String message, String propertyName, Object expectedPropertyValue, Object actualObject) throws AssertionFailedError {
        ReflectionAssert.assertPropertyLenientEquals(message, propertyName, expectedPropertyValue, actualObject);
    }

    public static void assertPropertyLenientEquals(String message, String propertyName, Object expectedPropertyValue, Object actualObject) throws AssertionFailedError {
        ReflectionAssert.assertPropertyReflectionEquals(message, propertyName, expectedPropertyValue, actualObject, ReflectionComparatorMode.LENIENT_ORDER, ReflectionComparatorMode.IGNORE_DEFAULTS);
    }

    public static void assertPropertyRefEquals(String message, String propertyName, Object expectedPropertyValue, Object actualObject, ReflectionComparatorMode ... modes) throws AssertionFailedError {
        ReflectionAssert.assertPropertyReflectionEquals(message, propertyName, expectedPropertyValue, actualObject, modes);
    }

    public static void assertPropertyReflectionEquals(String message, String propertyName, Object expectedPropertyValue, Object actualObject, ReflectionComparatorMode ... modes) throws AssertionFailedError {
        Assert.assertNotNull((String)"Actual object is null.", (Object)actualObject);
        Object propertyValue = ReflectionAssert.getProperty(actualObject, propertyName);
        String formattedMessage = ReflectionAssert.formatMessage(message, "Incorrect value for property: " + propertyName);
        ReflectionAssert.assertReflectionEquals(formattedMessage, expectedPropertyValue, propertyValue, modes);
    }

    public static void assertPropertyLenEquals(String propertyName, Collection<?> expectedPropertyValues, Collection<?> actualObjects) throws AssertionFailedError {
        ReflectionAssert.assertPropertyLenientEquals(propertyName, expectedPropertyValues, actualObjects);
    }

    public static void assertPropertyLenientEquals(String propertyName, Collection<?> expectedPropertyValues, Collection<?> actualObjects) throws AssertionFailedError {
        ReflectionAssert.assertPropertyLenientEquals(null, propertyName, expectedPropertyValues, actualObjects);
    }

    public static void assertPropertyRefEquals(String propertyName, Collection<?> expectedPropertyValues, Collection<?> actualObjects, ReflectionComparatorMode ... modes) throws AssertionFailedError {
        ReflectionAssert.assertPropertyReflectionEquals(propertyName, expectedPropertyValues, actualObjects, modes);
    }

    public static void assertPropertyReflectionEquals(String propertyName, Collection<?> expectedPropertyValues, Collection<?> actualObjects, ReflectionComparatorMode ... modes) throws AssertionFailedError {
        ReflectionAssert.assertPropertyReflectionEquals(null, propertyName, expectedPropertyValues, actualObjects, modes);
    }

    public static void assertPropertyLenEquals(String message, String propertyName, Collection<?> expectedPropertyValues, Collection<?> actualObjects) throws AssertionFailedError {
        ReflectionAssert.assertPropertyLenientEquals(message, propertyName, expectedPropertyValues, actualObjects);
    }

    public static void assertPropertyLenientEquals(String message, String propertyName, Collection<?> expectedPropertyValues, Collection<?> actualObjects) throws AssertionFailedError {
        ReflectionAssert.assertPropertyReflectionEquals(message, propertyName, expectedPropertyValues, actualObjects, ReflectionComparatorMode.LENIENT_ORDER, ReflectionComparatorMode.IGNORE_DEFAULTS);
    }

    public static void assertPropertyRefEquals(String message, String propertyName, Collection<?> expectedPropertyValues, Collection<?> actualObjects, ReflectionComparatorMode ... modes) throws AssertionFailedError {
        ReflectionAssert.assertPropertyReflectionEquals(message, propertyName, expectedPropertyValues, actualObjects, modes);
    }

    public static void assertPropertyReflectionEquals(String message, String propertyName, Collection<?> expectedPropertyValues, Collection<?> actualObjects, ReflectionComparatorMode ... modes) throws AssertionFailedError {
        Assert.assertNotNull((String)"Actual object list is null.", actualObjects);
        Collection actualPropertyValues = CollectionUtils.collect(actualObjects, (Transformer)new OgnlTransformer(propertyName));
        ReflectionAssert.assertReflectionEquals(message, expectedPropertyValues, actualPropertyValues, modes);
    }

    protected static String formatMessage(String suppliedMessage, String specificMessage) {
        if (StringUtils.isEmpty((String)suppliedMessage)) {
            return specificMessage;
        }
        return suppliedMessage + "\n" + specificMessage;
    }

    protected static Object getProperty(Object object, String ognlExpression) {
        try {
            OgnlContext ognlContext = new OgnlContext();
            ognlContext.setMemberAccess((MemberAccess)new DefaultMemberAccess(true));
            Object ognlExprObj = Ognl.parseExpression((String)ognlExpression);
            return Ognl.getValue((Object)ognlExprObj, (Map)ognlContext, (Object)object);
        }
        catch (OgnlException e) {
            throw new UnitilsException("Failed to get property value using OGNL expression " + ognlExpression, e);
        }
    }

    protected static class OgnlTransformer
    implements Transformer {
        private String ognlExpression;

        public OgnlTransformer(String ognlExpression) {
            this.ognlExpression = ognlExpression;
        }

        public Object transform(Object object) {
            if (object == null) {
                return null;
            }
            return ReflectionAssert.getProperty(object, this.ognlExpression);
        }
    }
}

