/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.reflectionassert.comparator.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.unitils.reflectionassert.ReflectionComparator;
import org.unitils.reflectionassert.comparator.Comparator;
import org.unitils.reflectionassert.difference.Difference;
import org.unitils.reflectionassert.difference.UnorderedCollectionDifference;
import org.unitils.reflectionassert.util.MatchingScoreCalculator;
import org.unitils.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LenientOrderCollectionComparator
implements Comparator {
    @Override
    public boolean canCompare(Object left, Object right) {
        if (left == null || right == null) {
            return false;
        }
        return !(!left.getClass().isArray() && !(left instanceof Collection) || !right.getClass().isArray() && !(right instanceof Collection));
    }

    @Override
    public Difference compare(Object left, Object right, boolean onlyFirstDifference, ReflectionComparator reflectionComparator) {
        ArrayList<Object> rightList;
        ArrayList<Object> leftList = new ArrayList<Object>(CollectionUtils.convertToCollection(left));
        boolean isEqual = this.isEqual(leftList, rightList = new ArrayList<Object>(CollectionUtils.convertToCollection(right)), 0, reflectionComparator);
        if (isEqual) {
            return null;
        }
        UnorderedCollectionDifference difference = new UnorderedCollectionDifference("Collections/arrays are different", left, right, leftList, rightList);
        if (onlyFirstDifference) {
            return difference;
        }
        this.fillAllDifferences(leftList, rightList, reflectionComparator, difference);
        this.fillBestMatchingIndexes(leftList, rightList, difference);
        return difference;
    }

    protected boolean isEqual(ArrayList<Object> leftList, ArrayList<Object> rightList, int leftIndex, ReflectionComparator reflectionComparator) {
        if (leftIndex >= leftList.size()) {
            return rightList.isEmpty();
        }
        Object leftValue = leftList.get(leftIndex);
        for (int rightIndex = 0; rightIndex < rightList.size(); ++rightIndex) {
            Object rightValue = rightList.get(rightIndex);
            Difference elementDifference = reflectionComparator.getDifference(leftValue, rightValue, true);
            if (elementDifference != null) continue;
            ArrayList rightListClone = (ArrayList)rightList.clone();
            rightListClone.remove(rightIndex);
            boolean isEqual = this.isEqual(leftList, rightListClone, leftIndex + 1, reflectionComparator);
            if (!isEqual) continue;
            return true;
        }
        return false;
    }

    protected void fillAllDifferences(ArrayList<Object> leftList, ArrayList<Object> rightList, ReflectionComparator reflectionComparator, UnorderedCollectionDifference difference) {
        for (int leftIndex = 0; leftIndex < leftList.size(); ++leftIndex) {
            Object leftValue = leftList.get(leftIndex);
            for (int rightIndex = 0; rightIndex < rightList.size(); ++rightIndex) {
                Object rightValue = rightList.get(rightIndex);
                Difference elementDifference = reflectionComparator.getDifference(leftValue, rightValue, false);
                difference.addElementDifference(leftIndex, rightIndex, elementDifference);
            }
        }
    }

    protected void fillBestMatchingIndexes(ArrayList<Object> leftList, ArrayList<Object> rightList, UnorderedCollectionDifference difference) {
        ArrayList<Integer> leftIndexes = new ArrayList<Integer>(rightList.size());
        for (int i = 0; i < leftList.size(); ++i) {
            leftIndexes.add(i);
        }
        ArrayList<Integer> rightIndexes = new ArrayList<Integer>(rightList.size());
        for (int i = 0; i < rightList.size(); ++i) {
            rightIndexes.add(i);
        }
        HashMap<Integer, Integer> currentMatchingIndexes = new HashMap<Integer, Integer>();
        MatchingScoreCalculator matchingScoreCalculator = this.createMatchingScoreCalculator();
        this.fillBestMatchingIndexesImpl(leftIndexes, rightIndexes, 0, currentMatchingIndexes, difference, matchingScoreCalculator);
    }

    protected void fillBestMatchingIndexesImpl(ArrayList<Integer> leftIndexes, ArrayList<Integer> rightIndexes, int currentMatchingScore, HashMap<Integer, Integer> currentMatchingIndexes, UnorderedCollectionDifference difference, MatchingScoreCalculator matchingScoreCalculator) {
        if (leftIndexes.isEmpty() || rightIndexes.isEmpty()) {
            if (currentMatchingScore < difference.getBestMatchingScore()) {
                difference.getBestMatchingIndexes().putAll(currentMatchingIndexes);
                for (Integer leftIndex : leftIndexes) {
                    difference.setBestMatchingIndexes(leftIndex, -1);
                }
                for (Integer rightIndex : rightIndexes) {
                    difference.setBestMatchingIndexes(-1, rightIndex);
                }
                difference.setBestMatchingScore(currentMatchingScore);
            }
            return;
        }
        Map<Integer, Map<Integer, Difference>> differences = difference.getElementDifferences();
        Integer leftIndex = leftIndexes.get(0);
        for (Integer rightIndex : rightIndexes) {
            Difference elementDifference = differences.get(leftIndex).get(rightIndex);
            int matchingScore = matchingScoreCalculator.calculateMatchingScore(elementDifference);
            ArrayList leftIndexesClone = (ArrayList)leftIndexes.clone();
            ArrayList rightIndexesClone = (ArrayList)rightIndexes.clone();
            leftIndexesClone.remove(0);
            rightIndexesClone.remove(rightIndex);
            currentMatchingIndexes.put(leftIndex, rightIndex);
            this.fillBestMatchingIndexesImpl(leftIndexesClone, rightIndexesClone, currentMatchingScore + matchingScore, currentMatchingIndexes, difference, matchingScoreCalculator);
            currentMatchingIndexes.remove(leftIndex);
        }
    }

    protected MatchingScoreCalculator createMatchingScoreCalculator() {
        return new MatchingScoreCalculator();
    }
}

