/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.reflectionassert.report.impl;

import java.util.List;
import java.util.Map;
import org.unitils.core.util.ObjectFormatter;
import org.unitils.reflectionassert.difference.CollectionDifference;
import org.unitils.reflectionassert.difference.Difference;
import org.unitils.reflectionassert.difference.DifferenceVisitor;
import org.unitils.reflectionassert.difference.MapDifference;
import org.unitils.reflectionassert.difference.ObjectDifference;
import org.unitils.reflectionassert.difference.UnorderedCollectionDifference;
import org.unitils.reflectionassert.report.DifferenceView;

public class DefaultDifferenceView
implements DifferenceView {
    protected boolean outputtingUnorderedCollectionDifference = false;
    protected ObjectFormatter objectFormatter = new ObjectFormatter();
    protected DifferenceFormatterVisitor differenceFormatterVisitor = new DifferenceFormatterVisitor();

    public String createView(Difference difference) {
        return difference.accept(this.differenceFormatterVisitor, null);
    }

    protected String formatDifference(Difference difference, String fieldName) {
        return this.formatValues(fieldName, difference.getLeftValue(), difference.getRightValue());
    }

    protected String formatDifference(ObjectDifference objectDifference, String fieldName) {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, Difference> fieldDifference : objectDifference.getFieldDifferences().entrySet()) {
            String innerFieldName = this.createFieldName(fieldName, fieldDifference.getKey(), true);
            result.append(fieldDifference.getValue().accept(this.differenceFormatterVisitor, innerFieldName));
        }
        return result.toString();
    }

    protected String formatDifference(CollectionDifference collectionDifference, String fieldName) {
        String innerFieldName;
        StringBuilder result = new StringBuilder();
        for (Map.Entry<Integer, Difference> elementDifferences : collectionDifference.getElementDifferences().entrySet()) {
            String innerFieldName2 = this.createFieldName(fieldName, "[" + elementDifferences.getKey() + "]", false);
            result.append(elementDifferences.getValue().accept(this.differenceFormatterVisitor, innerFieldName2));
        }
        List<?> leftList = collectionDifference.getLeftList();
        List<?> rightList = collectionDifference.getRightList();
        for (Integer leftIndex : collectionDifference.getLeftMissingIndexes()) {
            innerFieldName = this.createFieldName(fieldName, "[" + leftIndex + "]", false);
            result.append(this.formatValues(innerFieldName, leftList.get(leftIndex), ""));
        }
        for (Integer rightIndex : collectionDifference.getRightMissingIndexes()) {
            innerFieldName = this.createFieldName(fieldName, "[" + rightIndex + "]", false);
            result.append(this.formatValues(innerFieldName, "", rightList.get(rightIndex)));
        }
        return result.toString();
    }

    protected String formatDifference(MapDifference mapDifference, String fieldName) {
        String innerFieldName;
        StringBuilder result = new StringBuilder();
        for (Map.Entry<Object, Difference> valueDifference : mapDifference.getValueDifferences().entrySet()) {
            String innerFieldName2 = this.createFieldName(fieldName, this.objectFormatter.format(valueDifference.getKey()), true);
            result.append(valueDifference.getValue().accept(this.differenceFormatterVisitor, innerFieldName2));
        }
        Map<?, ?> leftMap = mapDifference.getLeftMap();
        Map<?, ?> rightMap = mapDifference.getRightMap();
        for (Object leftKey : mapDifference.getLeftMissingKeys()) {
            innerFieldName = this.createFieldName(fieldName, this.objectFormatter.format(leftKey), true);
            result.append(this.formatValues(innerFieldName, leftMap.get(leftKey), ""));
        }
        for (Object rightKey : mapDifference.getRightMissingKeys()) {
            innerFieldName = this.createFieldName(fieldName, this.objectFormatter.format(rightKey), true);
            result.append(this.formatValues(innerFieldName, rightMap.get(rightKey), ""));
        }
        return result.toString();
    }

    protected String formatDifference(UnorderedCollectionDifference unorderedCollectionDifference, String fieldName) {
        StringBuilder result = new StringBuilder();
        Map<Integer, Integer> bestMatchingIndexes = unorderedCollectionDifference.getBestMatchingIndexes();
        for (Map.Entry<Integer, Integer> bestMatchingIndex : bestMatchingIndexes.entrySet()) {
            String innerFieldName;
            int leftIndex = bestMatchingIndex.getKey();
            int rightIndex = bestMatchingIndex.getValue();
            if (leftIndex == -1) {
                innerFieldName = this.createFieldName(fieldName, "[x," + rightIndex + "]", false);
                result.append(this.formatValues(innerFieldName, "", unorderedCollectionDifference.getRightList().get(rightIndex)));
                continue;
            }
            if (rightIndex == -1) {
                innerFieldName = this.createFieldName(fieldName, "[" + leftIndex + ",x]", false);
                result.append(this.formatValues(innerFieldName, unorderedCollectionDifference.getLeftList().get(leftIndex), ""));
                continue;
            }
            Difference difference = unorderedCollectionDifference.getElementDifference(leftIndex, rightIndex);
            if (difference == null) continue;
            String innerFieldName2 = this.createFieldName(fieldName, "[" + leftIndex + "," + rightIndex + "]", false);
            result.append(difference.accept(this.differenceFormatterVisitor, innerFieldName2));
        }
        return result.toString();
    }

    protected String formatValues(String fieldName, Object leftValue, Object rightValue) {
        StringBuilder result = new StringBuilder();
        if (fieldName != null) {
            result.append(" ");
            result.append(fieldName);
            result.append("\n");
        }
        result.append("    =>  ");
        result.append(this.objectFormatter.format(leftValue));
        result.append("\n");
        result.append("    =>  ");
        result.append(this.objectFormatter.format(rightValue));
        result.append("\n\n");
        return result.toString();
    }

    protected String createFieldName(String fieldName, String innerFieldName, boolean includePoint) {
        if (fieldName == null) {
            return innerFieldName;
        }
        StringBuilder result = new StringBuilder();
        result.append(fieldName);
        if (includePoint) {
            result.append(".");
        }
        result.append(innerFieldName);
        return result.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class DifferenceFormatterVisitor
    implements DifferenceVisitor<String, String> {
        protected DifferenceFormatterVisitor() {
        }

        @Override
        public String visit(Difference difference, String fieldName) {
            return DefaultDifferenceView.this.formatDifference(difference, fieldName);
        }

        @Override
        public String visit(ObjectDifference objectDifference, String fieldName) {
            return DefaultDifferenceView.this.formatDifference(objectDifference, fieldName);
        }

        @Override
        public String visit(MapDifference mapDifference, String fieldName) {
            return DefaultDifferenceView.this.formatDifference(mapDifference, fieldName);
        }

        @Override
        public String visit(CollectionDifference collectionDifference, String fieldName) {
            return DefaultDifferenceView.this.formatDifference(collectionDifference, fieldName);
        }

        @Override
        public String visit(UnorderedCollectionDifference unorderedCollectionDifference, String fieldName) {
            return DefaultDifferenceView.this.formatDifference(unorderedCollectionDifference, fieldName);
        }
    }
}

