/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.reflectionassert.util;

import java.util.IdentityHashMap;
import java.util.Map;
import org.unitils.reflectionassert.difference.CollectionDifference;
import org.unitils.reflectionassert.difference.Difference;
import org.unitils.reflectionassert.difference.DifferenceVisitor;
import org.unitils.reflectionassert.difference.MapDifference;
import org.unitils.reflectionassert.difference.ObjectDifference;
import org.unitils.reflectionassert.difference.UnorderedCollectionDifference;

public class MatchingScoreCalculator {
    protected MatchingScoreVisitor matchingScoreVisitor = new MatchingScoreVisitor();
    protected Map<Difference, Integer> cachedMatchingScores = new IdentityHashMap<Difference, Integer>();

    public int calculateMatchingScore(Difference difference) {
        if (difference == null) {
            return 0;
        }
        Integer matchingScore = this.cachedMatchingScores.get(difference);
        if (matchingScore == null) {
            matchingScore = difference.accept(this.matchingScoreVisitor, null);
            this.cachedMatchingScores.put(difference, matchingScore);
        }
        return matchingScore;
    }

    protected int getMatchingScore(Difference difference) {
        Object leftValue = difference.getLeftValue();
        Object rightValue = difference.getRightValue();
        if (leftValue != null && rightValue != null && !leftValue.getClass().equals(rightValue.getClass())) {
            return 5;
        }
        return 1;
    }

    protected int getMatchingScore(ObjectDifference objectDifference) {
        return objectDifference.getFieldDifferences().size();
    }

    protected int getMatchingScore(MapDifference mapDifference) {
        return mapDifference.getValueDifferences().size();
    }

    protected int getMatchingScore(CollectionDifference collectionDifference) {
        return collectionDifference.getElementDifferences().size();
    }

    protected int getMatchingScore(UnorderedCollectionDifference unorderedCollectionDifference) {
        return unorderedCollectionDifference.getBestMatchingScore();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class MatchingScoreVisitor
    implements DifferenceVisitor<Integer, Integer> {
        protected MatchingScoreVisitor() {
        }

        @Override
        public Integer visit(Difference difference, Integer argument) {
            return MatchingScoreCalculator.this.getMatchingScore(difference);
        }

        @Override
        public Integer visit(ObjectDifference objectDifference, Integer argument) {
            return MatchingScoreCalculator.this.getMatchingScore(objectDifference);
        }

        @Override
        public Integer visit(MapDifference mapDifference, Integer argument) {
            return MatchingScoreCalculator.this.getMatchingScore(mapDifference);
        }

        @Override
        public Integer visit(CollectionDifference collectionDifference, Integer argument) {
            return MatchingScoreCalculator.this.getMatchingScore(collectionDifference);
        }

        @Override
        public Integer visit(UnorderedCollectionDifference unorderedCollectionDifference, Integer argument) {
            return MatchingScoreCalculator.this.getMatchingScore(unorderedCollectionDifference);
        }
    }
}

