package org.unlaxer.vocabulary.ebnf.informally;

import java.util.List;
import java.util.function.Supplier;

import org.unlaxer.Name;
import org.unlaxer.parser.ChainParsers;
import org.unlaxer.parser.Parser;
import org.unlaxer.parser.combinator.LazyChain;
import org.unlaxer.parser.elementary.MappedSingleCharacterParser;
import org.unlaxer.parser.elementary.SpaceDelimitor;
import org.unlaxer.util.cache.SupplierBoundCache;

/**
 * https://www.cl.cam.ac.uk/~mgk25/iso-14977.pdf
 *
 * optional sequence = ’[’, definitions list, ’]’
 *   
 */
public class OptionalSequence extends LazyChain{

	private static final long serialVersionUID = 1227528692266646154L;

	public OptionalSequence() {
		super();
	}

	public OptionalSequence(Name name) {
		super(name);
	}

	@Override
	public Supplier<List<Parser>> getLazyParsers() {
		return new SupplierBoundCache<>(
			()->
			new ChainParsers(
				new MappedSingleCharacterParser('['),
				new SpaceDelimitor(),
				new DefinitionsList(),
				new SpaceDelimitor(),
				new MappedSingleCharacterParser(']')
			)
		);
	}
}