/*
 * Decompiled with CFR 0.152.
 */
package org.unlaxer.jaddress;

import java.util.Collections;
import java.util.List;
import org.unlaxer.jaddress.parser.DebugStatus;
import org.unlaxer.jaddress.parser.DebugStatuses;
import org.unlaxer.jaddress.parser.ParsingState;
import org.unlaxer.jaddress.parser.ResolverResult;
import org.unlaxer.jaddress.parser.ResolverResultKind;
import org.unlaxer.jaddress.parser.ResolverResultOfSearchCodec;

public class VacantDebugStatus {
    final DebugStatuses debugStatuses;
    public List<DebugStatus> parserDebugStatus;
    public final List<ResolverResult> searchCondition;
    public final String errorMessage;
    final String pipedVacantDebugStatus;

    public VacantDebugStatus(DebugStatuses debugStatuses, List<ResolverResult> searchCondition, String errorMessage) {
        this.debugStatuses = debugStatuses;
        this.searchCondition = searchCondition;
        this.errorMessage = errorMessage;
        this.parserDebugStatus = debugStatuses.debugStatuses();
        this.pipedVacantDebugStatus = debugStatuses.underScoredDebugStatus() + ";" + ResolverResultOfSearchCodec.SINGLETON.toString(searchCondition) + ";" + errorMessage;
    }

    public VacantDebugStatus(String pipedVacantDebugStatus) {
        this.pipedVacantDebugStatus = pipedVacantDebugStatus;
        String[] split = pipedVacantDebugStatus.split(";", 3);
        this.debugStatuses = new DebugStatuses(split[0]);
        this.searchCondition = (List)ResolverResultOfSearchCodec.SINGLETON.toResolverResults(() -> split[1]).getOrElse(Collections::emptyList);
        this.errorMessage = split[2];
        this.parserDebugStatus = this.debugStatuses.debugStatuses();
    }

    public DebugStatuses debugStatuses() {
        return this.debugStatuses;
    }

    public boolean allMatchParsingState(ParsingState parsingState) {
        return this.parserDebugStatus.stream().allMatch(debugStatus -> debugStatus.hasParsingState(parsingState));
    }

    public boolean anyMatchParsingState(ParsingState parsingState) {
        return this.parserDebugStatus.stream().anyMatch(debugStatus -> debugStatus.hasParsingState(parsingState));
    }

    public boolean allMatchResolverResult(ResolverResult resolverResult) {
        return this.searchCondition.stream().allMatch(_resolverResult -> _resolverResult.equals((Object)resolverResult));
    }

    public boolean anyResolverResult(ResolverResult resolverResult) {
        return this.searchCondition.stream().anyMatch(_resolverResult -> _resolverResult.equals((Object)resolverResult));
    }

    public boolean allMatchResolverResult(ResolverResultKind resolverResultKind) {
        return this.searchCondition.stream().allMatch(_resolverResult -> _resolverResult.kind() == resolverResultKind);
    }

    public boolean anyResolverResult(ResolverResultKind resolverResultKind) {
        return this.searchCondition.stream().anyMatch(_resolverResult -> _resolverResult.kind() == resolverResultKind);
    }

    public String pipedVacantDebugStatus() {
        return this.pipedVacantDebugStatus;
    }
}

