/*
 * Decompiled with CFR 0.152.
 */
package org.unlaxer.jaddress.parser;

import io.vavr.control.Try;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.function.Supplier;
import org.apache.commons.codec.binary.Hex;
import org.unlaxer.jaddress.parser.ResolverResult;
import org.unlaxer.jaddress.parser.ResolverResultCodec;
import org.unlaxer.jaddress.parser.ResolverResultKind;
import org.unlaxer.jaddress.parser.ResolverResultKindOfSearch;
import org.unlaxer.util.function.Unchecked;

public class ResolverResultOfSearchCodec
implements ResolverResultCodec {
    public static final ResolverResultOfSearchCodec SINGLETON = new ResolverResultOfSearchCodec();

    public Class<? extends ResolverResultKind> target() {
        return ResolverResultKindOfSearch.class;
    }

    public String toString(List<ResolverResult> resolverResultsOfThisKind) {
        BitSet bitSet = new BitSet();
        resolverResultsOfThisKind.stream().filter(resolverResult -> resolverResult.kind instanceof ResolverResultKindOfSearch).forEach(resolverResult -> {
            ResolverResultKind kind = resolverResult.kind;
            int ordinal = kind.ordinal();
            bitSet.set(ordinal);
        });
        byte[] bytes = bitSet.toByteArray();
        return Hex.encodeHexString((byte[])bytes);
    }

    public Try<List<ResolverResult>> toResolverResults(Supplier<String> hexStringOfResolverResults) {
        return Try.ofSupplier((Supplier)Unchecked.of(() -> {
            byte[] decodeHex = Hex.decodeHex((String)((String)hexStringOfResolverResults.get()));
            BitSet bitSet = BitSet.valueOf(decodeHex);
            ArrayList<ResolverResult> results = new ArrayList<ResolverResult>();
            for (int i = 0; i < bitSet.length(); ++i) {
                if (!bitSet.get(i)) continue;
                ResolverResultKindOfSearch resolverResultKindOfSearch = ResolverResultKindOfSearch.values()[i];
                ResolverResult resolverResult = new ResolverResult((ResolverResultKind)resolverResultKindOfSearch);
                results.add(resolverResult);
            }
            return results;
        }));
    }
}

