package org.uqbar.xtrest;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Pair;
import org.junit.Assert;
import org.junit.Test;
import org.uqbar.xtrest.api.ControllerAnnotationProcessor;

/**
 * @author jfernandes
 */
@SuppressWarnings("all")
public class UrlPatternTestCase extends Assert {
  private ControllerAnnotationProcessor processor = new ControllerAnnotationProcessor();
  
  @Test
  public void testSimpleUrlWithoutVariables() {
    Pair<String, ArrayList<String>> regexp = this.processor.createRegexp("/libros");
    Pair<String, List<Object>> _mappedTo = Pair.<String, List<Object>>of("/libros", Collections.<Object>unmodifiableList(CollectionLiterals.<Object>newArrayList()));
    Assert.assertEquals(_mappedTo, regexp);
    String _key = regexp.getKey();
    boolean _matches = _key.matches("/libros");
    Assert.assertTrue(_matches);
  }
  
  @Test
  public void testOneVar() {
    Pair<String, ArrayList<String>> regexp = this.processor.createRegexp("/libros/:id");
    Pair<String, List<String>> _mappedTo = Pair.<String, List<String>>of("\\/libros\\/(\\w+)", Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList("id")));
    Assert.assertEquals(_mappedTo, regexp);
    Pattern _compile = Pattern.compile("\\/libros\\/(\\w+)");
    Matcher _matcher = _compile.matcher("/libros/2");
    boolean _matches = _matcher.matches();
    Assert.assertTrue(_matches);
  }
}
