/*
 * Decompiled with CFR 0.152.
 */
package org.uqbar.xtrest.api;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.xtend.lib.macro.TransformationContext;
import org.eclipse.xtend.lib.macro.TransformationParticipant;
import org.eclipse.xtend.lib.macro.declaration.AnnotationReference;
import org.eclipse.xtend.lib.macro.declaration.CompilationStrategy;
import org.eclipse.xtend.lib.macro.declaration.MutableClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableMethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableParameterDeclaration;
import org.eclipse.xtend.lib.macro.declaration.Type;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.uqbar.xtrest.api.Result;
import org.uqbar.xtrest.api.annotation.Body;
import org.uqbar.xtrest.api.annotation.Delete;
import org.uqbar.xtrest.api.annotation.Get;
import org.uqbar.xtrest.api.annotation.Post;
import org.uqbar.xtrest.api.annotation.Put;
import org.uqbar.xtrest.result.ResultFactory;

public class ControllerAnnotationProcessor
implements TransformationParticipant<MutableClassDeclaration> {
    private static final List<? extends Class<? extends Annotation>> verbs = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Class[]{Get.class, Post.class, Delete.class, Put.class}));
    private static final List<String> ADDED_PARAMETER = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"target", "baseRequest", "request", "response"}));

    public void doTransform(List<? extends MutableClassDeclaration> annotatedTargetElements, @Extension TransformationContext context) {
        for (MutableClassDeclaration mutableClassDeclaration : annotatedTargetElements) {
            TypeReference _newTypeReference = context.newTypeReference(ResultFactory.class, new TypeReference[0]);
            mutableClassDeclaration.setExtendedClass(_newTypeReference);
            this.createHandlerMethod(mutableClassDeclaration, context);
            this.addParametersToActionMethods(mutableClassDeclaration, context);
            this.generatePageNotFound(mutableClassDeclaration, context);
        }
    }

    public void addParametersToActionMethods(MutableClassDeclaration clazz, final @Extension TransformationContext context) {
        Iterable<MutableMethodDeclaration> _httpMethods = this.httpMethods(clazz, context);
        Procedures.Procedure1<MutableMethodDeclaration> _function = new Procedures.Procedure1<MutableMethodDeclaration>(){

            public void apply(final MutableMethodDeclaration it) {
                ArrayList _variables = ControllerAnnotationProcessor.this.getVariables(it, context);
                Procedures.Procedure1<String> _function = new Procedures.Procedure1<String>(){

                    public void apply(String v) {
                        TypeReference _string = context.getString();
                        it.addParameter(v, _string);
                    }
                };
                IterableExtensions.forEach((Iterable)_variables, (Procedures.Procedure1)_function);
                TypeReference _string = context.getString();
                it.addParameter("target", _string);
                TypeReference _newTypeReference = context.newTypeReference(Request.class, new TypeReference[0]);
                it.addParameter("baseRequest", _newTypeReference);
                TypeReference _newTypeReference_1 = context.newTypeReference(HttpServletRequest.class, new TypeReference[0]);
                it.addParameter("request", _newTypeReference_1);
                TypeReference _newTypeReference_2 = context.newTypeReference(HttpServletResponse.class, new TypeReference[0]);
                it.addParameter("response", _newTypeReference_2);
            }
        };
        IterableExtensions.forEach(_httpMethods, (Procedures.Procedure1)_function);
    }

    protected MutableMethodDeclaration createHandlerMethod(final MutableClassDeclaration clazz, final @Extension TransformationContext context) {
        Procedures.Procedure1<MutableMethodDeclaration> _function = new Procedures.Procedure1<MutableMethodDeclaration>(){

            public void apply(MutableMethodDeclaration it) {
                TypeReference _primitiveVoid = context.getPrimitiveVoid();
                it.setReturnType(_primitiveVoid);
                TypeReference _string = context.getString();
                it.addParameter("target", _string);
                TypeReference _newTypeReference = context.newTypeReference(Request.class, new TypeReference[0]);
                it.addParameter("baseRequest", _newTypeReference);
                TypeReference _newTypeReference_1 = context.newTypeReference(HttpServletRequest.class, new TypeReference[0]);
                it.addParameter("request", _newTypeReference_1);
                TypeReference _newTypeReference_2 = context.newTypeReference(HttpServletResponse.class, new TypeReference[0]);
                it.addParameter("response", _newTypeReference_2);
                TypeReference _newTypeReference_3 = context.newTypeReference(IOException.class, new TypeReference[0]);
                TypeReference _newTypeReference_4 = context.newTypeReference(ServletException.class, new TypeReference[0]);
                it.setExceptions(new TypeReference[]{_newTypeReference_3, _newTypeReference_4});
                CompilationStrategy _function = new CompilationStrategy(){

                    public CharSequence compile(CompilationStrategy.CompilationContext it) {
                        StringConcatenation _builder = new StringConcatenation();
                        Iterable<MutableMethodDeclaration> _httpMethods = ControllerAnnotationProcessor.this.httpMethods(clazz, context);
                        for (MutableMethodDeclaration m : _httpMethods) {
                            _builder.append((Object)"{");
                            _builder.newLine();
                            _builder.append((Object)"\t");
                            TypeReference _newTypeReference = context.newTypeReference(Matcher.class, new TypeReference[0]);
                            String _javaCode = it.toJavaCode(_newTypeReference);
                            _builder.append((Object)_javaCode, "\t");
                            _builder.append((Object)" matcher = ");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"\t\t");
                            TypeReference _newTypeReference_1 = context.newTypeReference(Pattern.class, new TypeReference[0]);
                            String _javaCode_1 = it.toJavaCode(_newTypeReference_1);
                            _builder.append((Object)_javaCode_1, "\t\t");
                            _builder.append((Object)".compile(\"");
                            String _pattern = ControllerAnnotationProcessor.this.getPattern(m, context);
                            _builder.append((Object)_pattern, "\t\t");
                            _builder.append((Object)"\").matcher(target);");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"\t");
                            _builder.append((Object)"if (request.getMethod().equalsIgnoreCase(\"");
                            Type _httpAnnotation = ControllerAnnotationProcessor.this.httpAnnotation(m, context);
                            String _simpleName = _httpAnnotation.getSimpleName();
                            _builder.append((Object)_simpleName, "\t");
                            _builder.append((Object)"\") && matcher.matches()) {");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"\t\t");
                            _builder.append((Object)"// take parameters from request");
                            _builder.newLine();
                            _builder.append((Object)"\t\t");
                            final ArrayList variables = ControllerAnnotationProcessor.this.getVariables(m, context);
                            _builder.newLineIfNotEmpty();
                            Iterable<? extends MutableParameterDeclaration> _httpParameters = ControllerAnnotationProcessor.this.getHttpParameters(m);
                            Functions.Function1<MutableParameterDeclaration, Boolean> _function = new Functions.Function1<MutableParameterDeclaration, Boolean>(){

                                public Boolean apply(MutableParameterDeclaration it) {
                                    String _simpleName = it.getSimpleName();
                                    boolean _contains = variables.contains(_simpleName);
                                    return !_contains;
                                }
                            };
                            Iterable _filter = IterableExtensions.filter(_httpParameters, (Functions.Function1)_function);
                            for (MutableParameterDeclaration p : _filter) {
                                boolean _isBodyParameter = ControllerAnnotationProcessor.this.isBodyParameter(p, context);
                                if (_isBodyParameter) {
                                    _builder.append((Object)"\t\t");
                                    _builder.append((Object)"String ");
                                    String _simpleName_1 = p.getSimpleName();
                                    _builder.append((Object)_simpleName_1, "\t\t");
                                    _builder.append((Object)" = readBodyAsString(request);");
                                    _builder.newLineIfNotEmpty();
                                    continue;
                                }
                                _builder.append((Object)"\t\t");
                                _builder.append((Object)"String ");
                                String _simpleName_2 = p.getSimpleName();
                                _builder.append((Object)_simpleName_2, "\t\t");
                                _builder.append((Object)" = request.getParameter(\"");
                                String _simpleName_3 = p.getSimpleName();
                                _builder.append((Object)_simpleName_3, "\t\t");
                                _builder.append((Object)"\");");
                                _builder.newLineIfNotEmpty();
                            }
                            _builder.append((Object)"\t\t");
                            _builder.newLine();
                            _builder.append((Object)"\t\t");
                            _builder.append((Object)"// take variables from url");
                            _builder.newLine();
                            _builder.append((Object)"\t\t");
                            int i = 0;
                            _builder.newLineIfNotEmpty();
                            for (String v : variables) {
                                _builder.append((Object)"\t\t");
                                _builder.append((Object)"String ");
                                _builder.append((Object)v, "\t\t");
                                _builder.append((Object)" = matcher.group(");
                                _builder.append((Object)(++i), "\t\t");
                                _builder.append((Object)");");
                                _builder.newLineIfNotEmpty();
                            }
                            _builder.append((Object)"\t\t");
                            _builder.newLine();
                            _builder.append((Object)"\t\t");
                            _builder.newLine();
                            _builder.append((Object)"\t    ");
                            TypeReference _newTypeReference_2 = context.newTypeReference(Result.class, new TypeReference[0]);
                            String _javaCode_2 = it.toJavaCode(_newTypeReference_2);
                            _builder.append((Object)_javaCode_2, "\t    ");
                            _builder.append((Object)" result = ");
                            String _simpleName_4 = m.getSimpleName();
                            _builder.append((Object)_simpleName_4, "\t    ");
                            _builder.append((Object)"(");
                            Iterable<? extends MutableParameterDeclaration> _httpParameters_1 = ControllerAnnotationProcessor.this.getHttpParameters(m);
                            Functions.Function1<MutableParameterDeclaration, Boolean> _function_1 = new Functions.Function1<MutableParameterDeclaration, Boolean>(){

                                public Boolean apply(MutableParameterDeclaration it) {
                                    String _simpleName = it.getSimpleName();
                                    boolean _contains = variables.contains(_simpleName);
                                    return !_contains;
                                }
                            };
                            Iterable _filter_1 = IterableExtensions.filter(_httpParameters_1, (Functions.Function1)_function_1);
                            Functions.Function1<MutableParameterDeclaration, String> _function_2 = new Functions.Function1<MutableParameterDeclaration, String>(){

                                public String apply(MutableParameterDeclaration it) {
                                    String _simpleName = it.getSimpleName();
                                    return _simpleName + ", ";
                                }
                            };
                            Iterable _map = IterableExtensions.map((Iterable)_filter_1, (Functions.Function1)_function_2);
                            String _join = IterableExtensions.join((Iterable)_map);
                            _builder.append((Object)_join, "\t    ");
                            Functions.Function1<String, String> _function_3 = new Functions.Function1<String, String>(){

                                public String apply(String it) {
                                    return it + ", ";
                                }
                            };
                            List _map_1 = ListExtensions.map((List)variables, (Functions.Function1)_function_3);
                            String _join_1 = IterableExtensions.join((Iterable)_map_1);
                            _builder.append((Object)_join_1, "\t    ");
                            _builder.append((Object)"target, baseRequest, request, response);");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"\t    ");
                            _builder.append((Object)"result.process(response);");
                            _builder.newLine();
                            _builder.append((Object)"\t    ");
                            _builder.newLine();
                            _builder.append((Object)"\t    ");
                            _builder.append((Object)"baseRequest.setHandled(true);");
                            _builder.newLine();
                            _builder.append((Object)"\t    ");
                            _builder.append((Object)"return;");
                            _builder.newLine();
                            _builder.append((Object)"\t");
                            _builder.append((Object)"}");
                            _builder.newLine();
                            _builder.append((Object)"}");
                            _builder.newLine();
                        }
                        _builder.append((Object)"this.pageNotFound(baseRequest, request, response);");
                        _builder.newLine();
                        return _builder;
                    }
                };
                it.setBody(_function);
            }
        };
        return clazz.addMethod("handle", (Procedures.Procedure1)_function);
    }

    public boolean isBodyParameter(MutableParameterDeclaration param, @Extension TransformationContext context) {
        Type _findTypeGlobally = context.findTypeGlobally(Body.class);
        AnnotationReference _findAnnotation = param.findAnnotation(_findTypeGlobally);
        return !Objects.equal((Object)_findAnnotation, null);
    }

    public MutableMethodDeclaration generatePageNotFound(final MutableClassDeclaration clazz, final @Extension TransformationContext context) {
        Procedures.Procedure1<MutableMethodDeclaration> _function = new Procedures.Procedure1<MutableMethodDeclaration>(){

            public void apply(MutableMethodDeclaration it) {
                TypeReference _primitiveVoid = context.getPrimitiveVoid();
                it.setReturnType(_primitiveVoid);
                TypeReference _newTypeReference = context.newTypeReference(Request.class, new TypeReference[0]);
                it.addParameter("baseRequest", _newTypeReference);
                TypeReference _newTypeReference_1 = context.newTypeReference(HttpServletRequest.class, new TypeReference[0]);
                it.addParameter("request", _newTypeReference_1);
                TypeReference _newTypeReference_2 = context.newTypeReference(HttpServletResponse.class, new TypeReference[0]);
                it.addParameter("response", _newTypeReference_2);
                TypeReference _newTypeReference_3 = context.newTypeReference(IOException.class, new TypeReference[0]);
                TypeReference _newTypeReference_4 = context.newTypeReference(ServletException.class, new TypeReference[0]);
                it.setExceptions(new TypeReference[]{_newTypeReference_3, _newTypeReference_4});
                CompilationStrategy _function = new CompilationStrategy(){

                    public CharSequence compile(CompilationStrategy.CompilationContext it) {
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append((Object)"response.getWriter().write(");
                        _builder.newLine();
                        _builder.append((Object)"\"<html><head><title>XtRest - Page Not Found!</title></head>\" ");
                        _builder.newLine();
                        _builder.append((Object)"+\"<body>\"");
                        _builder.newLine();
                        _builder.append((Object)"+\"\t<h1>Page Not Found !</h1>\"");
                        _builder.newLine();
                        _builder.append((Object)"+\"\tSupported resources:\"");
                        _builder.newLine();
                        _builder.append((Object)"+\"\t<table>\"");
                        _builder.newLine();
                        _builder.append((Object)"+\"\t\t<thead><tr><th>Verb</th><th>URL</th><th>Parameters</th></tr></thead>\"");
                        _builder.newLine();
                        _builder.append((Object)"+\"\t\t<tbody>\"");
                        _builder.newLine();
                        Iterable<MutableMethodDeclaration> _httpMethods = ControllerAnnotationProcessor.this.httpMethods(clazz, context);
                        for (MutableMethodDeclaration m : _httpMethods) {
                            _builder.append((Object)"+\"\t\t\t<tr>\"");
                            _builder.newLine();
                            _builder.append((Object)"+\"\t\t\t\t<td>");
                            Type _httpAnnotation = ControllerAnnotationProcessor.this.httpAnnotation(m, context);
                            String _simpleName = _httpAnnotation.getSimpleName();
                            String _upperCase = _simpleName.toUpperCase();
                            _builder.append((Object)_upperCase, "");
                            _builder.append((Object)"</td>\"");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"+\"\t\t\t\t<td>");
                            String _url = ControllerAnnotationProcessor.this.getUrl(m, context);
                            _builder.append((Object)_url, "");
                            _builder.append((Object)"</td>\"");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"+\"\t\t\t\t<td>");
                            Iterable<? extends MutableParameterDeclaration> _httpParameters = ControllerAnnotationProcessor.this.getHttpParameters(m);
                            Functions.Function1<MutableParameterDeclaration, String> _function = new Functions.Function1<MutableParameterDeclaration, String>(){

                                public String apply(MutableParameterDeclaration it) {
                                    return it.getSimpleName();
                                }
                            };
                            Iterable _map = IterableExtensions.map(_httpParameters, (Functions.Function1)_function);
                            String _join = IterableExtensions.join((Iterable)_map, (CharSequence)", ");
                            _builder.append((Object)_join, "");
                            _builder.append((Object)"</td>\"");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"+\"\t\t\t</tr>\"");
                            _builder.newLine();
                        }
                        _builder.append((Object)"+\"\t\t</tbody>\"");
                        _builder.newLine();
                        _builder.append((Object)"+\"\t</table>\"");
                        _builder.newLine();
                        _builder.append((Object)"+\"</body>\"");
                        _builder.newLine();
                        _builder.append((Object)");");
                        _builder.newLine();
                        _builder.append((Object)"response.setStatus(404);");
                        _builder.newLine();
                        _builder.append((Object)"baseRequest.setHandled(true);");
                        _builder.newLine();
                        return _builder;
                    }
                };
                it.setBody(_function);
            }
        };
        return clazz.addMethod("pageNotFound", (Procedures.Procedure1)_function);
    }

    public Iterable<MutableMethodDeclaration> httpMethods(final MutableClassDeclaration clazz, final @Extension TransformationContext context) {
        Iterable _xblockexpression = null;
        Functions.Function1<Class<? extends Annotation>, Type> _function = new Functions.Function1<Class<? extends Annotation>, Type>(){

            public Type apply(Class<? extends Annotation> it) {
                return context.findTypeGlobally(it);
            }
        };
        List verbAnnotations = ListExtensions.map(verbs, (Functions.Function1)_function);
        Functions.Function1<Type, Iterable<? extends MutableMethodDeclaration>> _function_1 = new Functions.Function1<Type, Iterable<? extends MutableMethodDeclaration>>(){

            public Iterable<? extends MutableMethodDeclaration> apply(final Type annotation) {
                Iterable _declaredMethods = clazz.getDeclaredMethods();
                Functions.Function1<MutableMethodDeclaration, Boolean> _function = new Functions.Function1<MutableMethodDeclaration, Boolean>(){

                    public Boolean apply(MutableMethodDeclaration it) {
                        AnnotationReference _findAnnotation = it.findAnnotation(annotation);
                        Object _value = null;
                        if (_findAnnotation != null) {
                            _value = _findAnnotation.getValue("value");
                        }
                        return !Objects.equal(_value, null);
                    }
                };
                return IterableExtensions.filter((Iterable)_declaredMethods, (Functions.Function1)_function);
            }
        };
        List _map = ListExtensions.map((List)verbAnnotations, (Functions.Function1)_function_1);
        _xblockexpression = Iterables.concat((Iterable)_map);
        return _xblockexpression;
    }

    private String getUrl(MutableMethodDeclaration m, @Extension TransformationContext context) {
        Type _httpAnnotation = this.httpAnnotation(m, context);
        AnnotationReference _findAnnotation = m.findAnnotation(_httpAnnotation);
        Object _value = _findAnnotation.getValue("value");
        return _value.toString();
    }

    public Iterable<? extends MutableParameterDeclaration> getHttpParameters(MutableMethodDeclaration m) {
        Iterable _parameters = m.getParameters();
        Functions.Function1<MutableParameterDeclaration, Boolean> _function = new Functions.Function1<MutableParameterDeclaration, Boolean>(){

            public Boolean apply(MutableParameterDeclaration it) {
                String _simpleName = it.getSimpleName();
                boolean _contains = ADDED_PARAMETER.contains(_simpleName);
                return !_contains;
            }
        };
        return IterableExtensions.filter((Iterable)_parameters, (Functions.Function1)_function);
    }

    private String getPattern(MutableMethodDeclaration m, @Extension TransformationContext context) {
        Pair<String, ArrayList<String>> _variablesAndGroupedPattern = this.getVariablesAndGroupedPattern(m, context);
        return (String)_variablesAndGroupedPattern.getKey();
    }

    private ArrayList<String> getVariables(MutableMethodDeclaration m, @Extension TransformationContext context) {
        Pair<String, ArrayList<String>> _variablesAndGroupedPattern = this.getVariablesAndGroupedPattern(m, context);
        return (ArrayList)_variablesAndGroupedPattern.getValue();
    }

    public Type httpAnnotation(final MutableMethodDeclaration m, final @Extension TransformationContext context) {
        Type _xblockexpression = null;
        Functions.Function1<Class<? extends Annotation>, Type> _function = new Functions.Function1<Class<? extends Annotation>, Type>(){

            public Type apply(Class<? extends Annotation> it) {
                return context.findTypeGlobally(it);
            }
        };
        List verbAnnotations = ListExtensions.map(verbs, (Functions.Function1)_function);
        Functions.Function1<Type, Boolean> _function_1 = new Functions.Function1<Type, Boolean>(){

            public Boolean apply(Type it) {
                AnnotationReference _findAnnotation = m.findAnnotation(it);
                return !Objects.equal((Object)_findAnnotation, null);
            }
        };
        _xblockexpression = (Type)IterableExtensions.findFirst((Iterable)verbAnnotations, (Functions.Function1)_function_1);
        return _xblockexpression;
    }

    private Pair<String, ArrayList<String>> getVariablesAndGroupedPattern(MutableMethodDeclaration m, @Extension TransformationContext context) {
        String _url = this.getUrl(m, context);
        return this.createRegexp(_url);
    }

    public Pair<String, ArrayList<String>> createRegexp(String pattern) {
        boolean _lessThan;
        Pattern _compile = Pattern.compile("(:\\w+)");
        Matcher variableMatcher = _compile.matcher(pattern);
        StringBuilder builder = new StringBuilder();
        int i = 0;
        ArrayList variables = CollectionLiterals.newArrayList((Object[])new String[0]);
        while (variableMatcher.find()) {
            int _end;
            String _group = variableMatcher.group();
            String _substring = _group.substring(1);
            variables.add(_substring);
            int _start = variableMatcher.start();
            String _substring_1 = pattern.substring(i, _start);
            String _replace = _substring_1.replace("/", "\\/");
            builder.append(_replace);
            builder.append("(\\w+)");
            i = _end = variableMatcher.end();
        }
        int _length = pattern.length();
        boolean bl = _lessThan = i < _length;
        if (_lessThan) {
            int _length_1 = pattern.length();
            String _substring = pattern.substring(i, _length_1);
            builder.append(_substring);
        }
        String _string = builder.toString();
        return Pair.of((Object)_string, (Object)variables);
    }
}

