package org.uqbar.xtrest;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Map;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function0;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import org.junit.Assert;
import org.junit.Test;
import org.uqbar.xtrest.Person;
import org.uqbar.xtrest.json.JSONUtils;

@SuppressWarnings("all")
public class JSONUtilTest {
  private final Person jenniferCapriati = ObjectExtensions.<Person>operator_doubleArrow(new Person(), new Procedure1<Person>() {
    @Override
    public void apply(final Person it) {
      it.setName("Jennifer Capriati");
      it.setAge(41);
    }
  });
  
  private String jsonPerson = new Function0<String>() {
    public String apply() {
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("{");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("\"name\": \"Jennifer Capriati\",");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("\"age\": 41,");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("\"birth\": \"29/03/1976\",");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("\"amount\": 541.44");
      _builder.newLine();
      _builder.append("}");
      _builder.newLine();
      return _builder.toString();
    }
  }.apply();
  
  @Extension
  private JSONUtils _jSONUtils = new JSONUtils();
  
  @Test
  public void mapOfProperties() {
    final Map<String, String> properties = this._jSONUtils.getProperties(this.jsonPerson);
    String _get = properties.get("name");
    Assert.assertEquals("Jennifer Capriati", _get);
    String _get_1 = properties.get("age");
    Assert.assertEquals("41", _get_1);
  }
  
  @Test
  public void getPropertyString() {
    String _propertyValue = this._jSONUtils.getPropertyValue(this.jsonPerson, "name");
    Assert.assertEquals("Jennifer Capriati", _propertyValue);
  }
  
  @Test
  public void getPropertyInt() {
    Integer _propertyAsInteger = this._jSONUtils.getPropertyAsInteger(this.jsonPerson, "age");
    Assert.assertEquals(41, (_propertyAsInteger).intValue());
  }
  
  @Test
  public void getPropertyDecimal() {
    BigDecimal _bigDecimal = new BigDecimal("541.44");
    BigDecimal _propertyAsDecimal = this._jSONUtils.getPropertyAsDecimal(this.jsonPerson, "amount");
    Assert.assertEquals(_bigDecimal, _propertyAsDecimal);
  }
  
  @Test
  public void getPropertyDate() {
    LocalDate _of = LocalDate.of(1976, 3, 29);
    LocalDate _propertyAsDate = this._jSONUtils.getPropertyAsDate(this.jsonPerson, "birth");
    Assert.assertEquals(_of, _propertyAsDate);
  }
  
  @Test
  public void convertingToJsonAndBackToObject() {
    String _json = this._jSONUtils.toJson(this.jenniferCapriati);
    final Person jenniferConverted = this._jSONUtils.<Person>fromJson(_json, Person.class);
    String _name = jenniferConverted.getName();
    String _name_1 = this.jenniferCapriati.getName();
    Assert.assertEquals(_name, _name_1);
    int _age = jenniferConverted.getAge();
    int _age_1 = this.jenniferCapriati.getAge();
    Assert.assertEquals(_age, _age_1);
  }
  
  @Test
  public void convertingToJsonWithIgnoredProperties() {
    final Person jenniferJSON = this._jSONUtils.<Person>fromJson(this.jsonPerson, Person.class);
    String _name = jenniferJSON.getName();
    Assert.assertEquals(_name, "Jennifer Capriati");
  }
}
