/*
 * Decompiled with CFR 0.152.
 */
package org.uqbar.xtrest;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Map;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.junit.Assert;
import org.junit.Test;
import org.uqbar.xtrest.Person;
import org.uqbar.xtrest.json.JSONUtils;

public class JSONUtilTest {
    private final Person jenniferCapriati = (Person)ObjectExtensions.operator_doubleArrow((Object)new Person(), (Procedures.Procedure1)new Procedures.Procedure1<Person>(){

        public void apply(Person it) {
            it.setName("Jennifer Capriati");
            it.setAge(41);
        }
    });
    private String jsonPerson = new Functions.Function0<String>(){

        public String apply() {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"{");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\"name\": \"Jennifer Capriati\",");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\"age\": 41,");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\"birth\": \"29/03/1976\",");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\"amount\": 541.44");
            _builder.newLine();
            _builder.append((Object)"}");
            _builder.newLine();
            return _builder.toString();
        }
    }.apply();
    @Extension
    private JSONUtils _jSONUtils = new JSONUtils();

    @Test
    public void mapOfProperties() {
        Map properties = this._jSONUtils.getProperties(this.jsonPerson);
        String _get = (String)properties.get("name");
        Assert.assertEquals((Object)"Jennifer Capriati", (Object)_get);
        String _get_1 = (String)properties.get("age");
        Assert.assertEquals((Object)"41", (Object)_get_1);
    }

    @Test
    public void getPropertyString() {
        String _propertyValue = this._jSONUtils.getPropertyValue(this.jsonPerson, "name");
        Assert.assertEquals((Object)"Jennifer Capriati", (Object)_propertyValue);
    }

    @Test
    public void getPropertyInt() {
        Integer _propertyAsInteger = this._jSONUtils.getPropertyAsInteger(this.jsonPerson, "age");
        Assert.assertEquals((long)41L, (long)_propertyAsInteger.intValue());
    }

    @Test
    public void getPropertyDecimal() {
        BigDecimal _bigDecimal = new BigDecimal("541.44");
        BigDecimal _propertyAsDecimal = this._jSONUtils.getPropertyAsDecimal(this.jsonPerson, "amount");
        Assert.assertEquals((Object)_bigDecimal, (Object)_propertyAsDecimal);
    }

    @Test
    public void getPropertyDate() {
        LocalDate _of = LocalDate.of(1976, 3, 29);
        LocalDate _propertyAsDate = this._jSONUtils.getPropertyAsDate(this.jsonPerson, "birth");
        Assert.assertEquals((Object)_of, (Object)_propertyAsDate);
    }

    @Test
    public void convertingToJsonAndBackToObject() {
        String _json = this._jSONUtils.toJson((Object)this.jenniferCapriati);
        Person jenniferConverted = (Person)this._jSONUtils.fromJson(_json, Person.class);
        String _name = jenniferConverted.getName();
        String _name_1 = this.jenniferCapriati.getName();
        Assert.assertEquals((Object)_name, (Object)_name_1);
        int _age = jenniferConverted.getAge();
        int _age_1 = this.jenniferCapriati.getAge();
        Assert.assertEquals((long)_age, (long)_age_1);
    }

    @Test
    public void convertingToJsonWithIgnoredProperties() {
        Person jenniferJSON = (Person)this._jSONUtils.fromJson(this.jsonPerson, Person.class);
        String _name = jenniferJSON.getName();
        Assert.assertEquals((Object)_name, (Object)"Jennifer Capriati");
    }
}

